/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templatetwo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsException;
import org.opencms.util.CmsStringUtil;

public class CmsTemplateMenu
extends CmsJspActionElement {
    private Map m_children;
    private Map m_current;
    private List m_elements;
    private Map m_navText;

    public CmsTemplateMenu() {
    }

    public CmsTemplateMenu(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this();
        this.init(context, req, res);
    }

    public List getElements() {
        return this.m_elements;
    }

    public Map getHasChildren() {
        if (this.m_children == null) {
            this.m_children = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    CmsJspNavElement next;
                    CmsJspNavElement elem = (CmsJspNavElement)input;
                    int currentLevel = elem.getNavTreeLevel();
                    int index = CmsTemplateMenu.this.getElements().indexOf(elem);
                    if (index < CmsTemplateMenu.this.getElements().size() - 1 && (next = (CmsJspNavElement)CmsTemplateMenu.this.getElements().get(index + 1)).getNavTreeLevel() > currentLevel) {
                        return new Boolean(true);
                    }
                    return new Boolean(false);
                }
            });
        }
        return this.m_children;
    }

    public Map getIsCurrent() {
        if (this.m_current == null) {
            this.m_current = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    String parentPath;
                    CmsJspNavElement elem = (CmsJspNavElement)input;
                    String uri = CmsTemplateMenu.this.getCmsObject().getRequestContext().getUri();
                    CmsJspNavElement uriElem = null;
                    try {
                        uriElem = new CmsJspNavElement(uri, CmsProperty.toMap((List)CmsTemplateMenu.this.getCmsObject().readPropertyObjects(uri, false)));
                    }
                    catch (CmsException ex) {
                        // empty catch block
                    }
                    if (elem.getResourceName().equals(uri)) {
                        return new Boolean(true);
                    }
                    String path = CmsJspNavBuilder.getDefaultFile((CmsObject)CmsTemplateMenu.this.getCmsObject(), (String)elem.getResourceName());
                    if (path == null || uriElem != null && uriElem.isInNavigation()) {
                        path = elem.getResourceName();
                    }
                    if (uri.equals(path)) {
                        return new Boolean(true);
                    }
                    CmsJspNavElement navElem = uriElem;
                    while (navElem != null && !navElem.isInNavigation() && (parentPath = CmsResource.getParentFolder((String)navElem.getResourceName())) != null) {
                        try {
                            navElem = new CmsJspNavElement(parentPath, CmsProperty.toMap((List)CmsTemplateMenu.this.getCmsObject().readPropertyObjects(parentPath, false)));
                        }
                        catch (CmsException ex) {
                            break;
                        }
                    }
                    if (navElem != null && uriElem != null && !uriElem.isInNavigation()) {
                        return new Boolean(elem.equals((Object)navElem));
                    }
                    return new Boolean(false);
                }
            });
        }
        return this.m_current;
    }

    public boolean getIsDefault() {
        String path = CmsJspNavBuilder.getDefaultFile((CmsObject)this.getCmsObject(), (String)CmsResource.getFolderPath((String)this.getRequestContext().getUri()));
        if (path != null) {
            return path.equals(this.getRequestContext().getUri());
        }
        return false;
    }

    public Map getNavText() {
        if (this.m_navText == null) {
            this.m_navText = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    CmsJspNavElement elem = (CmsJspNavElement)input;
                    String text = elem.getProperty("NavText");
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)text)) {
                        text = elem.getProperty("Title");
                    }
                    return text;
                }
            });
        }
        return this.m_navText;
    }

    public int getTopLevel() {
        if (this.m_elements == null || this.m_elements.isEmpty()) {
            return 0;
        }
        CmsJspNavElement elem = (CmsJspNavElement)this.m_elements.get(0);
        if (elem == null) {
            return 0;
        }
        return elem.getNavTreeLevel();
    }

    public void setElements(List elements) {
        this.m_elements = elements;
    }
}

