/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexCache;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsRuntimeException;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.cache.Messages;

public class CmsFlexCacheList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_KEY = "ck";
    public static final String LIST_COLUMN_PROJECT = "cp";
    public static final String LIST_COLUMN_RESOURCE = "cr";
    public static final String LIST_DETAIL_VARIATIONS = "dv";
    public static final String LIST_ID = "lfc";

    public CmsFlexCacheList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_FLEXCACHE_LIST_NAME_0"), LIST_COLUMN_RESOURCE, CmsListOrderEnum.ORDER_ASCENDING, LIST_COLUMN_RESOURCE);
    }

    public CmsFlexCacheList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String defaultActionHtmlStart() {
        return this.getList().listJs() + this.dialogContentStart(this.getParamTitle());
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() {
        this.throwListUnsupportedActionException();
    }

    protected void fillDetails(String detailId) {
        CmsObject cms = this.getCms();
        CmsFlexController controller = (CmsFlexController)this.getJsp().getRequest().getAttribute("org.opencms.flex.CmsFlexController");
        CmsFlexCache cache = controller.getCmsCache();
        List entries = this.getList().getAllContent();
        Iterator itEntries = entries.iterator();
        while (itEntries.hasNext()) {
            CmsListItem item = (CmsListItem)itEntries.next();
            String resName = item.getId();
            StringBuffer html = new StringBuffer(512);
            try {
                if (!detailId.equals(LIST_DETAIL_VARIATIONS)) continue;
                ArrayList variations = new ArrayList(cache.getCachedVariations(resName, cms));
                Collections.sort(variations);
                Iterator itVariations = variations.iterator();
                while (itVariations.hasNext()) {
                    String var = (String)itVariations.next();
                    html.append(var);
                    if (itVariations.hasNext()) {
                        html.append("<br>");
                    }
                    html.append("\n");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected List getListItems() {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        CmsFlexController controller = (CmsFlexController)this.getJsp().getRequest().getAttribute("org.opencms.flex.CmsFlexController");
        CmsFlexCache cache = controller.getCmsCache();
        Iterator itResources = new ArrayList(cache.getCachedResources(this.getCms())).iterator();
        while (itResources.hasNext()) {
            String resource = (String)itResources.next();
            CmsListItem item = this.getList().newItem(resource);
            String resName = resource;
            String project = "";
            if (resource.endsWith(" [offline]")) {
                resName = resource.substring(0, resource.length() - " [offline]".length());
                project = "Offline";
            }
            if (resource.endsWith(" [online]")) {
                resName = resource.substring(0, resource.length() - " [online]".length());
                project = "Online";
            }
            item.set(LIST_COLUMN_RESOURCE, (Object)resName);
            item.set(LIST_COLUMN_PROJECT, (Object)project);
            item.set(LIST_COLUMN_KEY, (Object)cache.getCachedKey(resource, this.getCms()));
            ret.add(item);
        }
        return ret;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_FLEXCACHE_LIST_COLS_ICON_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        CmsListDirectAction iconAction = new CmsListDirectAction(LIST_ACTION_ICON);
        iconAction.setName(Messages.get().container("GUI_FLEXCACHE_LIST_ACTION_ICON_NAME_0"));
        iconAction.setIconPath("tools/cache/buttons/flexentry.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)iconAction);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_RESOURCE);
        nameCol.setName(Messages.get().container("GUI_FLEXCACHE_LIST_COLS_RESOURCE_0"));
        nameCol.setWidth("60%");
        metadata.addColumn(nameCol);
        CmsListColumnDefinition projectCol = new CmsListColumnDefinition(LIST_COLUMN_PROJECT);
        projectCol.setName(Messages.get().container("GUI_FLEXCACHE_LIST_COLS_PROJECT_0"));
        projectCol.setWidth("15%");
        metadata.addColumn(projectCol);
        CmsListColumnDefinition keyCol = new CmsListColumnDefinition(LIST_COLUMN_KEY);
        keyCol.setName(Messages.get().container("GUI_FLEXCACHE_LIST_COLS_KEY_0"));
        keyCol.setWidth("25%");
        metadata.addColumn(keyCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails variationsDetails = new CmsListItemDetails(LIST_DETAIL_VARIATIONS);
        variationsDetails.setAtColumn(LIST_COLUMN_RESOURCE);
        variationsDetails.setVisible(false);
        variationsDetails.setShowActionName(Messages.get().container("GUI_FLEXCACHE_DETAIL_SHOW_VARIATIONS_NAME_0"));
        variationsDetails.setShowActionHelpText(Messages.get().container("GUI_FLEXCACHE_DETAIL_SHOW_VARIATIONS_HELP_0"));
        variationsDetails.setHideActionName(Messages.get().container("GUI_FLEXCACHE_DETAIL_HIDE_VARIATIONS_NAME_0"));
        variationsDetails.setHideActionHelpText(Messages.get().container("GUI_FLEXCACHE_DETAIL_HIDE_VARIATIONS_HELP_0"));
        variationsDetails.setName(Messages.get().container("GUI_FLEXCACHE_DETAIL_VARIATIONS_NAME_0"));
        variationsDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_FLEXCACHE_DETAIL_VARIATIONS_NAME_0")));
        metadata.addItemDetails(variationsDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }
}

