/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsRuntimeException;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOpenResourceAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.cache.CmsImageCacheHelper;
import org.opencms.workplace.tools.cache.Messages;

public class CmsImageCacheList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_LENGTH = "cl";
    public static final String LIST_COLUMN_RESOURCE = "cr";
    public static final String LIST_COLUMN_SIZE = "cs";
    public static final String LIST_DEFACTION_OPEN = "edo";
    public static final String LIST_DETAIL_SIZE = "ds";
    public static final String LIST_DETAIL_VARIATIONS = "dv";
    public static final String LIST_ID = "lfc";

    public CmsImageCacheList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_IMAGECACHE_LIST_NAME_0"), LIST_COLUMN_RESOURCE, CmsListOrderEnum.ORDER_ASCENDING, LIST_COLUMN_RESOURCE);
    }

    public CmsImageCacheList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String defaultActionHtmlStart() {
        return this.getList().listJs() + this.dialogContentStart(this.getParamTitle());
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() {
        this.throwListUnsupportedActionException();
    }

    public boolean showSize() {
        CmsListItemDetails details = this.getList().getMetadata().getItemDetailDefinition(LIST_DETAIL_SIZE);
        return details != null && details.isVisible();
    }

    protected void fillDetails(String detailId) {
        CmsImageCacheHelper helper = new CmsImageCacheHelper(this.getCms(), true, this.showSize(), false);
        List entries = this.getList().getAllContent();
        Iterator itEntries = entries.iterator();
        while (itEntries.hasNext()) {
            CmsListItem item = (CmsListItem)itEntries.next();
            String resName = item.getId();
            StringBuffer html = new StringBuffer(512);
            try {
                Iterator itVariations = helper.getVariations(resName).iterator();
                while (itVariations.hasNext()) {
                    String var = (String)itVariations.next();
                    html.append(var);
                    if (itVariations.hasNext()) {
                        html.append("<br>");
                    }
                    html.append("\n");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(LIST_DETAIL_VARIATIONS, (Object)html.toString());
        }
    }

    protected List getListItems() {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        boolean showSize = this.showSize();
        this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_SIZE).setVisible(showSize);
        String width = "80%";
        if (showSize) {
            width = "60%";
        }
        this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_RESOURCE).setWidth(width);
        CmsImageCacheHelper helper = new CmsImageCacheHelper(this.getCms(), false, showSize, false);
        Iterator itResources = helper.getAllCachedImages().iterator();
        while (itResources.hasNext()) {
            String resource = (String)itResources.next();
            CmsListItem item = this.getList().newItem(resource);
            String resName = resource;
            item.set(LIST_COLUMN_RESOURCE, (Object)resName);
            if (showSize) {
                item.set(LIST_COLUMN_SIZE, (Object)helper.getSize(resName));
            }
            item.set(LIST_COLUMN_LENGTH, (Object)helper.getLength(resName));
            ret.add(item);
        }
        return ret;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_IMAGECACHE_LIST_COLS_ICON_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        CmsListDirectAction iconAction = new CmsListDirectAction(LIST_ACTION_ICON);
        iconAction.setName(Messages.get().container("GUI_IMAGECACHE_LIST_ACTION_ICON_NAME_0"));
        iconAction.setIconPath("tools/cache/buttons/imageentry.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)iconAction);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_RESOURCE);
        nameCol.setName(Messages.get().container("GUI_IMAGECACHE_LIST_COLS_RESOURCE_0"));
        nameCol.setWidth("60%");
        CmsListOpenResourceAction resourceOpenDefAction = new CmsListOpenResourceAction(LIST_DEFACTION_OPEN, LIST_COLUMN_RESOURCE);
        resourceOpenDefAction.setEnabled(true);
        nameCol.addDefaultAction((CmsListDefaultAction)resourceOpenDefAction);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition sizeCol = new CmsListColumnDefinition(LIST_COLUMN_SIZE);
        sizeCol.setName(Messages.get().container("GUI_IMAGECACHE_LIST_COLS_SIZE_0"));
        sizeCol.setWidth("20%");
        metadata.addColumn(sizeCol);
        CmsListColumnDefinition lengthCol = new CmsListColumnDefinition(LIST_COLUMN_LENGTH);
        lengthCol.setName(Messages.get().container("GUI_IMAGECACHE_LIST_COLS_LENGTH_0"));
        lengthCol.setWidth("20%");
        metadata.addColumn(lengthCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails variationsDetails = new CmsListItemDetails(LIST_DETAIL_VARIATIONS);
        variationsDetails.setAtColumn(LIST_COLUMN_RESOURCE);
        variationsDetails.setVisible(false);
        variationsDetails.setShowActionName(Messages.get().container("GUI_IMAGECACHE_DETAIL_SHOW_VARIATIONS_NAME_0"));
        variationsDetails.setShowActionHelpText(Messages.get().container("GUI_IMAGECACHE_DETAIL_SHOW_VARIATIONS_HELP_0"));
        variationsDetails.setHideActionName(Messages.get().container("GUI_IMAGECACHE_DETAIL_HIDE_VARIATIONS_NAME_0"));
        variationsDetails.setHideActionHelpText(Messages.get().container("GUI_IMAGECACHE_DETAIL_HIDE_VARIATIONS_HELP_0"));
        variationsDetails.setName(Messages.get().container("GUI_IMAGECACHE_DETAIL_VARIATIONS_NAME_0"));
        variationsDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_IMAGECACHE_DETAIL_VARIATIONS_NAME_0")));
        metadata.addItemDetails(variationsDetails);
        CmsListItemDetails sizeDetails = new CmsListItemDetails(LIST_DETAIL_SIZE);
        sizeDetails.setShowActionName(Messages.get().container("GUI_IMAGECACHE_DETAIL_SHOW_SIZE_NAME_0"));
        sizeDetails.setShowActionHelpText(Messages.get().container("GUI_IMAGECACHE_DETAIL_SHOW_SIZE_HELP_0"));
        sizeDetails.setHideActionName(Messages.get().container("GUI_IMAGECACHE_DETAIL_HIDE_SIZE_NAME_0"));
        sizeDetails.setHideActionHelpText(Messages.get().container("GUI_IMAGECACHE_DETAIL_HIDE_SIZE_HELP_0"));
        sizeDetails.setName(Messages.get().container("GUI_IMAGECACHE_DETAIL_SIZE_NAME_0"));
        sizeDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_IMAGECACHE_DETAIL_SIZE_NAME_0")));
        sizeDetails.setVisible(false);
        metadata.addItemDetails(sizeDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }
}

