/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.cache;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.tools.cache.CmsImageCacheHelper;
import org.opencms.workplace.tools.cache.Messages;

public class CmsImageCacheOverviewDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "image.stats";
    public static final String[] PAGES = new String[]{"page1"};
    private String m_curSize;
    private String m_keys;
    private String m_variations;

    public CmsImageCacheOverviewDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsImageCacheOverviewDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        this.setCommitErrors(new ArrayList());
    }

    public String getCurSize() {
        return this.m_curSize;
    }

    public String getKeys() {
        return this.m_keys;
    }

    public String getVariations() {
        return this.m_variations;
    }

    public void setCurSize(String curSize) {
        this.m_curSize = curSize;
    }

    public void setKeys(String keys) {
        this.m_keys = keys;
    }

    public void setVariations(String variations) {
        this.m_variations = variations;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_IMAGECACHE_LABEL_STATS_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 1));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_IMAGECACHE_LABEL_MEMORY_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(2, 2));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String defaultActionHtmlEnd() {
        return "";
    }

    protected void defineWidgets() {
        this.initCacheObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "keys", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "variations", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "curSize", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initCacheObject() {
        CmsImageCacheHelper helper = new CmsImageCacheHelper(this.getCms(), false, false, true);
        this.setKeys("" + helper.getFilesCount());
        this.setVariations("" + helper.getVariationsCount());
        this.setCurSize("" + helper.getVariationsSize() / 1024 + "Kb");
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        super.initWorkplaceMembers(jsp);
        this.setOnlineHelpUriCustom("/cache/flex/");
    }
}

