/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.database;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.database.Messages;

public class CmsDatabaseImportFromServer
extends CmsWidgetDialog {
    public static final String DIALOG_TYPE = "DatabaseImportServer";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_IMPORTFILE = "importFile";
    public static final String PARAM_KEEPPERMISSIONS = "keepPermissions";
    protected static final String IMPORT_ACTION_REPORT = "/system/workplace/admin/database/reports/import.jsp";
    private static final String FILE_MANIFEST = "manifest.xml";
    private static final String FOLDER_MODULES = "modules";
    private String m_importFile;
    private String m_keepPermissions;

    public CmsDatabaseImportFromServer(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDatabaseImportFromServer(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected static List getFileListFromServer(boolean includeFolders) {
        ArrayList<String> result = new ArrayList<String>();
        String exportpath = OpenCms.getSystemInfo().getPackagesRfsPath();
        File folder = new File(exportpath);
        String[] files = folder.list();
        for (int i = 0; i < files.length; ++i) {
            File diskFile = new File(exportpath, files[i]);
            if (diskFile.isFile() && diskFile.getName().endsWith(".zip")) {
                result.add(diskFile.getName());
                continue;
            }
            if (!diskFile.isDirectory() || !includeFolders || diskFile.getName().equalsIgnoreCase(FOLDER_MODULES) || !new File(diskFile + File.separator + FILE_MANIFEST).exists()) continue;
            result.add(diskFile.getName());
        }
        return result;
    }

    public void actionCommit() throws IOException, ServletException {
        ArrayList errors = new ArrayList();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file", this.getImportFile());
        params.put(PARAM_KEEPPERMISSIONS, this.getKeepPermissions());
        params.put("style", "new");
        params.put("closelink", CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)"/database"));
        this.getToolManager().jspForwardPage((CmsWorkplace)this, IMPORT_ACTION_REPORT, params);
        this.setCommitErrors(errors);
    }

    public String getImportFile() {
        return this.m_importFile;
    }

    public String getKeepPermissions() {
        return this.m_keepPermissions;
    }

    public void setImportFile(String importFile) {
        this.m_importFile = importFile;
    }

    public void setKeepPermissions(String keepPermissions) {
        this.m_keepPermissions = keepPermissions;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("label.block.importFileFromServer")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, this.getFilesFromServer().isEmpty() ? 0 : 1));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        List files = this.getFilesFromServer();
        if (files.isEmpty()) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, PARAM_IMPORTFILE, PAGES[0], (I_CmsWidget)new CmsDisplayWidget(this.key("GUI_IMPORTSERVER_NO_DB_EXPORTS_0"))));
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, PARAM_IMPORTFILE, PAGES[0], (I_CmsWidget)new CmsSelectWidget(files)));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, PARAM_KEEPPERMISSIONS, PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        }
    }

    protected List getFilesFromServer() {
        ArrayList<CmsSelectWidgetOption> retVal = new ArrayList<CmsSelectWidgetOption>();
        Iterator i = CmsDatabaseImportFromServer.getFileListFromServer(true).iterator();
        while (i.hasNext()) {
            String fileName = (String)i.next();
            retVal.add(new CmsSelectWidgetOption(fileName));
        }
        return retVal;
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(DIALOG_TYPE);
        super.initWorkplaceRequestValues(settings, request);
    }
}

