/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.database;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbIoException;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.loader.CmsResourceManager;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.report.I_CmsReport;
import org.opencms.staticexport.CmsLinkTable;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.tools.database.CmsHtmlImportConverter;
import org.opencms.workplace.tools.database.Messages;
import org.opencms.xml.page.CmsXmlPage;

public class CmsHtmlImport {
    public static final String META_PROPERTIES = "meta.properties";
    private static final Log LOG = CmsLog.getLog((Object)CmsHtmlImport.class);
    private CmsObject m_cmsObject;
    private String m_destinationDir;
    private String m_downloadGallery;
    private String m_element;
    private String m_endPattern;
    private Map m_extensions = OpenCms.getResourceManager().getExtensionMapping();
    private HashSet m_externalLinks;
    private HashMap m_fileIndex = new HashMap();
    private CmsHtmlImportConverter m_htmlConverter;
    private String m_httpDir;
    private String m_imageGallery;
    private HashMap m_imageInfo;
    private String m_inputDir;
    private String m_inputEncoding;
    private boolean m_keepBrokenLinks;
    private String m_linkGallery;
    private String m_locale;
    private boolean m_overwrite = true;
    private HashMap m_parents = new HashMap();
    private I_CmsReport m_report;
    private String m_startPattern;
    private String m_template;

    public static File createTempFolder(String name) throws Exception {
        File folder = null;
        folder = File.createTempFile(name, "", null);
        folder.delete();
        folder.mkdirs();
        folder.deleteOnExit();
        return folder;
    }

    public CmsHtmlImport() {
        this.m_imageInfo = new HashMap();
        this.m_externalLinks = new HashSet();
        this.m_htmlConverter = new CmsHtmlImportConverter(this, false);
    }

    public CmsHtmlImport(CmsObject cms) {
        this();
        this.m_cmsObject = cms;
    }

    public String getAbsoluteUri(String relativeUri, String baseUri) {
        if (relativeUri == null || relativeUri.charAt(0) == '/' || relativeUri.startsWith("#")) {
            return relativeUri;
        }
        String windowsAddition = "";
        if (File.separator.equals("\\")) {
            windowsAddition = ":";
        }
        try {
            URL baseUrl = new URL("file://");
            URL url = new URL(new URL(baseUrl, "file://" + baseUri), relativeUri);
            if (url.getQuery() == null) {
                if (url.getRef() == null) {
                    return url.getHost() + windowsAddition + url.getPath();
                }
                return url.getHost() + windowsAddition + url.getPath() + "#" + url.getRef();
            }
            return url.getHost() + windowsAddition + url.getPath() + "?" + url.getQuery();
        }
        catch (MalformedURLException e) {
            return relativeUri;
        }
    }

    public String getDestinationDir() {
        return this.m_destinationDir;
    }

    public String getDownloadGallery() {
        return this.m_downloadGallery;
    }

    public String getElement() {
        return this.m_element;
    }

    public String getEndPattern() {
        return this.m_endPattern;
    }

    public String getHttpDir() {
        return this.m_httpDir;
    }

    public String getImageGallery() {
        return this.m_imageGallery;
    }

    public String getInputDir() {
        return this.m_inputDir;
    }

    public String getInputEncoding() {
        return this.m_inputEncoding;
    }

    public String getLinkGallery() {
        return this.m_linkGallery;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public String getStartPattern() {
        return this.m_startPattern;
    }

    public String getTemplate() {
        return this.m_template;
    }

    public boolean isKeepBrokenLinks() {
        return this.m_keepBrokenLinks;
    }

    public boolean isOverwrite() {
        return this.m_overwrite;
    }

    public void setCmsObject(CmsObject cmsObject) {
        this.m_cmsObject = cmsObject;
    }

    public void setDestinationDir(String destinationDir) {
        this.m_destinationDir = destinationDir;
    }

    public void setDownloadGallery(String downloadGallery) {
        this.m_downloadGallery = downloadGallery;
    }

    public void setElement(String element) {
        this.m_element = element;
    }

    public void setEndPattern(String endPattern) {
        this.m_endPattern = endPattern;
    }

    public void setHttpDir(String httpDir) {
        this.m_httpDir = httpDir;
    }

    public void setImageGallery(String imageGallery) {
        this.m_imageGallery = imageGallery;
    }

    public void setInputDir(String inputDir) {
        this.m_inputDir = inputDir;
    }

    public void setInputEncoding(String inputEncoding) {
        this.m_inputEncoding = inputEncoding;
    }

    public void setKeepBrokenLinks(boolean keepBrokenLinks) {
        this.m_keepBrokenLinks = keepBrokenLinks;
    }

    public void setLinkGallery(String linkGallery) {
        this.m_linkGallery = linkGallery;
    }

    public void setLocale(String locale) {
        this.m_locale = locale;
    }

    public void setOverwrite(boolean overwrite) {
        this.m_overwrite = overwrite;
    }

    public void setStartPattern(String startPattern) {
        this.m_startPattern = startPattern;
    }

    public void setTemplate(String template) {
        this.m_template = template;
    }

    public void startImport(I_CmsReport report) throws Exception {
        try {
            this.m_report = report;
            this.m_report.println(Messages.get().container("RPT_HTML_IMPORT_BEGIN_0"), 2);
            boolean isStream = !CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_httpDir);
            File streamFolder = null;
            if (isStream) {
                streamFolder = this.unzipStream();
                this.m_inputDir = streamFolder.getAbsolutePath();
            }
            this.buildIndex(this.m_inputDir);
            this.buildParentPath();
            this.copyHtmlFiles(this.m_inputDir);
            this.copyOtherFiles(this.m_inputDir);
            this.createExternalLinks();
            if (isStream && streamFolder != null) {
                this.m_report.println(Messages.get().container("RPT_HTML_DELETE_0"), 3);
                CmsFileUtil.purgeDirectory((File)streamFolder);
                File file = new File(this.m_httpDir);
                if (file.exists() && file.canWrite()) {
                    file.delete();
                }
            }
            this.m_report.println(Messages.get().container("RPT_HTML_IMPORT_END_0"), 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String storeExternalLink(String externalLink) {
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_linkGallery)) {
            this.m_externalLinks.add(externalLink);
            return this.getExternalLinkFile(externalLink);
        }
        return null;
    }

    public void storeImageInfo(String image, String altText) {
        this.m_imageInfo.put(image, altText);
    }

    public String translateLink(String link) {
        String translatedLink = null;
        translatedLink = (String)this.m_fileIndex.get(link.replace('\\', '/'));
        if (translatedLink == null) {
            if (link.startsWith("#")) {
                translatedLink = link;
            } else if (link.startsWith("/")) {
                if (link.startsWith(OpenCms.getSystemInfo().getOpenCmsContext())) {
                    link = link.substring(OpenCms.getSystemInfo().getOpenCmsContext().length());
                }
                if (this.m_keepBrokenLinks || this.m_cmsObject.existsResource(link)) {
                    translatedLink = link;
                }
            } else {
                String fileBase = this.getBasePath(this.m_inputDir, link);
                String cmsBase = (String)this.m_parents.get(fileBase);
                if (cmsBase != null) {
                    String outLink = cmsBase + link.substring(fileBase.length()).replace('\\', '/');
                    if (this.m_keepBrokenLinks || this.m_cmsObject.existsResource(outLink)) {
                        translatedLink = outLink;
                    }
                }
            }
        }
        if (translatedLink != null && translatedLink.endsWith("/")) {
            translatedLink = translatedLink + "index.html";
        }
        if (translatedLink == null) {
            translatedLink = "#";
        }
        return translatedLink;
    }

    public void validate(FileItem fi, boolean isdefault) throws CmsIllegalArgumentException {
        block23: {
            String name;
            CmsFolder folder;
            if (fi == null) {
                File inputDir;
                if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_inputDir) && !isdefault) {
                    throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_INPUTDIR_1", (Object)this.m_inputDir));
                }
                if (!(CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_inputDir) || (inputDir = new File(this.m_inputDir)).exists() && !inputDir.isFile())) {
                    throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_INPUTDIR_1", (Object)this.m_inputDir));
                }
            }
            try {
                if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_destinationDir) && !isdefault) {
                    throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_DESTDIR_1", (Object)this.m_destinationDir));
                }
                if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_destinationDir)) {
                    this.m_cmsObject.readFolder(this.m_destinationDir);
                }
            }
            catch (CmsException e) {
                throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_DESTDIR_1", (Object)this.m_destinationDir), (Throwable)e);
            }
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_imageGallery)) {
                try {
                    folder = this.m_cmsObject.readFolder(this.m_imageGallery);
                    name = OpenCms.getResourceManager().getResourceType(folder.getTypeId()).getTypeName();
                    if (!name.equals("imagegallery")) {
                        throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_IMGGALLERY_INVALID_1", (Object)this.m_imageGallery));
                    }
                }
                catch (CmsException e) {
                    throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_IMGGALLERY_1", (Object)this.m_imageGallery), (Throwable)e);
                }
            }
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_linkGallery)) {
                try {
                    folder = this.m_cmsObject.readFolder(this.m_linkGallery);
                    name = OpenCms.getResourceManager().getResourceType(folder.getTypeId()).getTypeName();
                    if (!name.equals("linkgallery")) {
                        throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_LINKGALLERY_INVALID_1", (Object)this.m_linkGallery));
                    }
                }
                catch (CmsException e) {
                    throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_LINKGALLERY_1", (Object)this.m_linkGallery), (Throwable)e);
                }
            }
            if (!this.isExternal(this.m_downloadGallery) && !CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_downloadGallery)) {
                try {
                    folder = this.m_cmsObject.readFolder(this.m_downloadGallery);
                    name = OpenCms.getResourceManager().getResourceType(folder.getTypeId()).getTypeName();
                    if (!name.equals("downloadgallery")) {
                        throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_DOWNGALLERY_INVALID_1", (Object)this.m_downloadGallery));
                    }
                }
                catch (CmsException e) {
                    throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_DOWNGALLERY_1", (Object)this.m_downloadGallery), (Throwable)e);
                }
            }
            try {
                this.m_cmsObject.readResource(this.m_template, CmsResourceFilter.ALL);
            }
            catch (CmsException e) {
                if (this.isValidElement()) break block23;
                throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_TEMPLATE_1", (Object)this.m_template), (Throwable)e);
            }
        }
        if (!this.isValidElement()) {
            throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_INVALID_ELEM_2", (Object)this.m_element, (Object)this.m_template));
        }
        if (this.m_cmsObject.getRequestContext().currentProject().isOnlineProject()) {
            throw new CmsIllegalArgumentException(Messages.get().container("GUI_HTMLIMPORT_CONSTRAINT_OFFLINE_0"));
        }
    }

    private void buildIndex(String startfolder) throws Exception {
        File folder = new File(startfolder);
        File[] subresources = folder.listFiles();
        for (int i = 0; i < subresources.length; ++i) {
            try {
                String relativeFSName = subresources[i].getAbsolutePath().substring(this.m_inputDir.length() + 1);
                String absoluteVFSName = this.getVfsName(relativeFSName, subresources[i].getName(), subresources[i].isFile());
                this.m_report.print(Messages.get().container("RPT_CREATE_INDEX_0"), 3);
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)relativeFSName.replace('\\', '/')));
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.m_report.print(Messages.get().container("RPT_ARROW_RIGHT_0"), 3);
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)absoluteVFSName));
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.m_fileIndex.put(subresources[i].getAbsolutePath().replace('\\', '/'), absoluteVFSName);
                if (subresources[i].isDirectory()) {
                    this.buildIndex(subresources[i].getAbsolutePath());
                }
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                this.m_report.println((Throwable)e);
            }
        }
    }

    private void buildParentPath() {
        String destFolder = this.m_destinationDir;
        String inputDir = this.m_inputDir.replace('\\', '/');
        if (!inputDir.endsWith("/")) {
            inputDir = inputDir + "/";
        }
        int pos = inputDir.lastIndexOf("/");
        while (pos > 0 && destFolder != null) {
            inputDir = inputDir.substring(0, pos);
            this.m_parents.put(inputDir + "/", destFolder);
            pos = inputDir.lastIndexOf("/", pos - 1);
            destFolder = CmsResource.getParentFolder((String)destFolder);
        }
    }

    private void closeStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception ex) {
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }

    private void copyHtmlFiles(String startfolder) throws Exception {
        try {
            File folder = new File(startfolder);
            File[] subresources = folder.listFiles();
            for (int i = 0; i < subresources.length; ++i) {
                if (subresources[i].isDirectory()) {
                    Hashtable properties = new Hashtable();
                    this.createFolder(subresources[i].getAbsolutePath(), i, properties);
                    this.copyHtmlFiles(subresources[i].getAbsolutePath());
                    continue;
                }
                String vfsFileName = (String)this.m_fileIndex.get(subresources[i].getAbsolutePath().replace('\\', '/'));
                int type = this.getFileType(vfsFileName);
                if (CmsResourceTypePlain.getStaticTypeId() != type) continue;
                Hashtable<String, String> properties = new Hashtable<String, String>();
                String content = "";
                try {
                    content = this.parseHtmlFile(subresources[i], properties);
                }
                catch (CmsException e) {
                    this.m_report.println((Throwable)e);
                }
                properties.put("template", this.m_template);
                this.createFile(subresources[i].getAbsolutePath(), i, content, properties);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyOtherFiles(String startfolder) {
        try {
            File folder = new File(startfolder);
            File[] subresources = folder.listFiles();
            for (int i = 0; i < subresources.length; ++i) {
                if (subresources[i].isDirectory()) {
                    this.copyOtherFiles(subresources[i].getAbsolutePath());
                    continue;
                }
                if (subresources[i].getName().equals(META_PROPERTIES)) continue;
                String vfsFileName = (String)this.m_fileIndex.get(subresources[i].getAbsolutePath().replace('\\', '/'));
                int type = this.getFileType(vfsFileName);
                if (CmsResourceTypePlain.getStaticTypeId() == type) continue;
                if (this.isExternal(vfsFileName)) {
                    this.m_report.print(Messages.get().container("RPT_SKIP_EXTERNAL_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)subresources[i]));
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    this.m_report.print(Messages.get().container("RPT_ARROW_RIGHT_0"), 3);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)vfsFileName));
                    continue;
                }
                this.m_report.print(Messages.get().container("RPT_IMPORT_0"), 3);
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)vfsFileName));
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                byte[] content = this.getFileBytes(subresources[i]);
                ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>();
                String altText = (String)this.m_imageInfo.get(subresources[i].getAbsolutePath().replace('\\', '/'));
                CmsProperty property1 = new CmsProperty("Description", altText, altText);
                CmsProperty property2 = new CmsProperty("Title", altText, altText);
                if (altText != null) {
                    properties.add(property1);
                    properties.add(property2);
                }
                if (!this.m_overwrite) {
                    this.m_cmsObject.createResource(vfsFileName, type, content, properties);
                } else {
                    try {
                        CmsLock lock = this.m_cmsObject.getLock(vfsFileName);
                        if (lock.getType() != CmsLockType.EXCLUSIVE) {
                            this.m_cmsObject.lockResource(vfsFileName);
                        }
                        this.m_cmsObject.deleteResource(vfsFileName, CmsResource.DELETE_PRESERVE_SIBLINGS);
                    }
                    catch (CmsException e) {
                    }
                    finally {
                        this.m_cmsObject.createResource(vfsFileName, type, content, properties);
                    }
                    this.m_report.print(Messages.get().container("RPT_OVERWRITE_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                }
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_report.println((Throwable)e);
        }
    }

    private void createExternalLinks() {
        Iterator i = this.m_externalLinks.iterator();
        while (i.hasNext()) {
            String linkUrl = (String)i.next();
            String filename = this.getExternalLinkFile(linkUrl);
            this.m_report.print(Messages.get().container("RPT_CREATE_EXTERNAL_LINK_0"), 3);
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)filename));
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>();
            CmsProperty property1 = new CmsProperty("Title", "Link to " + linkUrl, "Link to " + linkUrl);
            properties.add(property1);
            try {
                this.m_cmsObject.createResource(this.m_linkGallery + filename, CmsResourceTypePointer.getStaticTypeId(), linkUrl.getBytes(), properties);
            }
            catch (CmsException e) {
                // empty catch block
            }
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createFile(String filename, int position, String content, Hashtable properties) {
        String vfsFileName = (String)this.m_fileIndex.get(filename.replace('\\', '/'));
        if (vfsFileName == null) return;
        try {
            List oldProperties;
            block14: {
                this.m_report.print(Messages.get().container("RPT_CREATE_FILE_0"), 3);
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)vfsFileName));
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                if (properties.get("NavPos") == null && properties.get("NavText") != null) {
                    properties.put("NavPos", position + 1 + "");
                }
                Locale locale = new Locale(this.m_locale);
                CmsXmlPage page = new CmsXmlPage(locale, OpenCms.getSystemInfo().getDefaultEncoding());
                page.addValue(this.m_element, locale);
                page.setStringValue(this.m_cmsObject, this.m_element, locale, content);
                CmsLinkTable linkTable = page.getLinkTable(this.m_element, locale);
                Iterator i = linkTable.iterator();
                while (i.hasNext()) {
                    CmsLink link = (CmsLink)i.next();
                    String target = link.getTarget();
                    if (!link.isInternal()) continue;
                    target = this.m_cmsObject.getRequestContext().getFileTranslator().translateResource(target);
                    link.updateLink(target, link.getAnchor(), link.getQuery());
                    link.checkConsistency(this.m_cmsObject);
                }
                byte[] contentByteArray = page.marshal();
                oldProperties = new ArrayList();
                if (!this.m_overwrite) {
                    this.m_cmsObject.createResource(vfsFileName, CmsResourceTypeXmlPage.getStaticTypeId(), contentByteArray, new ArrayList());
                } else {
                    try {
                        Object var14_15;
                        try {
                            oldProperties = this.m_cmsObject.readPropertyObjects(vfsFileName, false);
                            CmsLock lock = this.m_cmsObject.getLock(vfsFileName);
                            if (lock.getType() != CmsLockType.EXCLUSIVE) {
                                this.m_cmsObject.lockResource(vfsFileName);
                            }
                            this.m_cmsObject.deleteResource(vfsFileName, CmsResource.DELETE_PRESERVE_SIBLINGS);
                        }
                        catch (CmsException e) {
                            var14_15 = null;
                            this.m_report.print(Messages.get().container("RPT_OVERWRITE_0"), 3);
                            this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                            this.m_cmsObject.createResource(vfsFileName, CmsResourceTypeXmlPage.getStaticTypeId(), contentByteArray, new ArrayList());
                            break block14;
                        }
                        var14_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_16 = null;
                        this.m_report.print(Messages.get().container("RPT_OVERWRITE_0"), 3);
                        this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                        this.m_cmsObject.createResource(vfsFileName, CmsResourceTypeXmlPage.getStaticTypeId(), contentByteArray, new ArrayList());
                        throw throwable;
                    }
                    this.m_report.print(Messages.get().container("RPT_OVERWRITE_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    this.m_cmsObject.createResource(vfsFileName, CmsResourceTypeXmlPage.getStaticTypeId(), contentByteArray, new ArrayList());
                }
            }
            Iterator it = properties.entrySet().iterator();
            ArrayList<CmsProperty> propertyList = new ArrayList<CmsProperty>();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String propertyKey = (String)entry.getKey();
                String propertyVal = (String)entry.getValue();
                CmsProperty property = new CmsProperty(propertyKey, propertyVal, propertyVal);
                property.setAutoCreatePropertyDefinition(true);
                propertyList.add(property);
            }
            try {
                this.m_cmsObject.writePropertyObjects(vfsFileName, propertyList);
                this.m_cmsObject.writePropertyObjects(vfsFileName, oldProperties);
            }
            catch (CmsException e1) {
                e1.printStackTrace();
            }
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            return;
        }
        catch (CmsException e) {
            this.m_report.println((Throwable)e);
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void createFolder(String foldername, int position, Hashtable properties) {
        String vfsFolderName = (String)this.m_fileIndex.get(foldername.replace('\\', '/'));
        this.m_report.print(Messages.get().container("RPT_CREATE_FOLDER_0"), 3);
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)vfsFolderName));
        this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
        if (vfsFolderName != null) {
            String path = vfsFolderName.substring(0, vfsFolderName.substring(0, vfsFolderName.length() - 1).lastIndexOf("/"));
            String folder = vfsFolderName.substring(path.length(), vfsFolderName.length());
            try {
                Enumeration enu;
                String propertyFileName = foldername + File.separator + META_PROPERTIES;
                boolean metaPropertiesFound = false;
                ExtendedProperties propertyFile = new ExtendedProperties();
                try {
                    propertyFile.load((InputStream)new FileInputStream(new File(propertyFileName)));
                    metaPropertiesFound = true;
                }
                catch (Exception e1) {
                    // empty catch block
                }
                if (metaPropertiesFound) {
                    enu = propertyFile.keys();
                    String property = "";
                    while (enu.hasMoreElements()) {
                        try {
                            property = (String)enu.nextElement();
                            String propertyvalue = (String)propertyFile.get((Object)property);
                            properties.put(property, propertyvalue);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (properties.get("NavPos") == null) {
                        properties.put("NavPos", position + 1 + "");
                    }
                    if (properties.get("NavText") == null) {
                        String navtext = folder.substring(1, 2).toUpperCase() + folder.substring(2, folder.length() - 1);
                        properties.put("NavText", navtext);
                    }
                } else {
                    properties = new Hashtable<String, String>();
                }
                try {
                    this.m_cmsObject.readFolder(path + folder);
                    this.m_cmsObject.lockResource(path + folder);
                }
                catch (CmsException e1) {
                    this.m_cmsObject.createResource(path + folder, CmsResourceTypeFolder.getStaticTypeId());
                }
                enu = properties.keys();
                ArrayList<CmsProperty> propertyList = new ArrayList<CmsProperty>();
                while (enu.hasMoreElements()) {
                    String propertyKey = (String)enu.nextElement();
                    String propertyVal = (String)properties.get(propertyKey);
                    CmsProperty property = new CmsProperty(propertyKey, propertyVal, propertyVal);
                    property.setAutoCreatePropertyDefinition(true);
                    propertyList.add(property);
                }
                try {
                    this.m_cmsObject.writePropertyObjects(path + folder, propertyList);
                }
                catch (CmsException e1) {
                    e1.printStackTrace();
                }
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
            catch (CmsException e) {
                this.m_report.println((Throwable)e);
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private String getBasePath(String path1, String path2) {
        StringBuffer base = new StringBuffer();
        path1 = path1.replace('\\', '/');
        path2 = path2.replace('\\', '/');
        String[] parts1 = path1.split("/");
        String[] parts2 = path2.split("/");
        for (int i = 0; i < parts1.length && i < parts2.length; ++i) {
            if (!parts1[i].equals(parts2[i])) continue;
            base.append(parts1[i] + "/");
        }
        return base.toString();
    }

    private String getExternalLinkFile(String link) {
        String filename = link.substring(link.indexOf("://") + 3, link.length());
        filename = this.m_cmsObject.getRequestContext().getFileTranslator().translateResource(filename.replace('/', '-'));
        return filename;
    }

    private byte[] getFileBytes(File file) throws CmsException {
        byte[] buffer = null;
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(file);
            int size = new Long(file.length()).intValue();
            buffer = new byte[size];
            for (int charsRead = 0; charsRead < size; charsRead += fileStream.read(buffer, charsRead, size - charsRead)) {
            }
            byte[] byArray = buffer;
            return byArray;
        }
        catch (IOException e) {
            throw new CmsDbIoException(Messages.get().container("ERR_GET_FILE_BYTES_1", (Object)file.getAbsolutePath()), (Throwable)e);
        }
        finally {
            this.closeStream(fileStream);
        }
    }

    private int getFileType(String filename) throws Exception {
        String typename;
        String extension = "";
        if (filename.indexOf(".") > -1) {
            extension = filename.substring(filename.lastIndexOf("."));
        }
        if ((typename = (String)this.m_extensions.get(extension.toLowerCase())) == null) {
            typename = "binary";
        }
        CmsResourceManager resourceManager = OpenCms.getResourceManager();
        return resourceManager.getResourceType(typename).getTypeId();
    }

    private String getVfsName(String relativeName, String name, boolean isFile) throws Exception {
        String vfsName = relativeName.replace('\\', '/');
        if (isFile) {
            int filetype = this.getFileType(name);
            if (name.indexOf(".") == 0) {
                name = "unknown" + name;
                int dot = relativeName.lastIndexOf(".");
                relativeName = relativeName.substring(0, dot) + name;
            }
            boolean leaveImages = CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_imageGallery);
            boolean leaveDownload = CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_downloadGallery);
            if (CmsResourceTypeImage.getStaticTypeId() == filetype && !leaveImages) {
                vfsName = this.m_imageGallery + name;
            } else if (CmsResourceTypePlain.getStaticTypeId() == filetype || leaveImages || leaveDownload) {
                File folder;
                String folderName = relativeName;
                if (folderName.indexOf(".") > 0) {
                    folderName = folderName.substring(0, folderName.indexOf("."));
                }
                vfsName = (folder = new File(folderName = this.m_inputDir + "\\" + folderName)).isDirectory() ? this.m_destinationDir + relativeName.substring(0, relativeName.indexOf(".")) + "/index.html" : this.m_destinationDir + relativeName;
            } else {
                vfsName = this.m_downloadGallery + name;
            }
            return this.validateFilename(vfsName);
        }
        vfsName = this.m_destinationDir + vfsName + "/";
        return vfsName;
    }

    private boolean isExternal(String filename) {
        boolean external = false;
        if (filename.indexOf("://") > 0) {
            external = true;
        }
        return external;
    }

    private boolean isValidElement() {
        boolean validElement = false;
        ArrayList<String> elementList = new ArrayList<String>();
        try {
            String elements = this.m_cmsObject.readPropertyObject(this.m_template, "template-elements", false).getValue();
            if (elements != null) {
                StringTokenizer T = new StringTokenizer(elements, ",");
                while (T.hasMoreTokens()) {
                    String currentElement = T.nextToken();
                    int sepIndex = currentElement.indexOf("|");
                    if (sepIndex != -1) {
                        currentElement = currentElement.substring(0, sepIndex);
                    }
                    if (currentElement.endsWith("*")) {
                        currentElement = currentElement.substring(0, currentElement.length() - 1);
                    }
                    elementList.add(currentElement);
                }
            }
            if (elementList.contains(this.m_element)) {
                validElement = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validElement;
    }

    private String parseHtmlFile(File file, Hashtable properties) throws CmsException {
        String parsedHtml = "";
        try {
            byte[] content = this.getFileBytes(file);
            String contentString = new String(content, this.m_inputEncoding);
            contentString = CmsEncoder.escapeNonAscii((String)contentString);
            contentString = CmsStringUtil.substitute((String)contentString, (String)"&#", (String)"{subst}");
            parsedHtml = this.m_htmlConverter.convertHTML(file.getAbsolutePath(), contentString, this.m_startPattern, this.m_endPattern, properties);
            parsedHtml = CmsStringUtil.substitute((String)parsedHtml, (String)"{subst}", (String)"&#");
        }
        catch (Exception e) {
            CmsMessageContainer message = Messages.get().container("ERR_HTMLIMPORT_PARSE_1", (Object)file.getAbsolutePath());
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            throw new CmsImportExportException(message, (Throwable)e);
        }
        return parsedHtml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File unzipStream() {
        ZipInputStream importZip = null;
        File folder = null;
        try {
            importZip = new ZipInputStream(new FileInputStream(this.m_httpDir));
            folder = CmsHtmlImport.createTempFolder("import_html");
            ZipEntry entry = null;
            byte[] buffer = null;
            while (true) {
                try {
                    entry = importZip.getNextEntry();
                    if (entry == null) break;
                    String name = entry.getName();
                    this.m_report.print(Messages.get().container("RPT_HTML_UNZIP_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)name));
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    name = name.replace('/', File.separatorChar);
                    String path = folder + File.separator + name;
                    if (entry.isDirectory()) {
                        File importFile = new File(path);
                        importFile.mkdirs();
                    } else {
                        int size = new Long(entry.getSize()).intValue();
                        buffer = size == -1 ? CmsFileUtil.readFully((InputStream)importZip, (boolean)false) : CmsFileUtil.readFully((InputStream)importZip, (int)size, (boolean)false);
                        File importFile = new File(path);
                        File parent = importFile.getParentFile();
                        if (parent != null) {
                            parent.mkdirs();
                        }
                        importFile.createNewFile();
                        FileOutputStream fileOutput = new FileOutputStream(importFile.getAbsoluteFile());
                        fileOutput.write(buffer);
                        fileOutput.close();
                    }
                    importZip.closeEntry();
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                }
                catch (Exception ex) {
                    String name;
                    String string = name = entry != null ? entry.getName() : "";
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_ZIPFILE_UNZIP_1", (Object)name), (Throwable)ex);
                    }
                    this.m_report.println(Messages.get().container("ERR_ZIPFILE_UNZIP_1", (Object)name), 5);
                }
                entry = null;
            }
            this.closeStream(importZip);
        }
        catch (Exception ex) {
            try {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_ZIPFILE_READ_1", (Object)this.m_httpDir), (Throwable)ex);
                }
                this.m_report.println(Messages.get().container("ERR_ZIPFILE_READ_1", (Object)this.m_httpDir), 5);
                this.closeStream(importZip);
            }
            catch (Throwable throwable) {
                this.closeStream(importZip);
                throw throwable;
            }
        }
        return folder;
    }

    private String validateFilename(String filename) {
        if (this.isExternal(filename)) {
            return filename;
        }
        int postfix = 1;
        boolean found = true;
        String validFilename = filename;
        if (!this.m_overwrite) {
            while (found) {
                try {
                    validFilename = this.m_cmsObject.getRequestContext().getFileTranslator().translateResource(validFilename);
                    found = true;
                    if (!this.m_fileIndex.containsValue(validFilename.replace('\\', '/'))) {
                        found = false;
                    }
                    if (!found) {
                        found = true;
                        this.m_cmsObject.readResource(validFilename, CmsResourceFilter.ALL);
                    }
                    String path = filename.substring(0, filename.lastIndexOf("/") + 1);
                    String name = filename.substring(filename.lastIndexOf("/") + 1, filename.length());
                    validFilename = path;
                    validFilename = name.lastIndexOf(".") > 0 ? validFilename + name.substring(0, name.lastIndexOf(".")) : validFilename + name;
                    validFilename = validFilename + "_" + postfix;
                    if (name.lastIndexOf(".") > 0) {
                        validFilename = validFilename + name.substring(name.lastIndexOf("."), name.length());
                    }
                    ++postfix;
                }
                catch (CmsException e) {
                    found = false;
                }
            }
        } else {
            validFilename = validFilename.replace('\\', '/');
        }
        return OpenCms.getResourceManager().getFileTranslator().translateResource(validFilename);
    }
}

