/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.database;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.tools.database.CmsHtmlImport;
import org.opencms.workplace.tools.database.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class CmsHtmlImportConverter {
    private static final String ATTRIB_ALT = "alt";
    private static final String ATTRIB_CONTENT = "content";
    private static final String ATTRIB_HREF = "href";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_SRC = "src";
    private static final String NODE_BODY = "body";
    private static final String NODE_HEAD = "head";
    private static final String NODE_HREF = "a";
    private static final String NODE_HTML = "html";
    private static final String NODE_IMG = "img";
    private static final String NODE_META = "meta";
    private static final String NODE_TITLE = "title";
    private HashSet m_enterTags = new HashSet();
    private String m_filename;
    private CmsHtmlImport m_htmlImport;
    private StringBuffer m_tempString;
    private Tidy m_tidy = new Tidy();
    private boolean m_write;

    public CmsHtmlImportConverter(CmsHtmlImport htmlImport, boolean xmlMode) {
        this.m_tidy.setTidyMark(false);
        this.m_tidy.setShowWarnings(false);
        this.m_tidy.setQuiet(true);
        this.m_tidy.setForceOutput(true);
        if (xmlMode) {
            this.m_tidy.setXmlTags(xmlMode);
            this.m_tidy.setXmlSpace(true);
        }
        this.initialiseTags();
        this.m_htmlImport = htmlImport;
    }

    public static String extractHtml(String content, String startpoint, String endpoint) {
        Pattern startPattern = Pattern.compile(startpoint, 2);
        Pattern endPattern = Pattern.compile(endpoint, 2);
        Matcher startMatcher = startPattern.matcher(content);
        Matcher endMatcher = endPattern.matcher(content);
        int start = 0;
        int end = content.length();
        if (startMatcher.find()) {
            start = startMatcher.end();
        }
        if (endMatcher.find(start)) {
            end = endMatcher.start();
        }
        return content.substring(start, end);
    }

    public void convertHTML(Reader input, Writer output, String startPattern, String endPattern, Hashtable properties) {
        ByteArrayInputStream in;
        String extractMain;
        StringBuffer htmlString = new StringBuffer();
        String outString = "";
        try {
            int c;
            while ((c = input.read()) != -1) {
                htmlString.append((char)c);
            }
        }
        catch (IOException e) {
            if (CmsLog.INIT.isWarnEnabled()) {
                CmsLog.INIT.warn((Object)Messages.get().getBundle().key("LOG_HTMLIMPORT_CONVERSION_ERROR_0", (Object)e.getLocalizedMessage()));
            }
            return;
        }
        outString = htmlString.toString();
        if (CmsStringUtil.isNotEmpty((String)startPattern) && CmsStringUtil.isNotEmpty((String)endPattern) && (extractMain = CmsHtmlImportConverter.extractHtml(outString, startPattern, endPattern)).length() != outString.length()) {
            String extractHead = CmsHtmlImportConverter.extractHtml(outString, "<html>", "<\\s*body[^>]*>");
            StringBuffer buffer = new StringBuffer(extractHead.length() + extractMain.length() + 255);
            buffer.append("<html>");
            buffer.append(extractHead);
            buffer.append("<body>");
            buffer.append(extractMain);
            buffer.append("</body></html>");
            outString = buffer.toString();
        }
        try {
            in = new ByteArrayInputStream(outString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            in = new ByteArrayInputStream(outString.getBytes());
        }
        this.m_tidy.setInputEncoding("UTF-8");
        this.m_tidy.setOutputEncoding("UTF-8");
        PrintWriter errorLog = new PrintWriter(new ByteArrayOutputStream(), true);
        this.m_tidy.setErrout(errorLog);
        Document node = this.m_tidy.parseDOM((InputStream)in, null);
        if (this.m_tidy.getParseErrors() != 0 && CmsLog.INIT.isWarnEnabled()) {
            CmsLog.INIT.warn((Object)Messages.get().getBundle().key("LOG_HTMLIMPORT_CONVERSION_ERROR_0"));
        }
        this.printDocument(node, properties);
        try {
            String content = this.m_tempString.toString();
            content = CmsStringUtil.substitute((String)content, (String)"<br></br>", (String)"<br>");
            content = CmsStringUtil.substitutePerl((String)content, (String)"</a>(\\w+)", (String)"</a> $1", (String)"g");
            output.write(content);
            output.close();
        }
        catch (IOException e) {
            if (CmsLog.INIT.isWarnEnabled()) {
                CmsLog.INIT.warn((Object)Messages.get().getBundle().key("LOG_HTMLIMPORT_CONVERSION_ERROR_1", (Object)e.getLocalizedMessage()));
            }
            return;
        }
    }

    public String convertHTML(String filename, String inString, String startPattern, String endPattern, Hashtable properties) {
        this.m_tempString = new StringBuffer();
        this.m_write = true;
        this.m_filename = filename.replace('\\', '/');
        StringReader in = new StringReader(inString);
        StringWriter out = new StringWriter();
        this.convertHTML(in, out, startPattern, endPattern, properties);
        return ((Object)out).toString();
    }

    private void initialiseTags() {
        StringTokenizer T = new StringTokenizer("p,table,tr,td,body,head,script,pre,title,style,h1,h2,h3,h4,h5,h6,ul,ol,li", ",");
        while (T.hasMoreTokens()) {
            this.m_enterTags.add(T.nextToken());
        }
    }

    private void printDocument(Node node, Hashtable properties) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        String name = node.getNodeName();
        switch (type) {
            case 9: {
                this.printDocument(((Document)node).getDocumentElement(), properties);
                break;
            }
            case 1: {
                if (name.equals(NODE_HEAD)) {
                    this.m_write = false;
                }
                this.transformStartElement(node, properties);
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.printDocument(children.item(i), properties);
                }
                break;
            }
            case 3: {
                this.transformTextNode(node);
                break;
            }
        }
        switch (type) {
            case 1: {
                this.transformEndElement(node);
                if (!node.getNodeName().equals(NODE_HEAD)) break;
                this.m_write = true;
                break;
            }
            case 9: {
                break;
            }
        }
    }

    private void transformEndElement(Node node) {
        String nodeName = node.getNodeName();
        if (!nodeName.equals(NODE_HTML) && !nodeName.equals(NODE_BODY) && this.m_write) {
            this.m_tempString.append("</");
            this.m_tempString.append(nodeName);
            this.m_tempString.append(">");
            if (this.m_enterTags.contains(node.getNodeName())) {
                this.m_tempString.append("\n");
            }
        }
    }

    private void transformStartElement(Node node, Hashtable properties) {
        String nodeName = node.getNodeName();
        if (!nodeName.equals(NODE_HTML) && !nodeName.equals(NODE_BODY)) {
            if (nodeName.equals(NODE_TITLE)) {
                this.writeTitleProperty(node, properties);
            } else if (nodeName.equals(NODE_META)) {
                this.writeMetaTagProperty(node, properties);
            } else if (nodeName.equals(NODE_HREF)) {
                if (this.m_write) {
                    this.m_tempString.append("<");
                    this.m_tempString.append(nodeName);
                    NamedNodeMap attrs = node.getAttributes();
                    for (int i = attrs.getLength() - 1; i >= 0; --i) {
                        String name = attrs.item(i).getNodeName();
                        String value = attrs.item(i).getNodeValue();
                        if (name.equals(ATTRIB_HREF)) {
                            if (value.indexOf("://") > 0) {
                                String externalLinkFile = this.m_htmlImport.storeExternalLink(value);
                                if (externalLinkFile != null) {
                                    value = this.m_htmlImport.getLinkGallery() + externalLinkFile;
                                }
                            } else if (!value.startsWith("mailto:") && !value.startsWith("javascript:")) {
                                String internalUri = this.m_htmlImport.getAbsoluteUri(value, this.m_filename.substring(0, this.m_filename.lastIndexOf("/") + 1));
                                value = this.m_htmlImport.translateLink(internalUri);
                            }
                        }
                        this.m_tempString.append(" ");
                        this.m_tempString.append(name);
                        this.m_tempString.append("=\"");
                        this.m_tempString.append(value);
                        this.m_tempString.append("\"");
                    }
                    this.m_tempString.append(">");
                }
            } else if (nodeName.equals(NODE_IMG)) {
                if (this.m_write) {
                    this.m_tempString.append("<");
                    this.m_tempString.append(nodeName);
                    NamedNodeMap attrs = node.getAttributes();
                    String imagename = "";
                    String altText = "";
                    for (int i = attrs.getLength() - 1; i >= 0; --i) {
                        String name = attrs.item(i).getNodeName();
                        String value = attrs.item(i).getNodeValue();
                        if (name.equals(ATTRIB_SRC)) {
                            if (value.indexOf("://") <= 0) {
                                imagename = this.m_htmlImport.getAbsoluteUri(value, this.m_filename.substring(0, this.m_filename.lastIndexOf("/") + 1));
                                value = this.m_htmlImport.translateLink(imagename);
                            }
                        } else if (name.equals(ATTRIB_ALT)) {
                            altText = value;
                        }
                        this.m_tempString.append(" ");
                        this.m_tempString.append(name);
                        this.m_tempString.append("=\"");
                        this.m_tempString.append(value);
                        this.m_tempString.append("\"");
                    }
                    this.m_htmlImport.storeImageInfo(imagename, altText);
                    this.m_tempString.append(">");
                }
            } else if (this.m_write) {
                this.m_tempString.append("<");
                this.m_tempString.append(nodeName);
                NamedNodeMap attrs = node.getAttributes();
                for (int i = attrs.getLength() - 1; i >= 0; --i) {
                    this.m_tempString.append(" " + attrs.item(i).getNodeName() + "=" + "\"");
                    this.m_tempString.append(attrs.item(i).getNodeValue() + "\"");
                }
                this.m_tempString.append(">");
            }
        }
    }

    private void transformTextNode(Node node) {
        if (this.m_write) {
            String helpString = node.getNodeValue();
            this.m_tempString.append(helpString);
        }
    }

    private void writeMetaTagProperty(Node node, Hashtable properties) {
        NamedNodeMap attrs = node.getAttributes();
        String metaName = "";
        String metaContent = "";
        for (int i = attrs.getLength() - 1; i >= 0; --i) {
            String name = attrs.item(i).getNodeName();
            String value = attrs.item(i).getNodeValue();
            if (name.equals(ATTRIB_NAME)) {
                metaName = value;
                continue;
            }
            if (!name.equals(ATTRIB_CONTENT)) continue;
            metaContent = value;
        }
        if (metaName.length() > 0 && metaContent.length() > 0) {
            properties.put(metaName, CmsStringUtil.substitute((String)metaContent, (String)"{subst}", (String)"&#"));
        }
    }

    private void writeTitleProperty(Node node, Hashtable properties) {
        Node titleNode;
        String title = "";
        NodeList children = node.getChildNodes();
        if (children != null && (titleNode = children.item(0)) != null) {
            title = titleNode.getNodeValue();
        }
        if (title != null && title.length() > 0) {
            properties.put("Title", CmsStringUtil.substitute((String)title, (String)"{subst}", (String)"&#"));
            if (properties.get("NavText") == null) {
                properties.put("NavText", CmsStringUtil.substitute((String)title, (String)"{subst}", (String)"&#"));
            }
        }
    }
}

