/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.database;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.lock.CmsLockFilter;
import org.opencms.lock.CmsLockType;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.workplace.tools.database.Messages;

public class CmsRemovePubLocksThread
extends A_CmsReportThread {
    private Throwable m_error;
    private List m_resources;

    public CmsRemovePubLocksThread(CmsObject cms, List resources) {
        super(cms, Messages.get().getBundle().key("GUI_DB_PUBLOCKS_THREAD_NAME_0"));
        this.m_resources = new ArrayList(resources);
        this.initHtmlReport(cms.getRequestContext().getLocale());
    }

    public Throwable getError() {
        return this.m_error;
    }

    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    public void run() {
        try {
            this.getReport().println(Messages.get().container("RPT_DB_PUBLOCKS_BEGIN_0"), 2);
            CmsObject cms = this.getCms();
            CmsLockFilter filter = CmsLockFilter.FILTER_ALL;
            filter = filter.filterType(CmsLockType.PUBLISH);
            Iterator it = this.m_resources.iterator();
            while (it.hasNext()) {
                String paramResName = (String)it.next();
                this.getReport().println(Messages.get().container("RPT_DB_PUBLOCKS_READLOCKS_1", (Object)paramResName), 3);
                Iterator itResources = cms.getLockedResources(paramResName, filter).iterator();
                while (itResources.hasNext()) {
                    String resName = (String)itResources.next();
                    if (!cms.existsResource(resName, CmsResourceFilter.ALL)) {
                        this.getReport().println(Messages.get().container("RPT_DB_PUBLOCKS_UNLOCKING_1", (Object)resName), 0);
                        OpenCms.getMemoryMonitor().uncacheLock(cms.getRequestContext().addSiteRoot(resName));
                        continue;
                    }
                    Iterator itSiblings = cms.readSiblings(resName, CmsResourceFilter.ALL).iterator();
                    while (itSiblings.hasNext()) {
                        CmsResource res = (CmsResource)itSiblings.next();
                        this.getReport().println(Messages.get().container("RPT_DB_PUBLOCKS_UNLOCKING_1", (Object)cms.getSitePath(res)), 0);
                        OpenCms.getMemoryMonitor().uncacheLock(res.getRootPath());
                    }
                }
            }
            this.getReport().println(Messages.get().container("RPT_DB_PUBLOCKS_END_0"), 2);
        }
        catch (Throwable exc) {
            this.getReport().println(Messages.get().container("RPT_DB_PUBLOCKS_FAILED_0"), 1);
            this.getReport().println(exc);
            this.m_error = exc;
        }
    }
}

