/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.database;

import java.util.HashMap;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsEvent;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.workplace.tools.database.Messages;

public class CmsStaticExportThread
extends A_CmsReportThread {
    public CmsStaticExportThread(CmsObject cms) {
        super(cms, Messages.get().getBundle().key("GUI_STATEXP_THREAD_NAME_0"));
        this.initHtmlReport(cms.getRequestContext().getLocale());
    }

    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    public void run() {
        this.getReport().println(org.opencms.staticexport.Messages.get().container("RPT_STATICEXPORT_BEGIN_0"), 2);
        try {
            OpenCms.getStaticExportManager().exportFullStaticRender(true, this.getReport());
            HashMap<String, Boolean> eventData = new HashMap<String, Boolean>();
            eventData.put("purge", Boolean.TRUE);
            eventData.put("report", (Boolean)this.getReport());
            OpenCms.fireCmsEvent((CmsEvent)new CmsEvent(4, eventData));
        }
        catch (Exception e) {
            this.getReport().println((Throwable)e);
        }
        this.getReport().print(org.opencms.report.Messages.get().container("RPT_STAT_0"));
        this.getReport().println(org.opencms.report.Messages.get().container("RPT_STAT_DURATION_1", (Object)this.getReport().formatRuntime()));
        this.getReport().println(org.opencms.staticexport.Messages.get().container("RPT_STATICEXPORT_END_0"), 2);
    }
}

