/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templatetwo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.collectors.CmsDateResourceComparator;
import org.opencms.frontend.templatetwo.CmsListBoxEntry;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.CmsXmlDateTimeValue;
import org.opencms.xml.types.CmsXmlHtmlValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsListBoxContentMapping {
    public static final String ENTRY_AUTHOR = "Author";
    public static final String ENTRY_DATE = "Date";
    public static final String ENTRY_TEXT = "Text";
    public static final String ENTRY_LINK = "Link";
    public static final String ENTRY_TITLE = "Title";
    public static final String ENTRY_IMAGE = "Image";
    public static final String[] MAPPINGS = new String[]{"Title", "Author", "Text", "Date", "Link", "Image"};
    public static final List MAPPINGS_LIST = Collections.unmodifiableList(Arrays.asList(MAPPINGS));
    private Map m_mappings = new HashMap();

    public void addListBoxFieldMapping(List xmlFields, String listBoxField, int maxLength, String defaultValue) {
        if (MAPPINGS_LIST.contains(listBoxField)) {
            CmsListBoxFieldMapping mapping = new CmsListBoxFieldMapping(xmlFields, listBoxField, maxLength, defaultValue);
            this.m_mappings.put(listBoxField, mapping);
        }
    }

    public void addListBoxFieldMapping(List xmlFields, String listBoxField, String maxLength, String defaultValue) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)defaultValue)) {
            defaultValue = null;
        }
        int maxLengthInt = 0;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)maxLength)) {
            try {
                maxLengthInt = Integer.parseInt(maxLength);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.addListBoxFieldMapping(xmlFields, listBoxField, maxLengthInt, defaultValue);
    }

    public CmsListBoxEntry getEntryFromXmlContent(CmsObject cms, CmsXmlContent content, Locale locale) {
        if (content == null || locale == null || !content.hasLocale(locale)) {
            return null;
        }
        Set mappings = this.m_mappings.entrySet();
        CmsListBoxEntry result = new CmsListBoxEntry();
        boolean hasTitle = false;
        Iterator i = mappings.iterator();
        String link = null;
        Date date = null;
        while (i.hasNext()) {
            String xmlField;
            Map.Entry e = i.next();
            String listBoxField = (String)e.getKey();
            CmsListBoxFieldMapping mapping = (CmsListBoxFieldMapping)e.getValue();
            I_CmsXmlContentValue xmlContentValue = null;
            List xmlFields = mapping.getXmlFields();
            int size = xmlFields.size();
            for (int j = 0; !(j >= size || CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)(xmlField = (String)xmlFields.get(j))) && (xmlContentValue = content.getValue(xmlField, locale)) != null); ++j) {
            }
            String value = null;
            if (xmlContentValue != null) {
                value = xmlContentValue.getStringValue(cms);
            } else if (mapping.hasDefaultValue()) {
                value = mapping.getDefaultValue();
            }
            if (value == null) continue;
            if (mapping.hasMaxLenghtLimit()) {
                value = this.applyLengthRestriction(cms, xmlContentValue, value, mapping.getMaxLenght());
            }
            int pos = MAPPINGS_LIST.indexOf(listBoxField);
            switch (pos) {
                case 0: {
                    result.setTitle(value);
                    hasTitle = true;
                    break;
                }
                case 1: {
                    result.setAuthor(value);
                    break;
                }
                case 2: {
                    result.setDescription(value);
                    break;
                }
                case 3: {
                    date = this.convertToDate(cms, content.getFile(), xmlContentValue, value);
                    if (date == null) break;
                    result.setDate(date);
                    break;
                }
                case 4: {
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)value)) break;
                    link = OpenCms.getLinkManager().getServerLink(cms, value);
                    break;
                }
                case 5: {
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)value)) break;
                    result.setImage(value);
                    break;
                }
            }
        }
        if (hasTitle) {
            if (link == null) {
                link = OpenCms.getLinkManager().getServerLink(cms, cms.getSitePath((CmsResource)content.getFile()));
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(link)) {
                result.setLink(link);
            }
        } else {
            result = null;
        }
        return result;
    }

    public String getMappingForAuthor() {
        CmsListBoxFieldMapping mapping = (CmsListBoxFieldMapping)this.m_mappings.get(ENTRY_AUTHOR);
        return mapping != null ? (String)mapping.getXmlFields().get(0) : null;
    }

    public String getMappingForDate() {
        CmsListBoxFieldMapping mapping = (CmsListBoxFieldMapping)this.m_mappings.get(ENTRY_DATE);
        return mapping != null ? (String)mapping.getXmlFields().get(0) : null;
    }

    public String getMappingForDescription() {
        CmsListBoxFieldMapping mapping = (CmsListBoxFieldMapping)this.m_mappings.get(ENTRY_TEXT);
        return mapping != null ? (String)mapping.getXmlFields().get(0) : null;
    }

    public String getMappingForTitle() {
        CmsListBoxFieldMapping mapping = (CmsListBoxFieldMapping)this.m_mappings.get(ENTRY_TITLE);
        return mapping != null ? (String)mapping.getXmlFields().get(0) : null;
    }

    protected String applyLengthRestriction(CmsObject cms, I_CmsXmlContentValue xmlContentValue, String value, int maxLength) {
        if (value.length() <= maxLength) {
            return value;
        }
        String result = xmlContentValue instanceof CmsXmlHtmlValue ? xmlContentValue.getPlainText(cms) : value;
        if (result.length() > maxLength) {
            result = CmsStringUtil.trimToSize((String)result, (int)maxLength);
        }
        return result;
    }

    private Date convertToDate(CmsObject cms, CmsFile file, I_CmsXmlContentValue xmlContentValue, String stringValue) {
        Date result;
        block4: {
            result = null;
            if (xmlContentValue instanceof CmsXmlDateTimeValue) {
                result = new Date(((CmsXmlDateTimeValue)xmlContentValue).getDateTimeValue());
            } else {
                try {
                    result = new Date(Long.valueOf(stringValue));
                }
                catch (NumberFormatException e) {
                    List items;
                    long date;
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)stringValue) || (date = CmsDateResourceComparator.calculateDate((CmsObject)cms, (CmsResource)file, (List)(items = CmsStringUtil.splitAsList((String)stringValue, (char)'|', (boolean)true)), (long)-1L)) == -1L) break block4;
                    result = new Date(date);
                }
            }
        }
        return result;
    }

    class CmsListBoxFieldMapping {
        private String m_defaultValue;
        private String m_listBoxField;
        private int m_maxLenght;
        private List m_xmlFields;

        public CmsListBoxFieldMapping(List xmlFields, String listBoxField, int maxLength, String defaultValue) {
            this.m_xmlFields = xmlFields;
            this.m_listBoxField = listBoxField;
            this.m_defaultValue = defaultValue;
            this.m_maxLenght = maxLength;
        }

        public CmsListBoxFieldMapping(String xmlField, String listBoxField) {
            this(xmlField, listBoxField, null);
        }

        public CmsListBoxFieldMapping(String xmlField, String listBoxField, int maxLength, String defaultValue) {
            this(new ArrayList<String>(Collections.singletonList(xmlField)), listBoxField, maxLength, defaultValue);
        }

        public CmsListBoxFieldMapping(String xmlField, String listBoxField, String defaultValue) {
            this(xmlField, listBoxField, 0, defaultValue);
        }

        public void addXmlField(String xmlField) {
            if (!this.m_xmlFields.contains(xmlField)) {
                this.m_xmlFields.add(xmlField);
            }
        }

        public boolean equals(Object obj) {
            String listBoxField = null;
            if (obj instanceof CmsListBoxFieldMapping) {
                listBoxField = ((CmsListBoxFieldMapping)obj).m_listBoxField;
            }
            if (obj instanceof String) {
                listBoxField = (String)obj;
            }
            return this.m_listBoxField.equals(listBoxField);
        }

        public String getDefaultValue() {
            return this.m_defaultValue;
        }

        public String getListBoxField() {
            return this.m_listBoxField;
        }

        public int getMaxLenght() {
            return this.m_maxLenght;
        }

        public List getXmlFields() {
            return this.m_xmlFields;
        }

        public boolean hasDefaultValue() {
            return this.m_defaultValue != null;
        }

        public int hashCode() {
            return this.m_listBoxField.hashCode();
        }

        public boolean hasMaxLenghtLimit() {
            return this.m_maxLenght > 0;
        }
    }
}

