/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templatetwo;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.I_CmsEditorCssHandler;
import org.opencms.workplace.editors.Messages;

public class CmsTemplateCssHandler
implements I_CmsEditorCssHandler {
    private static final Log LOG = CmsLog.getLog((Object)CmsTemplateCssHandler.class);

    public String getUriStyleSheet(CmsObject cms, String editedResourcePath) {
        StringBuffer result = new StringBuffer(512);
        String cssPath = "/system/modules/org.opencms.frontend.templatetwo/resources/css/style.css";
        StringBuffer params = new StringBuffer(256);
        params.append("?style=");
        params.append(this.getStyleUri(cms, editedResourcePath));
        try {
            CmsResource res = cms.readResource(editedResourcePath);
            params.append("&type=");
            params.append(OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        result.append(cssPath);
        result.append(params);
        return result.toString();
    }

    public boolean matches(CmsObject cms, String editedResourcePath) {
        String templatePath;
        block3: {
            templatePath = "";
            try {
                templatePath = cms.readPropertyObject(editedResourcePath, "template", true).getValue("");
            }
            catch (CmsException e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_READ_TEMPLATE_PROP_FAILED_0"), (Throwable)e);
            }
        }
        if (CmsStringUtil.isNotEmpty((String)templatePath)) {
            return "/system/modules/org.opencms.frontend.templatetwo/templates/main.jsp".equals(templatePath);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStyleUri(CmsObject cms, String editedResourcePath) {
        String originalUri = cms.getRequestContext().getUri();
        String styleUri = null;
        try {
            cms.getRequestContext().setUri(editedResourcePath);
            styleUri = cms.readPropertyObject(editedResourcePath, "style.layout", true).getValue("");
        }
        catch (CmsException e) {
            if (LOG.isWarnEnabled()) {
                // empty if block
            }
        }
        finally {
            cms.getRequestContext().setUri(originalUri);
        }
        return styleUri;
    }
}

