/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templatetwo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsTemplateLayout
extends CmsJspActionElement {
    public static final String EXTENSION_CONFIG = ".config";
    public static final String MODULE_NAME = "org.opencms.frontend.templatetwo";
    public static final String NODE_CONFIG = "Config";
    public static final String NODE_PRESET = "Preset";
    public static final String NODE_PRESET_NESTED = "Config/Preset";
    public static final String PARAM_PRESET = "preset";
    public static final String PARAM_STYLE = "style";
    public static final String PROPERTY_CONFIG = "style.config";
    public static final String PROPERTY_OPTIONS = "style.options";
    public static final String PROPERTY_STYLE = "style.layout";
    public static final int RESOURCE_TYPE_ID_CONFIG = 71;
    public static final String VFS_PATH_CSS_DEAFULT_MAIN_NAV = "/system/modules/org.opencms.frontend.templatetwo/resources/menus/style2/style.css";
    public static final String VFS_PATH_CSS_LEFT_NAV = "/system/modules/org.opencms.frontend.templatetwo/resources/css/nav_left.css";
    public static final String VFS_PATH_TEMPLATE = "/system/modules/org.opencms.frontend.templatetwo/templates/main.jsp";
    private static final Log LOG = CmsLog.getLog((Object)CmsTemplateLayout.class);
    private CmsXmlContent m_config;
    private CmsJspContentAccessBean m_options;
    private CmsJspContentAccessBean m_preset;
    private String m_presetPath;
    private Map m_presetValue;
    private CmsJspContentAccessBean m_style;
    private String m_stylePath;
    private Map m_styleValue;

    public CmsTemplateLayout() {
    }

    public CmsTemplateLayout(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.init(context, req, res);
    }

    public static String getConfigFileName(String path) {
        String result = null;
        int index = path.lastIndexOf(".");
        result = index > -1 ? path.substring(0, index).concat(EXTENSION_CONFIG) : path.concat(EXTENSION_CONFIG);
        return result;
    }

    public String getConfigPath() {
        if (this.m_config != null) {
            return this.getCmsObject().getSitePath((CmsResource)this.m_config.getFile());
        }
        return null;
    }

    public CmsJspContentAccessBean getOptions() {
        return this.m_options;
    }

    public String getPresetPath() {
        return this.m_presetPath;
    }

    public Map getPresetValue() {
        if (this.m_presetValue == null) {
            this.m_presetValue = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    if (CmsTemplateLayout.this.getPreset() == null) {
                        return null;
                    }
                    Object obj = CmsTemplateLayout.this.getPreset().getValue().get(input);
                    if (obj == null) {
                        return null;
                    }
                    String value = obj.toString();
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)value)) {
                        return null;
                    }
                    return value;
                }
            });
        }
        return this.m_presetValue;
    }

    public String getStylePath() {
        return this.m_stylePath;
    }

    public List getStylesheets() {
        ArrayList<String> result = new ArrayList<String>();
        String navMain = null;
        String navPath = (String)this.getStyleValue().get("nav.main");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)navPath)) {
            navMain = this.property(PROPERTY_STYLE, navPath);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(navMain)) {
            result.add(navMain);
        } else {
            result.add(VFS_PATH_CSS_DEAFULT_MAIN_NAV);
        }
        result.add(VFS_PATH_CSS_LEFT_NAV);
        return result;
    }

    public Map getStyleValue() {
        if (this.m_styleValue == null) {
            this.m_styleValue = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object input) {
                    if (CmsTemplateLayout.this.getStyle() == null) {
                        return null;
                    }
                    Object obj = CmsTemplateLayout.this.getStyle().getValue().get(input);
                    if (obj == null) {
                        return null;
                    }
                    String value = obj.toString();
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)value)) {
                        return null;
                    }
                    return value;
                }
            });
        }
        return this.m_styleValue;
    }

    public void init(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        block12: {
            block11: {
                Locale locale;
                block10: {
                    super.init(context, req, res);
                    try {
                        this.m_presetPath = req.getParameter(PARAM_PRESET);
                        if (this.m_presetPath == null) {
                            this.initConfig();
                        }
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_presetPath)) {
                            CmsResource preset = this.getCmsObject().readResource(this.getCmsObject().getRequestContext().removeSiteRoot(this.m_presetPath), CmsResourceFilter.IGNORE_EXPIRATION);
                            locale = OpenCms.getLocaleManager().getDefaultLocale(this.getCmsObject(), this.getCmsObject().getSitePath(preset));
                            this.m_preset = new CmsJspContentAccessBean(this.getCmsObject(), locale, preset);
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block10;
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    this.m_stylePath = req.getParameter(PARAM_STYLE);
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_stylePath)) {
                        this.m_stylePath = this.property(PROPERTY_STYLE, "search");
                    }
                    CmsResource style = this.getCmsObject().readResource(this.getCmsObject().getRequestContext().removeSiteRoot(this.m_stylePath), CmsResourceFilter.IGNORE_EXPIRATION);
                    locale = OpenCms.getLocaleManager().getDefaultLocale(this.getCmsObject(), this.getCmsObject().getSitePath(style));
                    this.m_style = new CmsJspContentAccessBean(this.getCmsObject(), locale, style);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                String optionsPath = this.property(PROPERTY_OPTIONS, "search");
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)optionsPath)) {
                    CmsResource options = this.getCmsObject().readResource(this.getCmsObject().getRequestContext().removeSiteRoot(optionsPath), CmsResourceFilter.IGNORE_EXPIRATION);
                    Locale locale = OpenCms.getLocaleManager().getDefaultLocale(this.getCmsObject(), this.getCmsObject().getSitePath(options));
                    this.m_options = new CmsJspContentAccessBean(this.getCmsObject(), locale, options);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block12;
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setPresetPath(String presetPath) {
        this.m_presetPath = presetPath;
    }

    protected CmsJspContentAccessBean getPreset() {
        return this.m_preset;
    }

    protected CmsJspContentAccessBean getStyle() {
        return this.m_style;
    }

    private String getConfigPreset(CmsXmlContent config) {
        String result = null;
        if (config != null) {
            Locale locale = OpenCms.getLocaleManager().getDefaultLocale(this.getCmsObject(), this.getCmsObject().getSitePath((CmsResource)this.m_config.getFile()));
            result = config.getFile().getTypeId() == 71 ? config.getStringValue(this.getCmsObject(), NODE_PRESET, locale) : config.getStringValue(this.getCmsObject(), NODE_PRESET_NESTED, locale);
        }
        return result;
    }

    private void initConfig() {
        try {
            CmsXmlContent xmlContent;
            CmsFile resource = this.getCmsObject().readFile(this.getRequestContext().getUri());
            if (CmsResourceTypeXmlContent.isXmlContent((CmsResource)resource) && (xmlContent = CmsXmlContentFactory.unmarshal((CmsObject)this.getCmsObject(), (CmsFile)resource)).hasValue(NODE_CONFIG, this.getRequestContext().getLocale())) {
                this.m_config = xmlContent;
                this.m_presetPath = this.getConfigPreset(xmlContent);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_presetPath)) {
                    return;
                }
            }
        }
        catch (CmsException ex) {
            // empty catch block
        }
        try {
            String configFile = CmsTemplateLayout.getConfigFileName(this.getRequestContext().getUri());
            if (this.getCmsObject().existsResource(configFile)) {
                CmsFile file = this.getCmsObject().readFile(this.getRequestContext().removeSiteRoot(configFile));
                CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal((CmsObject)this.getCmsObject(), (CmsFile)file);
                if (this.m_config == null) {
                    this.m_config = xmlContent;
                }
                this.m_presetPath = this.getConfigPreset(xmlContent);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_presetPath)) {
                    return;
                }
            }
        }
        catch (CmsException ex) {
            // empty catch block
        }
        try {
            String propPath;
            String filePath = this.getRequestContext().getUri();
            while (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)(propPath = this.getCmsObject().readPropertyObject(filePath, PROPERTY_CONFIG, true).getValue()))) {
                String candidate = null;
                boolean isAbsolute = CmsLinkManager.isAbsoluteUri((String)propPath);
                if (!isAbsolute) {
                    String base = CmsResource.getFolderPath((String)filePath);
                    candidate = CmsLinkManager.getAbsoluteUri((String)filePath, (String)base);
                } else {
                    candidate = propPath;
                }
                if (candidate != null) {
                    if (this.getCmsObject().existsResource(candidate)) {
                        CmsFile file = this.getCmsObject().readFile(this.getRequestContext().removeSiteRoot(candidate));
                        CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal((CmsObject)this.getCmsObject(), (CmsFile)file);
                        if (this.m_config == null) {
                            this.m_config = xmlContent;
                        }
                        this.m_presetPath = this.getConfigPreset(xmlContent);
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.m_presetPath)) {
                            return;
                        }
                    } else if (isAbsolute) {
                        return;
                    }
                }
                if ((filePath = CmsResource.getParentFolder((String)filePath)) != null) continue;
                break;
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }
}

