/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templatetwo;

import java.util.Iterator;
import java.util.Locale;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.module.A_CmsModuleAction;
import org.opencms.module.CmsModule;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;

public class CmsTemplateModuleAction
extends A_CmsModuleAction {
    private static final String RELEASE_CONFIG = "/sites/default/release/_config_/";
    private static final String TEMPLATETWO_EDITOR_CSS_HANDER = "org.opencms.frontend.templatetwo.CmsTemplateCssHandler";
    static /* synthetic */ Class class$org$opencms$frontend$templatetwo$CmsTemplateModuleAction;

    public void initialize(CmsObject adminCms, CmsConfigurationManager configurationManager, CmsModule module) {
        super.initialize(adminCms, configurationManager, module);
        OpenCms.getWorkplaceManager().addEditorCssHandlerToHead(TEMPLATETWO_EDITOR_CSS_HANDER);
        final CmsObject cms = adminCms;
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        this.wait(5000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!cms.existsResource(CmsTemplateModuleAction.RELEASE_CONFIG)) {
                    return;
                }
                try {
                    if (cms.readResource("/sites/default/release/_config_/default").getTypeId() != CmsResourceTypePlain.getStaticTypeId()) {
                        return;
                    }
                }
                catch (CmsException e) {
                    e.printStackTrace();
                    return;
                }
                String projectName = "ReleaseModuleRepair";
                CmsProject project = null;
                try {
                    project = cms.readProject(projectName);
                }
                catch (CmsException ex) {
                    try {
                        project = cms.createProject(projectName, projectName, OpenCms.getDefaultUsers().getGroupAdministrators(), OpenCms.getDefaultUsers().getGroupAdministrators(), CmsProject.PROJECT_TYPE_TEMPORARY);
                    }
                    catch (CmsException e) {
                        e.printStackTrace();
                    }
                }
                if (project == null) {
                    return;
                }
                cms.getRequestContext().setCurrentProject(project);
                try {
                    cms.copyResourceToProject(CmsTemplateModuleAction.RELEASE_CONFIG);
                    Iterator it = cms.readResources(CmsTemplateModuleAction.RELEASE_CONFIG, CmsResourceFilter.DEFAULT, false).iterator();
                    while (it.hasNext()) {
                        CmsResource res = (CmsResource)it.next();
                        int type = 0;
                        if (res.getName().equals("default")) {
                            type = OpenCms.getResourceManager().getResourceType("ttconfig").getTypeId();
                        } else if (res.getName().equals("options")) {
                            type = OpenCms.getResourceManager().getResourceType("ttoptions").getTypeId();
                        } else if (res.getName().equals("style")) {
                            type = OpenCms.getResourceManager().getResourceType("ttstyle").getTypeId();
                        } else if (res.getName().equals("twocolums")) {
                            type = OpenCms.getResourceManager().getResourceType("ttpreset").getTypeId();
                        }
                        if (type == 0 || type == res.getTypeId()) continue;
                        String resName = cms.getSitePath(res);
                        cms.lockResource(resName);
                        cms.chtype(resName, type);
                    }
                    CmsLogReport report = new CmsLogReport(Locale.ENGLISH, class$org$opencms$frontend$templatetwo$CmsTemplateModuleAction == null ? (class$org$opencms$frontend$templatetwo$CmsTemplateModuleAction = CmsTemplateModuleAction.class$("org.opencms.frontend.templatetwo.CmsTemplateModuleAction")) : class$org$opencms$frontend$templatetwo$CmsTemplateModuleAction);
                    OpenCms.getPublishManager().publishProject(cms, (I_CmsReport)report);
                    OpenCms.getPublishManager().waitWhileRunning();
                }
                catch (CmsException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
    }
}

