/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.frontend.templateone.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.I_CmsEditorCssHandler;

public class CmsTemplateCssHandler
implements I_CmsEditorCssHandler {
    public static final String VFS_PATH_TEMPLATE = "/system/modules/org.opencms.frontend.templateone/templates/main";
    private static final Log LOG = CmsLog.getLog((Object)CmsTemplateCssHandler.class);

    public String getUriStyleSheet(CmsObject cms, String editedResourcePath) {
        StringBuffer result = new StringBuffer(512);
        String cssConfigPath = this.getStyleSheetConfigUri(cms, editedResourcePath);
        StringBuffer params = new StringBuffer(256);
        if (CmsStringUtil.isNotEmpty((String)cssConfigPath) && cms.existsResource(cssConfigPath)) {
            params.append("?respath=");
            params.append(editedResourcePath);
            params.append("&config=");
            params.append(cssConfigPath);
            params.append("&site=");
            params.append(cms.getRequestContext().getSiteRoot());
            params.append("&__locale=");
            String locale = cms.getRequestContext().getLocale().toString();
            try {
                locale = cms.readPropertyObject(editedResourcePath, "locale", true).getValue(locale);
            }
            catch (CmsException e) {
                // empty catch block
            }
            params.append(locale);
        }
        result.append("/system/modules/");
        result.append("org.opencms.frontend.templateone");
        result.append("/resources/");
        result.append("style.css");
        result.append(params);
        return result.toString();
    }

    public boolean matches(CmsObject cms, String editedResourcePath) {
        String templatePath;
        block3: {
            templatePath = "";
            try {
                templatePath = cms.readPropertyObject(editedResourcePath, "template", true).getValue("");
            }
            catch (CmsException e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)org.opencms.workplace.editors.Messages.get().getBundle().key("LOG_READ_TEMPLATE_PROP_FAILED_0"), (Throwable)e);
            }
        }
        if (CmsStringUtil.isNotEmpty((String)templatePath)) {
            return VFS_PATH_TEMPLATE.equals(templatePath);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStyleSheetConfigUri(CmsObject cms, String editedResourcePath) {
        String originalUri = cms.getRequestContext().getUri();
        String confUri = null;
        try {
            cms.getRequestContext().setUri(editedResourcePath);
            confUri = cms.readPropertyObject(editedResourcePath, "properties_style", true).getValue("");
            if (CmsStringUtil.isEmpty((String)confUri)) {
                confUri = cms.readPropertyObject(editedResourcePath, "style_main_configpath", true).getValue("/") + "configuration_css";
            }
        }
        catch (CmsException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_XMLCONTEN_CONFIG_NOT_FOUND_2", (Object)"configuration_css", (Object)editedResourcePath));
            }
        }
        finally {
            cms.getRequestContext().setUri(originalUri);
        }
        return confUri;
    }
}

