/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.httpclient.util.URIUtil;
import org.opencms.frontend.templateone.CmsTemplateBean;
import org.opencms.util.CmsStringUtil;

public abstract class CmsTemplateForm
extends CmsTemplateBean {
    public static final String MESSAGE_BUNDLE_FORM = "templateone_form";
    public static final String PARAM_ACTION = "action";
    private Map m_errors;
    private String m_formUri;
    private String m_pageUri;
    private String m_pageUrl;
    private String m_textsUri;

    public CmsTemplateForm() {
    }

    public CmsTemplateForm(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.init(context, req, res);
    }

    public static String getFormattedString(String inputString, char sepChar, int lineLength, String separator) {
        if (inputString.length() > lineLength) {
            int inputLength = inputString.length();
            StringBuffer result = new StringBuffer(inputLength + 4);
            while (inputLength > lineLength) {
                int count;
                for (count = lineLength; count < inputLength && inputString.charAt(count) != sepChar; ++count) {
                }
                if (count >= inputLength) break;
                result.append(inputString.substring(0, count + 1));
                result.append(separator);
                inputString = inputString.substring(count + 1);
                inputLength = inputString.length();
            }
            result.append(inputString);
            inputString = result.toString();
        }
        return inputString;
    }

    public static boolean isValidEmailAddress(String theAddress) {
        if (theAddress == null) {
            return false;
        }
        return theAddress.lastIndexOf(".") < theAddress.length() - 2 && theAddress.lastIndexOf(".") > theAddress.indexOf("@");
    }

    public String getConfigPath() {
        String uri = this.getRequestContext().getUri();
        this.getRequestContext().setUri(this.getPageUri(true));
        String path = this.property("style_main_configpath", "search", "");
        this.getRequestContext().setUri(uri);
        return path;
    }

    public String getError(String key) {
        if (this.m_errors != null) {
            String message = (String)this.m_errors.get(key);
            if (message == null) {
                return "";
            }
            return message;
        }
        return "";
    }

    public Map getErrors() {
        return this.m_errors;
    }

    public String getFormText(String element, boolean stripHtml) {
        String content = this.getContent(this.getTextsUri(), element, this.getRequestContext().getLocale());
        if (stripHtml) {
            content = this.removeHtmlTags(content);
        }
        return content;
    }

    public String getFormUri() {
        return this.link(this.m_formUri);
    }

    public String getPageTitle() {
        String title = this.property("Title", this.getPageUri(true), "");
        if ("".equals(title)) {
            title = this.getPageUri(true);
        }
        return title;
    }

    public String getPageUri() {
        return this.getPageUri(false);
    }

    public String getPageUri(boolean removeParams) {
        if (removeParams) {
            String uri = this.m_pageUri;
            if (CmsStringUtil.isNotEmpty((String)uri)) {
                uri = URIUtil.getPath((String)uri);
            }
            return uri;
        }
        return this.m_pageUri;
    }

    public String getPageUrl() {
        if (CmsStringUtil.isEmpty((String)this.m_pageUrl)) {
            StringBuffer result = new StringBuffer(64);
            HttpServletRequest request = this.getRequest();
            result.append(request.getScheme());
            result.append("://");
            result.append(request.getServerName());
            int port = request.getServerPort();
            String portString = "";
            if (port != 80 && port != 443) {
                portString = ":" + port;
            }
            result.append(portString);
            result.append(this.link(this.m_pageUri));
            this.m_pageUrl = result.toString();
        }
        return this.m_pageUrl;
    }

    public String getTextsUri() {
        if (this.m_textsUri == null) {
            this.m_textsUri = this.checkTextsUri();
        }
        return this.m_textsUri;
    }

    public boolean hasValidationErrors() {
        return this.isSubmitted() && this.getErrors() != null && this.getErrors().size() > 0;
    }

    public void init(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.m_pageUri = req.getParameter("uri");
        super.init(context, req, res);
        String siteRoot = req.getParameter("site");
        if (CmsStringUtil.isNotEmpty((String)siteRoot)) {
            this.getRequestContext().setSiteRoot(siteRoot);
        }
        this.m_formUri = this.getRequestContext().getUri();
        if (this.m_pageUri == null) {
            this.m_pageUri = this.m_formUri;
        }
        this.messages(MESSAGE_BUNDLE_FORM);
    }

    public String isChecked(String fieldValue) {
        if (Boolean.valueOf(fieldValue).booleanValue()) {
            return " checked=\"checked\"";
        }
        return "";
    }

    public boolean isSelected(String fieldValue, String requestValue) {
        return fieldValue.equals(requestValue);
    }

    public boolean isSubmitted() {
        return this.getRequest().getParameter(PARAM_ACTION) != null;
    }

    public void setErrors(Map errors) {
        this.m_errors = errors;
    }

    public abstract boolean validate();

    protected abstract String checkTextsUri();

    protected String removeHtmlTags(String content) {
        if (content != null && content.indexOf("<") != -1) {
            Matcher matcher = Pattern.compile("<(.|\\n)+?>").matcher(content);
            content = matcher.replaceAll("");
        }
        return content;
    }
}

