/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.frontend.templateone.CmsTemplateBean;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;

public class CmsTemplateImprint
extends CmsTemplateBean {
    public static final String FILENAME_CONFIGFILE = "imprint";
    public static final String PROPERTY_CONFIGFILE = "properties_imprint";
    public static final String PROPERTY_LINK_LEGAL = "link_legalnotes";
    public static final String PROPERTY_LINK_PRIVACY = "link_privacy";
    private CmsXmlContent m_configuration;

    public CmsTemplateImprint() {
    }

    public CmsTemplateImprint(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.init(context, req, res);
    }

    public String buildEmailEntry(String className, String localeKey) {
        StringBuffer result = new StringBuffer(16);
        String nodeValue = this.getEmail("");
        if (CmsStringUtil.isNotEmpty((String)nodeValue)) {
            result.append("<tr>\n\t<td class=\"");
            result.append(className);
            result.append("\" style=\"white-space: nowrap;\">");
            result.append(this.key(localeKey));
            result.append(":</td>\n\t<td class=\"");
            result.append(className);
            result.append("\">");
            result.append("<a href=\"mailto:");
            result.append(nodeValue);
            result.append("\">");
            result.append(nodeValue);
            result.append("</a></td>\n</tr>");
        }
        return result.toString();
    }

    public String buildImprintEntry(String className, String localeKey, String nodeName) {
        StringBuffer result = new StringBuffer(16);
        String nodeValue = "";
        try {
            nodeValue = this.m_configuration.getStringValue(this.getCmsObject(), nodeName, this.getRequestContext().getLocale());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (CmsStringUtil.isNotEmpty((String)nodeValue)) {
            result.append("<tr>\n\t<td class=\"");
            result.append(className);
            result.append("\" style=\"white-space: nowrap;\">");
            result.append(this.key(localeKey));
            result.append(":</td>\n\t<td class=\"");
            result.append(className);
            result.append("\">");
            result.append(nodeValue);
            result.append("</td>\n</tr>");
        }
        return result.toString();
    }

    public String getImprintValue(String nodeName) {
        String nodeValue = "";
        try {
            nodeValue = this.m_configuration.getStringValue(this.getCmsObject(), nodeName, this.getRequestContext().getLocale());
            if (CmsStringUtil.isEmpty((String)nodeValue)) {
                return "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nodeValue;
    }

    public String getLinkLegalNotes() {
        String link = this.property(PROPERTY_LINK_LEGAL, "search", "");
        if ("".equals(link)) {
            return "#";
        }
        return this.link(link);
    }

    public String getLinkPrivacy() {
        String link = this.property(PROPERTY_LINK_PRIVACY, "search", "");
        if ("".equals(link)) {
            return "#";
        }
        return this.link(link);
    }

    public String getUrl() {
        StringBuffer result = new StringBuffer(64);
        CmsSite site = OpenCms.getSiteManager().getCurrentSite(this.getCmsObject());
        result.append(site.getUrl());
        result.append(this.link(this.getRequestContext().getUri()));
        return result.toString();
    }

    public void init(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super.init(context, req, res);
        String siteRoot = req.getParameter("site");
        if (CmsStringUtil.isNotEmpty((String)siteRoot)) {
            this.getRequestContext().setSiteRoot(siteRoot);
        }
        String oldUri = this.getRequestContext().getUri();
        String uri = req.getParameter("uri");
        if (uri == null) {
            uri = oldUri;
        }
        this.getRequestContext().setUri(uri);
        String configFileName = this.property(PROPERTY_CONFIGFILE, "search", "");
        if ("".equals(configFileName)) {
            configFileName = this.getConfigPath() + FILENAME_CONFIGFILE;
        }
        this.m_configuration = CmsTemplateBean.getConfigurationFile(configFileName, this.getCmsObject());
    }

    protected String getEmail(String defaultValue) {
        String nodeValue = "";
        try {
            nodeValue = this.m_configuration.getStringValue(this.getCmsObject(), "email", this.getRequestContext().getLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CmsStringUtil.isEmpty((String)nodeValue)) {
            nodeValue = defaultValue;
        }
        return nodeValue;
    }
}

