/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.frontend.templateone.CmsTemplateBase;
import org.opencms.frontend.templateone.CmsTemplateBean;
import org.opencms.frontend.templateone.CmsTemplateParts;
import org.opencms.frontend.templateone.Messages;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsTemplateNavigation
extends CmsTemplateBase {
    public static final String FILE_CONFIG_HEADNAV = "headnav";
    public static final String PARAM_HEADNAV_FOLDER = "headnavfolder";
    public static final String PARAM_HEADNAV_IMAGES = "headnavimages";
    public static final String PARAM_HEADNAV_MARKCURRENT = "headnavmarkcurrent";
    public static final String PARAM_HEADNAV_MANUAL = "headnavmanual";
    public static final String PARAM_HEADNAV_MENUCLICK = "headnavmenuclick";
    public static final String PARAM_HEADNAV_MENUDEPTH = "headnavmenudepth";
    public static final String PARAM_LOCALE = "locale";
    public static final String PARAM_NAVLEFT_ELEMENTURI = "navleftelementuri";
    public static final String PARAM_NAVLEFT_SHOWSELECTED = "navleftselected";
    public static final String PARAM_NAVLEFT_SHOWTREE = "navleftshowtree";
    public static final String PARAM_RESPATH = "respath";
    public static final String PARAM_SHOWMENUS = "showmenus";
    public static final String PARAM_STARTFOLDER = "startfolder";
    public static final String PROPERTY_HEADNAV_USE = "style_head_nav_showitem";
    private static final Log LOG = CmsLog.getLog((Object)CmsTemplateBean.class);
    private CmsXmlContent m_globalConfiguration;
    private CmsXmlContent m_headNavConfiguration;
    private String m_headNavFolder;
    private boolean m_headNavItemDefaultValue;
    private boolean m_headNavManual;
    private boolean m_headNavMarkCurrent;
    private boolean m_headNavMenuClick;
    private String m_locale;
    private int m_menuDepth;
    private CmsMessages m_messages;
    private String m_navLeftElementUri;
    private boolean m_navLeftShowSelected;
    private boolean m_navLeftShowTree;
    private String m_resPath;
    private boolean m_showAccessibleVersion;
    private boolean m_showHeadNavImages;
    private boolean m_showMenus;
    private String m_startFolder;

    public CmsTemplateNavigation() {
    }

    public CmsTemplateNavigation(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this.init(context, req, res);
    }

    public String buildNavigationBreadCrumb(String styleClass) {
        boolean showNavigation;
        StringBuffer result = new StringBuffer(512);
        int startLevel = 1;
        startLevel = this.showNavLeftSelected() ? CmsResource.getPathLevel((String)this.getHeadNavFolder()) : CmsResource.getPathLevel((String)this.getStartFolder());
        CmsJspNavElement currentPage = this.getNavigation().getNavigationForResource(this.getRequestContext().getUri());
        int currentLevel = currentPage.getNavTreeLevel();
        int deltaLevel = currentLevel - startLevel;
        boolean bl = showNavigation = deltaLevel > 3 || deltaLevel == 3 && currentPage.isInNavigation();
        if (showNavigation) {
            String separator = "&gt;";
            result.append("<div class=\"");
            result.append(styleClass);
            result.append("\">");
            List navElements = this.getNavigation().getNavigationBreadCrumb(startLevel + 3, true);
            for (int i = 0; i < navElements.size(); ++i) {
                CmsJspNavElement nav = (CmsJspNavElement)navElements.get(i);
                result.append("<a href=\"");
                result.append(this.link(nav.getResourceName()));
                result.append("\" class=\"");
                result.append(styleClass);
                result.append("\" title=\"");
                result.append(nav.getNavText());
                result.append("\">");
                result.append(separator);
                result.append("&nbsp;");
                result.append(nav.getNavText());
                result.append("</a>\n");
            }
            if (currentPage.isInNavigation()) {
                result.append("<a href=\"");
                result.append(this.link(currentPage.getResourceName()));
                result.append("\" class=\"");
                result.append(styleClass);
                result.append("\" title=\"");
                result.append(currentPage.getNavText());
                result.append("\">");
                result.append(separator);
                result.append("&nbsp;");
                result.append(currentPage.getNavText());
                result.append("</a>\n");
            }
            result.append("</div>");
        }
        return result.toString();
    }

    public String buildNavigationHead(String homeLabel, String styleLink, String styleSeparator) {
        boolean firstItem = true;
        StringBuffer result = new StringBuffer(1024);
        result.append("<div class=\"");
        result.append(styleLink);
        result.append("\">\n");
        result.append("\t<!-- Start Topnavigation -->\n");
        boolean showHomeLink = Boolean.valueOf(this.getConfigurationValue("headnav.homelink/link.show", CmsStringUtil.TRUE));
        if (showHomeLink && !this.showHeadNavImages()) {
            boolean onlyIndex = Boolean.valueOf(this.getConfigurationValue("headnav.homelink/link.onlyindex", CmsStringUtil.FALSE));
            String url = this.getStartFolder();
            String target = "_self";
            if (onlyIndex && this.isDefaultFile(this.getStartFolder(), this.getRequestContext().getUri()) || !onlyIndex) {
                url = this.getConfigurationValue("headnav.homelink/link.url", this.getStartFolder());
                homeLabel = this.getConfigurationValue("headnav.homelink/link.text", homeLabel);
                target = this.getConfigurationValue("headnav.homelink/link.target", "_self");
            }
            if (url.startsWith("/")) {
                url = this.link(url);
            }
            homeLabel = homeLabel.toUpperCase();
            result.append("<a class=\"");
            result.append(styleLink);
            result.append("\" href=\"");
            result.append(url);
            result.append("\" title=\"");
            result.append(homeLabel);
            result.append("\" target=\"");
            result.append(target);
            result.append("\">");
            result.append(homeLabel);
            result.append("</a>\n");
            firstItem = false;
        } else if (this.showHeadNavImages()) {
            result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        }
        int count = -1;
        boolean manualHeadConfig = this.isHeadNavManual();
        List navElements = manualHeadConfig ? this.getHeadNavItemsFromConfig(0, "0") : this.getNavigation().getNavigationForFolder(this.getHeadNavFolder());
        for (int i = 0; i < navElements.size(); ++i) {
            CmsJspNavElement nav = (CmsJspNavElement)navElements.get(i);
            String link = nav.getResourceName();
            if (link.startsWith("/")) {
                link = this.link(link);
            }
            String showItemProperty = this.getHeadNavItemDefaultStringValue();
            if (this.getCmsObject().existsResource(nav.getResourceName())) {
                showItemProperty = this.property(PROPERTY_HEADNAV_USE, nav.getResourceName(), this.getHeadNavItemDefaultStringValue());
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_NAVIGATION_CONFIG_ERR_2", (Object)nav.getResourceName(), (Object)this.getRequestContext().getUri()));
            }
            boolean showItem = Boolean.valueOf(showItemProperty);
            if (!manualHeadConfig && (!nav.isFolderLink() || !showItem)) continue;
            ++count;
            String navText = CmsEncoder.escapeXml((String)nav.getNavText().toUpperCase());
            String target = nav.getInfo();
            if (CmsStringUtil.isEmpty((String)target)) {
                target = "_self";
            }
            if (this.showHeadNavImages()) {
                result.append("<td style= \"vertical-align: middle\">");
                result.append("<a");
                if (this.showMenus()) {
                    result.append(" onmouseover=\"buttonMouseover(event, 'menu");
                    result.append(count);
                    result.append("');\"");
                    if (this.getHeadNavMenuClick()) {
                        result.append(" onclick=\"return buttonClick(event, 'menu");
                        result.append(count);
                        result.append("');\"");
                    }
                }
                result.append(" title=\"");
                result.append(navText);
                result.append("\" href=\"");
                result.append(link);
                result.append("\" target=\"");
                result.append(target);
                result.append("\">");
                result.append("<img src=\"");
                result.append(this.link(nav.getNavImage()));
                result.append("\" border=\"0\" alt=\"");
                result.append(navText);
                result.append("\">");
                result.append("</a></td>\n");
            } else {
                if (!firstItem) {
                    result.append("<span class=\"");
                    result.append(styleSeparator);
                    result.append("\">|</span>\n");
                }
                result.append("<a");
                if (this.showMenus()) {
                    result.append(" onmouseover=\"buttonMouseover(event, 'menu");
                    result.append(count);
                    result.append("');\"");
                    if (this.getHeadNavMenuClick()) {
                        result.append(" onclick=\"return buttonClick(event, 'menu");
                        result.append(count);
                        result.append("');\"");
                    }
                }
                if (this.getHeadNavMarkCurrent() && this.getRequestContext().getUri().startsWith(nav.getResourceName())) {
                    result.append(" style=\"font-weight: bold;\"");
                }
                result.append(" class=\"");
                result.append(styleLink);
                result.append("\" title=\"");
                result.append(navText);
                result.append("\" href=\"");
                result.append(link);
                result.append("\" target=\"");
                result.append(target);
                result.append("\">");
                result.append(navText);
                result.append("</a>\n");
            }
            firstItem = false;
        }
        if (this.showHeadNavImages()) {
            result.append("</tr></table>");
        }
        result.append("\t<!-- End Topnavigation -->\n");
        result.append("</div>\n");
        return result.toString();
    }

    public String buildNavigationHeadMenus(String styleClass) {
        boolean cacheNavEnabled = !this.getRequestContext().currentProject().isOnlineProject();
        String cacheKey = null;
        if (cacheNavEnabled) {
            StringBuffer key = new StringBuffer(8);
            key.append(this.getRequestContext().getSiteRoot());
            key.append("_");
            key.append(this.getHeadNavFolder().hashCode());
            key.append("_");
            key.append(this.getStartFolder().hashCode());
            key.append("_");
            key.append(this.getMenuDepth());
            key.append("_");
            key.append(this.showMenus());
            key.append("_");
            key.append(this.showAccessibleVersion());
            key.append("_");
            key.append(this.getLocale());
            if (this.isHeadNavManual()) {
                key.append("_");
                key.append(this.getConfigPath().hashCode());
            }
            cacheKey = key.toString();
            String cachedNav = CmsTemplateParts.getInstance().getPart(cacheKey);
            if (CmsStringUtil.isNotEmpty((String)cachedNav)) {
                return cachedNav;
            }
        }
        StringBuffer result = new StringBuffer(4096);
        if (this.showMenus()) {
            boolean manualHeadConfig = this.isHeadNavManual();
            List navElements = manualHeadConfig ? this.getHeadNavItemsFromConfig(0, "0") : this.getNavigation().getNavigationForFolder(this.getHeadNavFolder());
            int count = -1;
            for (int i = 0; i < navElements.size(); ++i) {
                List subNav;
                CmsJspNavElement foldernav = (CmsJspNavElement)navElements.get(i);
                String showItemProperty = this.getHeadNavItemDefaultStringValue();
                if (this.getCmsObject().existsResource(foldernav.getResourceName())) {
                    showItemProperty = this.property(PROPERTY_HEADNAV_USE, foldernav.getResourceName(), this.getHeadNavItemDefaultStringValue());
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_NAVIGATION_CONFIG_ERR_2", (Object)foldernav.getResourceName(), (Object)this.getRequestContext().getUri()));
                }
                boolean showItem = Boolean.valueOf(showItemProperty);
                if (!manualHeadConfig && (!foldernav.isFolderLink() || !showItem)) continue;
                ++count;
                String subfolder = foldernav.getResourceName();
                String menuIndexes = null;
                if (manualHeadConfig) {
                    menuIndexes = String.valueOf(i);
                    subNav = this.getHeadNavItemsFromConfig(1, menuIndexes);
                } else {
                    subNav = this.getNavigation().getNavigationForFolder(subfolder);
                }
                result.append(this.getMenuNavigation(subNav, styleClass, "menu" + count, 1, menuIndexes));
            }
            if (cacheNavEnabled) {
                CmsTemplateParts.getInstance().addPart(cacheKey, result.toString());
            }
        }
        return result.toString();
    }

    public String buildNavigationLeft() {
        StringBuffer result = new StringBuffer(2048);
        if (this.showNavLeftTree()) {
            int i;
            result.append("<!-- Start navigation left -->\n");
            if (!this.showAccessibleVersion()) {
                result.append("\t<div style=\"line-height: 1px; font-size: 1px; display: block; height: 4px;\">&nbsp;</div>\n");
            }
            int startLevel = 1;
            startLevel = this.showNavLeftSelected() ? CmsResource.getPathLevel((String)this.getHeadNavFolder()) : CmsResource.getPathLevel((String)this.getStartFolder());
            int endLevel = startLevel + 2;
            String uri = this.getRequestContext().getUri();
            List navElements = this.getNavigation().getNavigationTreeForFolder(this.getRequestContext().getUri(), startLevel, endLevel);
            int oldLevel = -1;
            for (i = 0; i < navElements.size(); ++i) {
                CmsJspNavElement nav = (CmsJspNavElement)navElements.get(i);
                boolean showElement = true;
                String resName = nav.getResourceName();
                int level = nav.getNavTreeLevel() - (startLevel - 1);
                String styleClass = "navleft";
                if (uri.equals(resName) || nav.isFolderLink() && this.isDefaultFile(resName, uri)) {
                    styleClass = styleClass + "active";
                }
                if (this.showNavLeftSelected() && level <= 1 && !uri.startsWith(resName)) {
                    showElement = false;
                }
                if (!showElement) continue;
                if (oldLevel != -1) {
                    if (level == oldLevel) {
                        result.append("</li>\n");
                    } else if (level < oldLevel) {
                        int delta = oldLevel - level;
                        boolean itemClosed = false;
                        for (int k = 0; k < delta; ++k) {
                            if (!itemClosed) {
                                result.append("</li>");
                                itemClosed = true;
                            }
                            result.append("\n</ul></li>\n");
                        }
                    } else {
                        result.append("<ul class=\"navleft\">\n");
                    }
                } else {
                    result.append("<ul class=\"navleft\">\n");
                }
                result.append("<li class=\"");
                result.append(styleClass);
                result.append("\"><a class=\"");
                result.append(styleClass);
                result.append("\" href=\"");
                result.append(this.link(resName));
                result.append("\" title=\"");
                result.append(nav.getNavText());
                if (CmsStringUtil.isNotEmpty((String)nav.getInfo())) {
                    result.append("\" target=\"");
                    result.append(nav.getInfo());
                }
                result.append("\">");
                result.append(nav.getNavText());
                result.append("</a>");
                oldLevel = level;
            }
            for (i = 0; i < oldLevel; ++i) {
                result.append("</li></ul>\n");
            }
            result.append("<!-- End navigation left -->");
        }
        return result.toString();
    }

    public void buildNavLeftIncludeElement() throws IOException, JspException {
        JspWriter out = this.getJspContext().getOut();
        if (this.showNavLeftElement()) {
            out.print("\t<div style=\"line-height: 1px; font-size: 1px; display: block; height: 4px;\">&nbsp;</div>\n");
            this.include(this.getNavLeftElementUri(), "text1", true);
        } else if (!this.showNavLeftTree()) {
            out.print("&nbsp;");
        }
    }

    public String getConfigPath() {
        return this.property("style_main_configpath", "search", "/");
    }

    public CmsXmlContent getConfiguration() {
        if (this.m_globalConfiguration == null) {
            this.m_globalConfiguration = CmsTemplateBean.getConfigurationFile(this.getConfigPath() + "configuration_common", this.getCmsObject());
        }
        return this.m_globalConfiguration;
    }

    public String getConfigurationValue(String key, String defaultValue) {
        String value;
        block3: {
            value = null;
            try {
                value = this.getConfiguration().getStringValue(null, key, this.getRequestContext().getLocale());
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (CmsStringUtil.isEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    public String getHeadNavFolder() {
        return this.m_headNavFolder;
    }

    public List getHeadNavItemsFromConfig(int menuLevel, String menuIndexes) {
        List navEntries;
        if (this.m_headNavConfiguration == null) {
            this.m_headNavConfiguration = CmsTemplateBean.getConfigurationFile(this.getConfigPath() + FILE_CONFIG_HEADNAV, this.getCmsObject());
        }
        Locale locale = this.getRequestContext().getLocale();
        if (menuLevel == 0) {
            navEntries = this.m_headNavConfiguration.getValues("link", locale);
        } else {
            StringBuffer xPath = new StringBuffer(8);
            xPath.append("link");
            for (int i = 0; i < menuLevel; ++i) {
                int menuIndex = Integer.parseInt(String.valueOf(menuIndexes.charAt(i)));
                xPath.append("[");
                xPath.append(menuIndex + 1);
                xPath.append("]/menu");
            }
            navEntries = this.m_headNavConfiguration.getValues(xPath.toString(), locale);
        }
        int navEntriesSize = navEntries.size();
        ArrayList<CmsJspNavElement> result = new ArrayList<CmsJspNavElement>(navEntriesSize);
        for (int i = 0; i < navEntriesSize; ++i) {
            I_CmsXmlContentValue headLink = (I_CmsXmlContentValue)navEntries.get(i);
            String linkPath = headLink.getPath();
            String url = this.m_headNavConfiguration.getStringValue(this.getCmsObject(), linkPath + "/link.url", locale);
            String text = this.m_headNavConfiguration.getStringValue(this.getCmsObject(), linkPath + "/link.text", locale);
            String target = this.m_headNavConfiguration.getStringValue(this.getCmsObject(), linkPath + "/link.target", locale);
            if (CmsStringUtil.isEmpty((String)target)) {
                target = "_self";
            }
            HashMap<String, String> properties = new HashMap<String, String>(3);
            properties.put("NavText", text);
            properties.put("NavInfo", target);
            if (this.showHeadNavImages() && menuLevel == 0) {
                String image = this.m_headNavConfiguration.getStringValue(this.getCmsObject(), linkPath + "/link.image", locale);
                if (CmsStringUtil.isEmpty((String)image)) {
                    image = "";
                }
                properties.put("NavImage", image);
            }
            CmsJspNavElement nav = new CmsJspNavElement(url, properties, 1);
            result.add(nav);
        }
        return result;
    }

    public boolean getHeadNavMarkCurrent() {
        return this.m_headNavMarkCurrent;
    }

    public boolean getHeadNavMenuClick() {
        return this.m_headNavMenuClick;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public int getMenuDepth() {
        return this.m_menuDepth;
    }

    public StringBuffer getMenuNavigation(List curNav, String styleClass, String prefix, int currentDepth, String menuIndexes) {
        StringBuffer result = new StringBuffer(64);
        int navSize = curNav.size();
        if (navSize > 0) {
            HashMap subNav = new HashMap();
            HashMap<String, String> subIndex = new HashMap<String, String>();
            boolean entryPresent = false;
            boolean manualConfig = CmsStringUtil.isNotEmpty((String)menuIndexes);
            for (int i = 0; i < navSize; ++i) {
                String target;
                boolean showEntry;
                CmsJspNavElement ne = (CmsJspNavElement)curNav.get(i);
                String resName = ne.getResourceName();
                String link = resName;
                if (link.startsWith("/")) {
                    link = this.link(link);
                }
                String showItemProperty = this.getHeadNavItemDefaultStringValue();
                if (this.getCmsObject().existsResource(resName)) {
                    showItemProperty = this.property(PROPERTY_HEADNAV_USE, resName, this.getHeadNavItemDefaultStringValue());
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_NAVIGATION_CONFIG_ERR_2", (Object)resName, (Object)this.getRequestContext().getUri()));
                }
                boolean bl = showEntry = manualConfig || Boolean.valueOf(showItemProperty) != false;
                if (!showEntry) continue;
                entryPresent = true;
                List navEntries = new ArrayList();
                if (currentDepth < this.getMenuDepth()) {
                    if (manualConfig) {
                        navEntries = this.getHeadNavItemsFromConfig(currentDepth + 1, menuIndexes + String.valueOf(i));
                    } else if (ne.isFolderLink()) {
                        navEntries = this.getNavigation().getNavigationForFolder(resName);
                    }
                }
                if (CmsStringUtil.isEmpty((String)(target = ne.getInfo()))) {
                    target = "_self";
                }
                result.append(" <a class=\"mI\" href=\"");
                result.append(link);
                result.append("\" target=\"");
                result.append(target);
                result.append("\"");
                if (ne.isFolderLink() && this.hasSubMenuEntries(navEntries) || manualConfig && navEntries.size() > 0) {
                    result.append(" onmouseover=\"menuItemMouseover(event, '");
                    result.append(prefix);
                    result.append("_");
                    result.append(resName.hashCode());
                    result.append("');\">");
                    result.append("<span class=\"mIText\">");
                    result.append(ne.getNavText());
                    result.append("</span><span class=\"mIArrow\">&#9654;</span></a>");
                    subNav.put(resName, navEntries);
                    if (!manualConfig) continue;
                    subIndex.put(resName, menuIndexes + String.valueOf(i));
                    continue;
                }
                result.append(">");
                result.append(ne.getNavText());
                result.append("</a>");
            }
            result.append("</div>\n");
            StringBuffer openTag = new StringBuffer(8);
            if ("menu0".equals(prefix) && this.showAccessibleVersion()) {
                CmsMessages messages = new CmsMessages("templateone", this.getRequestContext().getLocale());
                openTag.append("<div style=\"visibility: hidden; display:none;\">");
                openTag.append("<h3>").append(messages.key("headline.accessible.nav.headline")).append("</h3>");
                openTag.append("<p>").append(messages.key("headline.accessible.nav.text")).append("</p>");
                openTag.append("</div>");
            }
            if (entryPresent) {
                openTag.append("<div class=\"");
                openTag.append(styleClass);
                openTag.append("\" id=\"");
                openTag.append(prefix);
                openTag.append("\" onmouseover=\"menuMouseover(event);\">");
            } else {
                openTag.append("<div style=\"visibility: hidden;\" id=\"");
                openTag.append(prefix);
                openTag.append("\">");
            }
            result.insert(0, (Object)openTag);
            Iterator i = subNav.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String resName = (String)entry.getKey();
                List navEntries = (List)entry.getValue();
                String newIndex = menuIndexes;
                if (manualConfig) {
                    newIndex = (String)subIndex.get(resName);
                }
                result.append(this.getMenuNavigation(navEntries, styleClass, prefix + "_" + resName.hashCode(), currentDepth + 1, newIndex));
            }
        }
        return result;
    }

    public String getNavLeftElementUri() {
        return this.m_navLeftElementUri;
    }

    public String getResourcePath() {
        return this.m_resPath;
    }

    public String getStartFolder() {
        return this.m_startFolder;
    }

    public void init(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super.init(context, req, res);
        this.m_locale = req.getParameter(PARAM_LOCALE);
        if (this.m_locale == null) {
            this.m_locale = this.property(PARAM_LOCALE, "search", "en").toLowerCase();
        }
        this.m_showAccessibleVersion = Boolean.valueOf(req.getParameter("accessible"));
        this.m_headNavFolder = req.getParameter(PARAM_HEADNAV_FOLDER);
        this.m_showHeadNavImages = Boolean.valueOf(req.getParameter(PARAM_HEADNAV_IMAGES));
        this.m_headNavItemDefaultValue = true;
        this.m_headNavManual = Boolean.valueOf(req.getParameter(PARAM_HEADNAV_MANUAL));
        this.m_headNavMarkCurrent = Boolean.valueOf(req.getParameter(PARAM_HEADNAV_MARKCURRENT));
        this.m_headNavMenuClick = Boolean.valueOf(req.getParameter(PARAM_HEADNAV_MENUCLICK));
        try {
            this.m_menuDepth = Integer.parseInt(req.getParameter(PARAM_HEADNAV_MENUDEPTH));
        }
        catch (Exception e) {
            this.m_menuDepth = 2;
        }
        this.m_navLeftElementUri = req.getParameter(PARAM_NAVLEFT_ELEMENTURI);
        this.m_navLeftShowSelected = Boolean.valueOf(req.getParameter(PARAM_NAVLEFT_SHOWSELECTED));
        this.m_navLeftShowTree = Boolean.valueOf(req.getParameter(PARAM_NAVLEFT_SHOWTREE));
        this.m_resPath = req.getParameter(PARAM_RESPATH);
        this.m_startFolder = req.getParameter(PARAM_STARTFOLDER);
        this.m_showMenus = Boolean.valueOf(req.getParameter(PARAM_SHOWMENUS));
    }

    public String key(String keyName) {
        return this.messages().key(keyName);
    }

    public CmsMessages messages() {
        if (this.m_messages == null) {
            this.m_messages = this.getMessages("templateone", this.getLocale());
        }
        return this.m_messages;
    }

    public void setHeadNavItemDefaultValue(boolean defaultValue) {
        this.m_headNavItemDefaultValue = defaultValue;
    }

    public boolean showAccessibleVersion() {
        return this.m_showAccessibleVersion;
    }

    public boolean showHeadNavImages() {
        return this.m_showHeadNavImages;
    }

    public boolean showMenus() {
        return this.m_showMenus;
    }

    public boolean showNavLeftElement() {
        return this.getNavLeftElementUri() != null && !"none".equals(this.getNavLeftElementUri());
    }

    public boolean showNavLeftSelected() {
        return this.m_navLeftShowSelected;
    }

    public boolean showNavLeftTree() {
        return this.m_navLeftShowTree;
    }

    private String getHeadNavItemDefaultStringValue() {
        return "" + this.m_headNavItemDefaultValue;
    }

    private boolean hasSubMenuEntries(List navEntries) {
        for (int i = navEntries.size() - 1; i >= 0; --i) {
            CmsJspNavElement nav = (CmsJspNavElement)navEntries.get(i);
            String showItemProperty = this.getHeadNavItemDefaultStringValue();
            if (this.getCmsObject().existsResource(nav.getResourceName())) {
                showItemProperty = this.property(PROPERTY_HEADNAV_USE, nav.getResourceName(), this.getHeadNavItemDefaultStringValue());
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_NAVIGATION_CONFIG_ERR_2", (Object)nav.getResourceName(), (Object)this.getRequestContext().getUri()));
            }
            if (!Boolean.valueOf(showItemProperty).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean isDefaultFile(String navPath, String fileUri) {
        String folderName = CmsResource.getFolderPath((String)fileUri);
        if (navPath.equals(folderName)) {
            String fileName = CmsResource.getName((String)fileUri);
            try {
                String defaultFileName = this.getCmsObject().readPropertyObject(folderName, "default-file", false).getValue();
                if (defaultFileName != null && fileName.equals(defaultFileName)) {
                    return true;
                }
            }
            catch (CmsException e) {
                // empty catch block
            }
            List defaultFileNames = OpenCms.getDefaultFiles();
            for (int i = 0; i < defaultFileNames.size(); ++i) {
                String currFileName = (String)defaultFileNames.get(i);
                if (!fileName.equals(currFileName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isHeadNavManual() {
        return this.m_headNavManual;
    }
}

