/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.layoutpage;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.frontend.layoutpage.CmsMacroWrapperFreeMarker;
import org.opencms.frontend.layoutpage.I_CmsMacroWrapper;
import org.opencms.frontend.layoutpage.Messages;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsLayoutPageBean {
    public static final String COLUMNS_LAYOUT_1 = "1col";
    public static final String COLUMNS_LAYOUT_2 = "2col";
    public static final String IMG_LINK_LARGER = "linklarger";
    public static final String IMG_LINK_NONE = "nolink";
    public static final String IMG_WIDTH_LARGE = "large";
    public static final String IMG_WIDTH_MEDIUM = "medium";
    public static final String IMG_WIDTH_SMALL = "small";
    public static final String MACRO_DESCRIPTION = "description";
    public static final String MACRO_HEADLINE = "headline";
    public static final String MACRO_IMAGE = "image";
    public static final String MACRO_IMAGE_WIDTH = "imagewidth";
    public static final String MACRO_TARGET = "target";
    public static final String MACRO_TEXT = "text";
    public static final String MACRO_TITLE = "title";
    public static final String MODULE_NAME = "org.opencms.frontend.layoutpage";
    public static final String PARAGRAPH_TYPE_BOTTOM = "imagebottom";
    public static final String PARAGRAPH_TYPE_BOTTOM_DESCRIPTION = "imagebottom_desc";
    public static final String PARAGRAPH_TYPE_IMAGE_LEFT = "imageleft";
    public static final String PARAGRAPH_TYPE_IMAGE_LEFT_DESCRIPTION = "imageleft_desc";
    public static final String PARAGRAPH_TYPE_IMAGE_LEFT_TEXT_RIGHT = "imageleft_textright";
    public static final String PARAGRAPH_TYPE_IMAGE_LEFT_TEXT_RIGHT_DESCRIPTION = "imageleft_textright_desc";
    public static final String PARAGRAPH_TYPE_IMAGE_RIGHT = "imageright";
    public static final String PARAGRAPH_TYPE_IMAGE_RIGHT_DESCRIPTION = "imageright_desc";
    public static final String PARAGRAPH_TYPE_IMAGE_RIGHT_TEXT_LEFT = "imageright_textleft";
    public static final String PARAGRAPH_TYPE_IMAGE_RIGHT_TEXT_LEFT_DESCRIPTION = "imageright_textleft_desc";
    public static final String PARAGRAPH_TYPE_TEXT_ONLY = "textonly";
    public static final String PARAGRAPH_TYPE_TOP = "imagetop";
    public static final String PARAGRAPH_TYPE_TOP_DESCRIPTION = "imagetop_desc";
    public static final String VFS_PATH_LAYOUTELEMENTS = "/system/modules/org.opencms.frontend.layoutpage/layouts/";
    protected static final String NODE_ALIGN = "Align";
    protected static final String NODE_COLUMNS_LAYOUT = "ColumnsLayout";
    protected static final String NODE_DESCRIPTION = "Description";
    protected static final String NODE_HEADLINE = "Headline";
    protected static final String NODE_IMAGE = "Image";
    protected static final String NODE_IMAGEOPTIONS = "ImageOptions";
    protected static final String NODE_PARAGRAPH = "Paragraph";
    protected static final String NODE_TEXT = "Text";
    protected static final String NODE_FILELINK = "Filelink";
    protected static final String KEY_HEADLINE = "headline";
    protected static final String KEY_TEXTVALUE = "textValue";
    protected static final String KEY_IMGURI = "imgUri";
    private static final Log LOG = CmsLog.getLog((Object)CmsLayoutPageBean.class);
    private int m_bodyWdith;
    private int m_colPadding;
    private int m_colSpacing;
    private String m_columnLayout;
    private int m_columnWidth;
    private CmsXmlContent m_content;
    private boolean m_fixedImageSize;
    private int m_imgWidthLarge;
    private int m_imgWidthMedium;
    private int m_imgWidthSmall;
    private CmsJspActionElement m_jspActionElement;
    private Map m_layoutPatterns;
    private String m_pathLayoutElements;
    private Map m_typeMappings;
    private String m_variant;

    public CmsLayoutPageBean() {
    }

    public CmsLayoutPageBean(CmsJspActionElement jsp, CmsXmlContent content, String variant, int bodyWith, int colPadding, int colSpacing) {
        this.init(jsp, content, variant, bodyWith, colPadding, colSpacing);
    }

    public static String buildLargeImageTag(CmsJspActionElement cms, String imgUri, String imgSize) {
        CmsImageScaler origImage = new CmsImageScaler(imgSize);
        CmsImageScaler scaler = new CmsImageScaler();
        scaler.setWidth(600);
        CmsImageScaler resultScaler = origImage.getWidthScaler(scaler);
        return cms.img(imgUri, resultScaler, null);
    }

    public void addLayoutPattern(String patternName, String imgWidthVariant) {
        this.m_layoutPatterns.put(patternName, imgWidthVariant);
    }

    public String buildHtmlParagraphs() {
        StringBuffer result = new StringBuffer(16384);
        Locale locale = this.getCmsObject().getRequestContext().getLocale();
        this.m_typeMappings = new HashMap();
        this.calculateColumnWidth();
        I_CmsMacroWrapper macros = null;
        try {
            macros = this.getMacroWrapper();
        }
        catch (Exception e) {
            if (!(e instanceof CmsException) && LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage());
            }
            return "";
        }
        boolean showTwoCols = this.getColumnLayout().indexOf(COLUMNS_LAYOUT_2) != -1;
        boolean showImgLinks = IMG_LINK_LARGER.equals(this.m_content.getStringValue(this.getCmsObject(), NODE_IMAGEOPTIONS, locale));
        String imgLinkTitleLocalized = "";
        CmsMessages messages = this.getCmsJspActionElement().getMessages("org/opencms/frontend/layoutpage/frontendmessages", locale);
        if (showImgLinks) {
            imgLinkTitleLocalized = messages.keyDefault("link.image.original", "");
        }
        Iterator i = this.m_content.getValues(NODE_PARAGRAPH, locale).iterator();
        result.append(macros.getResult("content_start"));
        boolean firstInRow = true;
        while (i.hasNext()) {
            String textValue;
            I_CmsXmlContentValue value = (I_CmsXmlContentValue)i.next();
            String xPath = value.getPath() + "/";
            boolean hasFileLink = this.m_content.hasValue(xPath + NODE_FILELINK, locale);
            ExtendedProperties xmlElementsProperties = null;
            CmsFile linkToFile = null;
            CmsXmlContent xmlContentFileLink = null;
            if (hasFileLink) {
                try {
                    linkToFile = this.getCmsObject().readFile(this.m_content.getStringValue(this.getCmsObject(), xPath + NODE_FILELINK, locale));
                    xmlContentFileLink = CmsXmlContentFactory.unmarshal((CmsObject)this.getCmsObject(), (CmsFile)linkToFile);
                    xmlElementsProperties = this.getXmlElementsProperties(linkToFile);
                }
                catch (Exception e) {
                    hasFileLink = false;
                }
            }
            String headline = "";
            if (this.m_content.hasValue(xPath + NODE_HEADLINE, locale)) {
                headline = this.m_content.getStringValue(this.getCmsObject(), xPath + NODE_HEADLINE, locale);
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)headline)) {
                String titleValue;
                headline = hasFileLink ? (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)(titleValue = this.getPropertiesValue(xmlElementsProperties, "headline", xmlContentFileLink, locale))) ? "<a title=\"" + titleValue + "\" href=\"" + this.m_jspActionElement.link(this.m_content.getStringValue(this.getCmsObject(), xPath + NODE_FILELINK, locale)) + "\" target=\"_self\">" + titleValue + "</a>" : "") : "";
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)(textValue = this.m_content.getStringValue(this.getCmsObject(), xPath + NODE_TEXT, locale)))) {
                if (hasFileLink) {
                    String text = this.getPropertiesValue(xmlElementsProperties, KEY_TEXTVALUE, xmlContentFileLink, locale);
                    if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)text)) {
                        textValue = text;
                        textValue = CmsStringUtil.trimToSize((String)textValue, (int)250);
                        textValue = textValue + "<a href=\"" + this.m_jspActionElement.link(this.m_content.getStringValue(this.getCmsObject(), xPath + NODE_FILELINK, locale)) + "\" target=\"_self\">&gt; " + messages.keyDefault("link.more", "") + "</a>";
                    } else {
                        textValue = "";
                    }
                } else {
                    textValue = "";
                }
            }
            xPath = xPath + "Image/";
            String imgDesc = "";
            String paragraphType = "";
            String imgTag = "";
            String imgUrl = "";
            int imgWidth = this.getColumnWidth();
            boolean imagePresent = false;
            if (this.m_content.hasValue(xPath, locale)) {
                String imgUri = this.m_content.getStringValue(this.getCmsObject(), xPath + NODE_IMAGE, locale);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)imgUri)) {
                    String imgValue;
                    imgUri = hasFileLink ? (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)(imgValue = this.getPropertiesValue(xmlElementsProperties, KEY_IMGURI, xmlContentFileLink, locale))) ? imgValue : "") : "";
                }
                String imgSize = null;
                try {
                    imgSize = this.getCmsObject().readPropertyObject(imgUri, "image.size", false).getValue();
                }
                catch (CmsException e) {
                    // empty catch block
                }
                if (imgSize != null) {
                    imagePresent = true;
                    if (this.m_content.hasValue(xPath + NODE_DESCRIPTION, locale)) {
                        imgDesc = this.m_content.getStringValue(this.getCmsObject(), xPath + NODE_DESCRIPTION, locale);
                    }
                    paragraphType = this.m_content.getStringValue(this.getCmsObject(), xPath + NODE_ALIGN, locale);
                    CmsImageScaler scaler = this.getImageScaler(paragraphType, imgSize);
                    imgWidth = scaler.getWidth();
                    String imgTitle = imgDesc;
                    if (showImgLinks) {
                        StringBuffer tempImgTitle = new StringBuffer(128);
                        tempImgTitle.append(imgDesc);
                        if (CmsStringUtil.isNotEmpty((String)imgDesc)) {
                            tempImgTitle.append(" ");
                        }
                        tempImgTitle.append(imgLinkTitleLocalized);
                        imgTitle = tempImgTitle.toString();
                    }
                    HashMap<String, String> attrs = new HashMap<String, String>(4);
                    attrs.put("alt", imgTitle);
                    attrs.put(MACRO_TITLE, imgTitle);
                    attrs.put("border", "0");
                    imgTag = this.getCmsJspActionElement().img(imgUri, scaler, attrs);
                    macros.putContextVariable(MACRO_IMAGE, imgTag);
                    if (showImgLinks) {
                        imgUrl = this.getLinkToLargeImage(imgUri, imgSize);
                        macros.putContextVariable(MACRO_TITLE, imgTitle);
                        macros.putContextVariable(MACRO_TARGET, imgUrl);
                        imgTag = macros.getResult("image_with_link");
                    } else {
                        imgTag = macros.getResult("image_without_link");
                    }
                }
            }
            macros.putContextVariable(MACRO_DESCRIPTION, imgDesc);
            if (imagePresent && showImgLinks) {
                macros.putContextVariable(MACRO_TITLE, imgLinkTitleLocalized);
                macros.putContextVariable(MACRO_TARGET, imgUrl);
                imgDesc = macros.getResult("description_with_link");
            } else {
                imgDesc = macros.getResult("description_without_link");
            }
            if (CmsStringUtil.isEmpty((String)paragraphType)) {
                paragraphType = PARAGRAPH_TYPE_TEXT_ONLY;
            }
            if (firstInRow || !showTwoCols) {
                result.append(macros.getResult("row_start"));
            }
            result.append(macros.getResult("element_start"));
            macros.putContextVariable("headline", headline);
            macros.putContextVariable(MACRO_TEXT, textValue);
            macros.putContextVariable(MACRO_IMAGE, imgTag);
            macros.putContextVariable(MACRO_IMAGE_WIDTH, new Integer(imgWidth));
            macros.putContextVariable(MACRO_DESCRIPTION, imgDesc);
            result.append(macros.getResult(paragraphType));
            result.append(macros.getResult("element_end"));
            if (!showTwoCols || !firstInRow || firstInRow && !i.hasNext()) {
                if (showTwoCols && firstInRow && !i.hasNext()) {
                    result.append(macros.getResult("element_start"));
                    result.append(macros.getResult("element_end"));
                }
                result.append(macros.getResult("row_end"));
            }
            firstInRow = !firstInRow;
        }
        result.append(macros.getResult("content_end"));
        return result.toString();
    }

    public void createDefaultLayoutPatterns() {
        this.m_layoutPatterns.put(PARAGRAPH_TYPE_BOTTOM, IMG_WIDTH_LARGE);
        this.m_layoutPatterns.put(PARAGRAPH_TYPE_BOTTOM_DESCRIPTION, IMG_WIDTH_LARGE);
        this.m_layoutPatterns.put(PARAGRAPH_TYPE_TOP, IMG_WIDTH_LARGE);
        this.m_layoutPatterns.put(PARAGRAPH_TYPE_TOP_DESCRIPTION, IMG_WIDTH_LARGE);
        this.m_layoutPatterns.put(PARAGRAPH_TYPE_IMAGE_LEFT, IMG_WIDTH_MEDIUM);
        this.m_layoutPatterns.put(PARAGRAPH_TYPE_IMAGE_LEFT_DESCRIPTION, IMG_WIDTH_MEDIUM);
        this.m_layoutPatterns.put(PARAGRAPH_TYPE_IMAGE_RIGHT, IMG_WIDTH_MEDIUM);
        this.m_layoutPatterns.put(PARAGRAPH_TYPE_IMAGE_RIGHT_DESCRIPTION, IMG_WIDTH_MEDIUM);
        this.m_layoutPatterns.put(PARAGRAPH_TYPE_IMAGE_LEFT_TEXT_RIGHT, IMG_WIDTH_SMALL);
        this.m_layoutPatterns.put(PARAGRAPH_TYPE_IMAGE_LEFT_TEXT_RIGHT_DESCRIPTION, IMG_WIDTH_SMALL);
        this.m_layoutPatterns.put(PARAGRAPH_TYPE_IMAGE_RIGHT_TEXT_LEFT, IMG_WIDTH_SMALL);
        this.m_layoutPatterns.put(PARAGRAPH_TYPE_IMAGE_RIGHT_TEXT_LEFT_DESCRIPTION, IMG_WIDTH_SMALL);
    }

    public int getBodyWidth() {
        return this.m_bodyWdith;
    }

    public int getColPadding() {
        return this.m_colPadding;
    }

    public int getColSpacing() {
        return this.m_colSpacing;
    }

    public String getColumnLayout() {
        return this.m_columnLayout;
    }

    public int getColumnWidth() {
        return this.m_columnWidth;
    }

    public CmsXmlContent getContent() {
        return this.m_content;
    }

    public int getImgWidthLarge() {
        return this.m_imgWidthLarge;
    }

    public int getImgWidthMedium() {
        return this.m_imgWidthMedium;
    }

    public int getImgWidthSmall() {
        return this.m_imgWidthSmall;
    }

    public Map getLayoutPatterns() {
        return this.m_layoutPatterns;
    }

    public String getPathLayoutElements() {
        return this.m_pathLayoutElements;
    }

    public String getVariant() {
        return this.m_variant;
    }

    public void init(CmsJspActionElement jsp, CmsXmlContent content, String variant, int bodyWith, int colPadding, int colSpacing) {
        this.setPathLayoutElements(VFS_PATH_LAYOUTELEMENTS);
        this.setCmsJspActionElement(jsp);
        this.setContent(content);
        this.setVariant(variant);
        String layout = this.m_content.getStringValue(this.getCmsObject(), NODE_COLUMNS_LAYOUT, jsp.getRequestContext().getLocale());
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)layout)) {
            layout = COLUMNS_LAYOUT_1;
        }
        this.setColumnLayout(layout);
        this.setColPadding(colPadding);
        this.setColSpacing(colSpacing);
        this.setBodyWidth(bodyWith);
        this.setLayoutPatterns(new HashMap(16));
    }

    public boolean isFixedImageSize() {
        return this.m_fixedImageSize;
    }

    public void setBodyWidth(int bodyWidth) {
        this.m_bodyWdith = bodyWidth;
    }

    public void setCmsJspActionElement(CmsJspActionElement jsp) {
        this.m_jspActionElement = jsp;
    }

    public void setColPadding(int colPadding) {
        this.m_colPadding = colPadding;
    }

    public void setColSpacing(int colSpacing) {
        this.m_colSpacing = colSpacing;
    }

    public void setColumnLayout(String colLayout) {
        this.m_columnLayout = colLayout;
    }

    public void setContent(CmsXmlContent content) {
        this.m_content = content;
    }

    public void setFixedImageSize(boolean fixedImageSize) {
        this.m_fixedImageSize = fixedImageSize;
    }

    public void setImgWidthLarge(int largeImgWidth) {
        this.m_imgWidthLarge = largeImgWidth;
    }

    public void setImgWidthMedium(int mediumImgWidth) {
        this.m_imgWidthMedium = mediumImgWidth;
    }

    public void setImgWidthSmall(int smallImgWidth) {
        this.m_imgWidthSmall = smallImgWidth;
    }

    public void setLayoutPatterns(Map layoutPatterns) {
        this.m_layoutPatterns = layoutPatterns;
    }

    public void setPathLayoutElements(String pathLayoutElements) {
        this.m_pathLayoutElements = pathLayoutElements;
    }

    public void setVariant(String variant) {
        this.m_variant = variant;
    }

    protected void calculateColumnWidth() {
        if (this.getColumnLayout().indexOf(COLUMNS_LAYOUT_2) != -1) {
            this.setColumnWidth((this.getBodyWidth() - this.getColSpacing()) / 2 - 2 * this.getColPadding());
        } else {
            this.setColumnWidth(this.getBodyWidth() - 2 * this.getColPadding());
        }
    }

    protected int calculateImageWidth(String imgWidthVariant) {
        if (imgWidthVariant.equals(IMG_WIDTH_LARGE)) {
            if (this.isFixedImageSize() && this.getImgWidthLarge() > 0) {
                return this.getImgWidthLarge();
            }
            return this.getColumnWidth();
        }
        if (imgWidthVariant.equals(IMG_WIDTH_SMALL)) {
            if (this.isFixedImageSize() && this.getImgWidthSmall() > 0) {
                return this.getImgWidthSmall();
            }
            return this.getColumnWidth() / 4;
        }
        if (this.isFixedImageSize() && this.getImgWidthMedium() > 0) {
            return this.getImgWidthMedium();
        }
        return (int)Math.round((double)this.getColumnWidth() / 2.3);
    }

    protected CmsJspActionElement getCmsJspActionElement() {
        return this.m_jspActionElement;
    }

    protected CmsObject getCmsObject() {
        return this.m_jspActionElement.getCmsObject();
    }

    protected CmsImageScaler getImageScaler(String paragraphType, String imgSize) {
        String imgWidthVariant = (String)this.getLayoutPatterns().get(paragraphType);
        if (CmsStringUtil.isEmpty((String)imgWidthVariant)) {
            imgWidthVariant = IMG_WIDTH_MEDIUM;
        }
        int imgWidth = this.calculateImageWidth(imgWidthVariant);
        CmsImageScaler origImage = new CmsImageScaler(imgSize);
        CmsImageScaler scaler = new CmsImageScaler();
        scaler.setWidth(imgWidth);
        return origImage.getWidthScaler(scaler);
    }

    protected String getLinkToLargeImage(String imgUri, String imgSize) {
        StringBuffer elementLink = new StringBuffer(128);
        elementLink.append("/system/modules/");
        elementLink.append(MODULE_NAME);
        elementLink.append("/elements/popup-image.html?uri=");
        elementLink.append(imgUri);
        elementLink.append("&imgsize=");
        elementLink.append(imgSize);
        elementLink.append("&");
        elementLink.append("__locale");
        elementLink.append("=");
        elementLink.append(this.getCmsObject().getRequestContext().getLocale());
        StringBuffer tempLink = new StringBuffer(256);
        tempLink.append("javascript:window.open('");
        tempLink.append(this.getCmsJspActionElement().link(elementLink.toString()));
        tempLink.append("', 'largeImage', ");
        tempLink.append("'width=620,height=400,location=no,menubar=no,toolbar=no,status=no,scrollbars=yes,resizable=yes');");
        return tempLink.toString();
    }

    protected I_CmsMacroWrapper getMacroWrapper() throws Exception {
        StringBuffer macroFile = new StringBuffer(256);
        macroFile.append(this.getPathLayoutElements());
        macroFile.append(this.getColumnLayout());
        macroFile.append("_");
        macroFile.append(this.getVariant());
        macroFile.append(".");
        macroFile.append("ftl");
        String fileName = macroFile.toString();
        if (!this.getCmsObject().existsResource(fileName)) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_VFS_RESOURCE_1", (Object)fileName));
            }
            throw new CmsException(Messages.get().container("LOG_ERR_VFS_RESOURCE_1", (Object)fileName));
        }
        return new CmsMacroWrapperFreeMarker(this.getCmsObject(), fileName);
    }

    protected String getPropertiesValue(ExtendedProperties xmlElements, String key, CmsXmlContent xmlContentFileLink, Locale locale) {
        Object value = xmlElements.get((Object)key);
        String result = "";
        if (value != null) {
            if (value instanceof String) {
                result = xmlContentFileLink.getStringValue(this.getCmsObject(), (String)value, locale);
            } else if (value instanceof Vector) {
                Iterator it_title = ((Vector)value).iterator();
                while (it_title.hasNext()) {
                    String next = (String)it_title.next();
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)xmlContentFileLink.getStringValue(this.getCmsObject(), next, locale)) || xmlContentFileLink.getStringValue(this.getCmsObject(), next, locale).equals("(none)")) continue;
                    if (result.length() > 1 && result.lastIndexOf(",") != result.length()) {
                        result = result + ",";
                    }
                    result = result + xmlContentFileLink.getStringValue(this.getCmsObject(), next, locale);
                }
            }
        } else {
            result = "";
        }
        return result;
    }

    protected ExtendedProperties getXmlElementsProperties(CmsFile linkToFile) {
        ExtendedProperties properties = new ExtendedProperties();
        try {
            String typeName = OpenCms.getResourceManager().getResourceType(linkToFile.getTypeId()).getTypeName();
            if (this.m_typeMappings.get(typeName) == null) {
                properties.load((InputStream)new ByteArrayInputStream(this.getCmsObject().readFile("/system/modules/org.opencms.frontend.layoutpage/mappings/" + typeName + ".properties").getContents()));
                this.m_typeMappings.put(typeName, properties);
            } else {
                properties = (ExtendedProperties)this.m_typeMappings.get(typeName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    protected void setColumnWidth(int columnWidth) {
        this.m_columnWidth = columnWidth;
    }
}

