/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.layoutpage;

import freemarker.core.Macro;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.frontend.layoutpage.CmsFreeMarkerTemplateCache;
import org.opencms.frontend.layoutpage.I_CmsMacroWrapper;
import org.opencms.main.CmsLog;

public class CmsMacroWrapperFreeMarker
implements I_CmsMacroWrapper {
    public static final String FILE_SUFFIX = "ftl";
    protected static final String MACRO_NAME = "ocmsmacro";
    private static final Log LOG = CmsLog.getLog((Object)CmsMacroWrapperFreeMarker.class);
    private Map m_rootMap;
    private Template m_template;

    public CmsMacroWrapperFreeMarker(CmsObject cms, String macroFile) throws Exception {
        this.init(cms, macroFile);
    }

    public String getFileSuffix() {
        return FILE_SUFFIX;
    }

    public String getResult(String macroName) {
        return this.getResult(macroName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResult(String macroName, String[] args) {
        StringWriter out = new StringWriter();
        boolean error = false;
        try {
            Macro macro = (Macro)this.m_template.getMacros().get(macroName);
            if (macro != null) {
                this.putContextVariable(MACRO_NAME, macro);
                this.m_template.process((Object)this.getContext(), (Writer)out);
            } else {
                error = true;
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            error = true;
        }
        finally {
            try {
                ((Writer)out).close();
            }
            catch (Exception e) {}
        }
        if (error) {
            return "";
        }
        return ((Object)out).toString();
    }

    public void init(CmsObject cms, String macroFile) throws Exception {
        this.m_rootMap = new HashMap(16);
        CmsFreeMarkerTemplateCache cache = CmsFreeMarkerTemplateCache.getInstance();
        this.m_template = cache.getTemplate(cms, macroFile);
    }

    public Object putContextVariable(String key, Object value) {
        return this.getContext().put(key, value);
    }

    public Object removeContextVariable(String key) {
        return this.getContext().remove(key);
    }

    private Map getContext() {
        return this.m_rootMap;
    }
}

