/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.accounts.CmsOrgUnitBean;

public abstract class A_CmsOrgUnitDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "orgunit";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_OUFQN = "oufqn";
    protected CmsOrgUnitBean m_orgUnitBean;
    private String m_paramOufqn;

    public A_CmsOrgUnitDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public A_CmsOrgUnitDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    public void setResourcesInBean(CmsOrgUnitBean orgUnitBean, List resources) {
        ArrayList<String> resourceNames = new ArrayList<String>();
        Iterator itResources = resources.iterator();
        while (itResources.hasNext()) {
            CmsResource resource = (CmsResource)itResources.next();
            resourceNames.add(this.getCms().getSitePath(resource));
        }
        orgUnitBean.setResources(resourceNames);
    }

    protected void defineWidgets() {
        this.initOrgUnitObject();
        this.setKeyPrefix(KEY_PREFIX);
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initOrgUnitObject() {
        try {
            if (CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction())) {
                CmsOrganizationalUnit orgunit = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn());
                this.m_orgUnitBean = new CmsOrgUnitBean();
                if (!this.isNewOrgUnit()) {
                    this.m_orgUnitBean.setName(orgunit.getName());
                    this.m_orgUnitBean.setDescription(orgunit.getDescription(this.getLocale()));
                    this.m_orgUnitBean.setParentOu(orgunit.getParentFqn());
                    this.m_orgUnitBean.setFqn(orgunit.getName());
                    this.m_orgUnitBean.setNologin(orgunit.hasFlagHideLogin());
                    this.m_orgUnitBean.setWebusers(orgunit.hasFlagWebuser());
                    if (orgunit.getParentFqn() != null) {
                        this.m_orgUnitBean.setParentOuDesc(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), orgunit.getParentFqn()).getDescription(this.getLocale()) + " (" + "/" + orgunit.getParentFqn() + ")");
                    }
                } else {
                    this.m_orgUnitBean.setParentOu(orgunit.getName());
                    this.m_orgUnitBean.setParentOuDesc(orgunit.getDescription(this.getLocale()) + " (" + "/" + orgunit.getName() + ")");
                }
                List resources = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.getCms(), orgunit.getName());
                this.setResourcesInBean(this.m_orgUnitBean, resources);
            } else {
                this.m_orgUnitBean = (CmsOrgUnitBean)this.getDialogObject();
                this.m_orgUnitBean.getName();
            }
        }
        catch (Exception e) {
            this.m_orgUnitBean = new CmsOrgUnitBean();
            this.m_orgUnitBean.setParentOu(this.getParamOufqn());
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_orgUnitBean);
    }

    protected boolean isNewOrgUnit() {
        return this.getCurrentToolPath().endsWith("/orgunit/mgmt/new");
    }
}

