/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.tools.accounts.Messages;

public abstract class A_CmsOrgUnitUsersList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_ACTION_STATE = "as";
    public static final String LIST_COLUMN_FULLNAME = "cf";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_LOGIN = "cl";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_ORGUNIT = "co";
    public static final String LIST_COLUMN_STATE = "cs";
    public static final String NOT_ORGUNIT_USERS = "not_orgunit_users";
    public static final String ORGUNIT_USERS = "orgunit_users";
    private List m_notOuUsers;
    private List m_ouUsers;
    private String m_paramOufqn;

    protected A_CmsOrgUnitUsersList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, boolean searchable) {
        super(jsp, listId, listName, LIST_COLUMN_LOGIN, CmsListOrderEnum.ORDER_ASCENDING, searchable ? LIST_COLUMN_NAME : null);
    }

    public List getNotOuUsers() {
        return this.m_notOuUsers;
    }

    public List getOuUsers() {
        return this.m_ouUsers;
    }

    public String getIconPath(CmsListItem item) {
        try {
            CmsUser user = this.getCms().readUser((String)item.get(LIST_COLUMN_LOGIN));
            if (user.getOuFqn().equals(this.getParamOufqn())) {
                return "tools/accounts/buttons/user.png";
            }
            return "tools/accounts/buttons/user_other_ou.png";
        }
        catch (CmsException e) {
            return "tools/accounts/buttons/user.png";
        }
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public void setNotOuUsers(List notOuUsers) {
        this.m_notOuUsers = notOuUsers;
        this.getJsp().getRequest().getSession().setAttribute(NOT_ORGUNIT_USERS, (Object)this.m_notOuUsers);
    }

    public void setOuUsers(List ouUsers) {
        this.m_ouUsers = ouUsers;
        this.getJsp().getRequest().getSession().setAttribute(ORGUNIT_USERS, (Object)this.m_ouUsers);
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    protected void fillDetails(String detailId) {
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List users = this.getUsers();
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            CmsUser user = (CmsUser)itUsers.next();
            CmsListItem item = this.getList().newItem(user.getId().toString());
            item.set(LIST_COLUMN_LOGIN, (Object)user.getName());
            item.set(LIST_COLUMN_NAME, (Object)user.getSimpleName());
            item.set(LIST_COLUMN_ORGUNIT, (Object)("/" + user.getOuFqn()));
            item.set(LIST_COLUMN_FULLNAME, (Object)user.getFullName());
            ret.add(item);
        }
        return ret;
    }

    protected abstract List getUsers() throws CmsException;

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_ICON_0"));
        iconCol.setHelpText(Messages.get().container("GUI_USERS_LIST_COLS_ICON_HELP_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        this.setIconAction(iconCol);
        metadata.addColumn(iconCol);
        this.setStateActionCol(metadata);
        CmsListColumnDefinition loginCol = new CmsListColumnDefinition(LIST_COLUMN_LOGIN);
        loginCol.setVisible(false);
        metadata.addColumn(loginCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_LOGIN_0"));
        nameCol.setWidth("20%");
        this.setDefaultAction(nameCol);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition orgUnitCol = new CmsListColumnDefinition(LIST_COLUMN_ORGUNIT);
        orgUnitCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_ORGUNIT_0"));
        orgUnitCol.setWidth("40%");
        metadata.addColumn(orgUnitCol);
        CmsListColumnDefinition fullnameCol = new CmsListColumnDefinition(LIST_COLUMN_FULLNAME);
        fullnameCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_FULLNAME_0"));
        fullnameCol.setWidth("40%");
        fullnameCol.setTextWrapping(true);
        metadata.addColumn(fullnameCol);
    }

    protected abstract void setDefaultAction(CmsListColumnDefinition var1);

    protected abstract void setIconAction(CmsListColumnDefinition var1);

    protected void setIndependentActions(CmsListMetadata metadata) {
    }

    protected abstract void setStateActionCol(CmsListMetadata var1);

    protected void validateParamaters() throws Exception {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParamOufqn()));
        OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.m_paramOufqn).getName();
    }
}

