/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.accounts.Messages;

public abstract class A_CmsOrgUnitsList
extends A_CmsListDialog {
    public static final String LIST_ACTION_DEACTIVE = "add";
    public static final String LIST_ACTION_DELETE = "ad";
    public static final String LIST_ACTION_EDIT = "ae";
    public static final String LIST_ACTION_GROUP = "ag";
    public static final String LIST_ACTION_USER = "au";
    public static final String LIST_COLUMN_ADMIN = "ca";
    public static final String LIST_COLUMN_DELETE = "cd";
    public static final String LIST_COLUMN_DESCRIPTION = "cb";
    public static final String LIST_COLUMN_EDIT = "ce";
    public static final String LIST_COLUMN_GROUP = "cg";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_USER = "cu";
    public static final String LIST_COLUMN_WEBUSER = "cw";
    public static final String LIST_DEFACTION_OVERVIEW = "do";
    public static final String LIST_DETAIL_GROUPS = "dg";
    public static final String LIST_DETAIL_RESOURCES = "dr";
    public static final String LIST_DETAIL_USERS = "du";
    public static final String LIST_MACTION_DELETE = "md";
    public static final String PATH_BUTTONS = "tools/accounts/buttons/";

    public A_CmsOrgUnitsList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        super(jsp, listId, listName, LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public void executeListMultiActions() {
        Iterator itItems = this.getSelectedItems().iterator();
        if (this.getParamListAction().equals(LIST_MACTION_DELETE)) {
            while (itItems.hasNext()) {
                CmsListItem item = (CmsListItem)itItems.next();
                String ouFqn = item.get(LIST_COLUMN_NAME).toString();
                try {
                    OpenCms.getOrgUnitManager().deleteOrganizationalUnit(this.getCms(), ouFqn.substring(1));
                }
                catch (CmsException e) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_DELETE_ORGUNIT_1", (Object)ouFqn), (Throwable)e);
                }
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws IOException, ServletException {
        String ouFqn = this.getSelectedItem().get(LIST_COLUMN_NAME).toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oufqn", ouFqn.substring(1));
        params.put("action", "initial");
        if (this.getParamListAction().equals(LIST_ACTION_EDIT)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/accounts/orgunit/mgmt/edit", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_USER)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/accounts/orgunit/users", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_GROUP)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/accounts/orgunit/groups", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_DELETE)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/accounts/orgunit/mgmt/delete", params);
        } else if (this.getParamListAction().equals(LIST_DEFACTION_OVERVIEW)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/accounts/orgunit", params);
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public String getEditIcon() {
        return "tools/accounts/buttons/orgunit.png";
    }

    public String getGroupIcon() {
        return "tools/accounts/buttons/group.png";
    }

    public String getUserIcon() {
        return "tools/accounts/buttons/user.png";
    }

    protected void fillDetails(String detailId) {
        List orgUnits = this.getList().getAllContent();
        Iterator itOrgUnits = orgUnits.iterator();
        while (itOrgUnits.hasNext()) {
            CmsListItem item = (CmsListItem)itOrgUnits.next();
            String ouFqn = item.get(LIST_COLUMN_NAME).toString();
            StringBuffer html = new StringBuffer(512);
            try {
                if (detailId.equals(LIST_DETAIL_USERS)) {
                    List usersOrgUnit = OpenCms.getOrgUnitManager().getUsers(this.getCms(), ouFqn, false);
                    Iterator itUsersOrgUnit = usersOrgUnit.iterator();
                    while (itUsersOrgUnit.hasNext()) {
                        CmsUser user = (CmsUser)itUsersOrgUnit.next();
                        html.append(user.getFullName());
                        if (itUsersOrgUnit.hasNext()) {
                            html.append("<br>");
                        }
                        html.append("\n");
                    }
                } else if (detailId.equals(LIST_DETAIL_GROUPS)) {
                    List groupsOrgUnit = OpenCms.getOrgUnitManager().getGroups(this.getCms(), ouFqn, false);
                    Iterator itGroupsOrgUnit = groupsOrgUnit.iterator();
                    while (itGroupsOrgUnit.hasNext()) {
                        CmsGroup group = (CmsGroup)itGroupsOrgUnit.next();
                        html.append(group.getSimpleName());
                        if (itGroupsOrgUnit.hasNext()) {
                            html.append("<br>");
                        }
                        html.append("\n");
                    }
                } else {
                    if (!detailId.equals(LIST_DETAIL_RESOURCES)) continue;
                    List resourcesOrgUnit = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.getCms(), ouFqn);
                    Iterator itResourcesOrgUnit = resourcesOrgUnit.iterator();
                    while (itResourcesOrgUnit.hasNext()) {
                        CmsResource resource = (CmsResource)itResourcesOrgUnit.next();
                        html.append(resource.getRootPath());
                        if (itResourcesOrgUnit.hasNext()) {
                            html.append("<br>");
                        }
                        html.append("\n");
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List orgUnits = this.getOrgUnits();
        Iterator itOrgUnits = orgUnits.iterator();
        while (itOrgUnits.hasNext()) {
            CmsOrganizationalUnit childOrgUnit = (CmsOrganizationalUnit)itOrgUnits.next();
            CmsListItem item = this.getList().newItem(childOrgUnit.getName());
            item.set(LIST_COLUMN_NAME, (Object)("/" + childOrgUnit.getName()));
            item.set(LIST_COLUMN_DESCRIPTION, (Object)childOrgUnit.getDescription(this.getLocale()));
            item.set(LIST_COLUMN_ADMIN, (Object)OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.ADMINISTRATOR.forOrgUnit(childOrgUnit.getName())));
            item.set(LIST_COLUMN_WEBUSER, (Object)childOrgUnit.hasFlagWebuser());
            ret.add(item);
        }
        return ret;
    }

    protected List getOrgUnits() throws CmsException {
        return OpenCms.getRoleManager().getOrgUnitsForRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(""), true);
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition editCol = new CmsListColumnDefinition(LIST_COLUMN_EDIT);
        editCol.setName(Messages.get().container("GUI_ORGUNITS_LIST_COLS_EDIT_0"));
        editCol.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_EDIT_HELP_0"));
        editCol.setWidth("20");
        editCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        editCol.setSorteable(false);
        CmsListDirectAction editAction = new CmsListDirectAction(LIST_ACTION_EDIT){

            public CmsMessageContainer getHelpText() {
                if (!this.isEnabled()) {
                    return Messages.get().container("GUI_ORGUNIT_ADMIN_TOOL_DISABLED_EDIT_HELP_0");
                }
                return super.getHelpText();
            }

            public String getIconPath() {
                if (this.getItem() != null && ((Boolean)this.getItem().get(A_CmsOrgUnitsList.LIST_COLUMN_WEBUSER)).booleanValue()) {
                    return "tools/accounts/buttons/webuser_ou.png";
                }
                return super.getIconPath();
            }

            public boolean isEnabled() {
                if (this.getItem() != null) {
                    return (Boolean)this.getItem().get(A_CmsOrgUnitsList.LIST_COLUMN_ADMIN);
                }
                return super.isVisible();
            }
        };
        editAction.setName(Messages.get().container("GUI_ORGUNITS_LIST_ACTION_EDIT_NAME_0"));
        editAction.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_EDIT_HELP_0"));
        editAction.setIconPath(this.getEditIcon());
        editCol.addDirectAction((I_CmsListDirectAction)editAction);
        metadata.addColumn(editCol);
        CmsListColumnDefinition userCol = new CmsListColumnDefinition(LIST_COLUMN_USER);
        userCol.setName(Messages.get().container("GUI_ORGUNITS_LIST_COLS_USER_0"));
        userCol.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_USER_HELP_0"));
        userCol.setWidth("20");
        userCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        userCol.setSorteable(false);
        CmsListDirectAction userAction = new CmsListDirectAction(LIST_ACTION_USER);
        userAction.setName(Messages.get().container("GUI_ORGUNITS_LIST_ACTION_USER_NAME_0"));
        userAction.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_USER_HELP_0"));
        userAction.setIconPath(this.getUserIcon());
        userCol.addDirectAction((I_CmsListDirectAction)userAction);
        metadata.addColumn(userCol);
        CmsListColumnDefinition groupCol = new CmsListColumnDefinition(LIST_COLUMN_GROUP);
        groupCol.setName(Messages.get().container("GUI_ORGUNITS_LIST_COLS_GROUP_0"));
        groupCol.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_GROUP_HELP_0"));
        groupCol.setWidth("20");
        groupCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        groupCol.setSorteable(false);
        CmsListDirectAction groupAction = new CmsListDirectAction(LIST_ACTION_GROUP);
        groupAction.setName(Messages.get().container("GUI_ORGUNITS_LIST_ACTION_GROUP_NAME_0"));
        groupAction.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_GROUP_HELP_0"));
        groupAction.setIconPath(this.getGroupIcon());
        groupCol.addDirectAction((I_CmsListDirectAction)groupAction);
        metadata.addColumn(groupCol);
        CmsListColumnDefinition descCol = new CmsListColumnDefinition(LIST_COLUMN_DESCRIPTION);
        descCol.setName(Messages.get().container("GUI_ORGUNITS_LIST_COLS_DESCRIPTION_0"));
        descCol.setWidth("60%");
        descCol.setSorteable(true);
        CmsListDefaultAction defOverviewAction = new CmsListDefaultAction(LIST_DEFACTION_OVERVIEW);
        defOverviewAction.setName(Messages.get().container("GUI_ORGUNITS_LIST_DEFACTION_OVERVIEW_NAME_0"));
        defOverviewAction.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_DEFACTION_OVERVIEW_HELP_0"));
        descCol.addDefaultAction(defOverviewAction);
        metadata.addColumn(descCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_ORGUNITS_LIST_COLS_NAME_0"));
        nameCol.setWidth("40%");
        metadata.addColumn(nameCol);
        CmsListColumnDefinition adminCol = new CmsListColumnDefinition(LIST_COLUMN_ADMIN);
        adminCol.setVisible(false);
        metadata.addColumn(adminCol);
        CmsListColumnDefinition webuserCol = new CmsListColumnDefinition(LIST_COLUMN_WEBUSER);
        webuserCol.setVisible(false);
        metadata.addColumn(webuserCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails usersDetails = new CmsListItemDetails(LIST_DETAIL_USERS);
        usersDetails.setAtColumn(LIST_COLUMN_DESCRIPTION);
        usersDetails.setVisible(false);
        usersDetails.setShowActionName(Messages.get().container("GUI_ORGUNITS_DETAIL_SHOW_USERS_NAME_0"));
        usersDetails.setShowActionHelpText(Messages.get().container("GUI_ORGUNITS_DETAIL_SHOW_USERS_HELP_0"));
        usersDetails.setHideActionName(Messages.get().container("GUI_ORGUNITS_DETAIL_HIDE_USERS_NAME_0"));
        usersDetails.setHideActionHelpText(Messages.get().container("GUI_ORGUNITS_DETAIL_HIDE_USERS_HELP_0"));
        usersDetails.setName(Messages.get().container("GUI_ORGUNITS_DETAIL_USERS_NAME_0"));
        usersDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_ORGUNITS_DETAIL_USERS_NAME_0")));
        metadata.addItemDetails(usersDetails);
        CmsListItemDetails groupsDetails = new CmsListItemDetails(LIST_DETAIL_GROUPS);
        groupsDetails.setAtColumn(LIST_COLUMN_DESCRIPTION);
        groupsDetails.setVisible(false);
        groupsDetails.setShowActionName(Messages.get().container("GUI_ORGUNITS_DETAIL_SHOW_GROUPS_NAME_0"));
        groupsDetails.setShowActionHelpText(Messages.get().container("GUI_ORGUNITS_DETAIL_SHOW_GROUPS_HELP_0"));
        groupsDetails.setHideActionName(Messages.get().container("GUI_ORGUNITS_DETAIL_HIDE_GROUPS_NAME_0"));
        groupsDetails.setHideActionHelpText(Messages.get().container("GUI_ORGUNITS_DETAIL_HIDE_GROUPS_HELP_0"));
        groupsDetails.setName(Messages.get().container("GUI_ORGUNITS_DETAIL_GROUPS_NAME_0"));
        groupsDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_ORGUNITS_DETAIL_GROUPS_NAME_0")));
        metadata.addItemDetails(groupsDetails);
        CmsListItemDetails resourcesDetails = new CmsListItemDetails(LIST_DETAIL_RESOURCES);
        resourcesDetails.setAtColumn(LIST_COLUMN_DESCRIPTION);
        resourcesDetails.setVisible(false);
        resourcesDetails.setShowActionName(Messages.get().container("GUI_ORGUNITS_DETAIL_SHOW_RESOURCES_NAME_0"));
        resourcesDetails.setShowActionHelpText(Messages.get().container("GUI_ORGUNITS_DETAIL_SHOW_RESOURCES_HELP_0"));
        resourcesDetails.setHideActionName(Messages.get().container("GUI_ORGUNITS_DETAIL_HIDE_RESOURCES_NAME_0"));
        resourcesDetails.setHideActionHelpText(Messages.get().container("GUI_ORGUNITS_DETAIL_HIDE_RESOURCES_HELP_0"));
        resourcesDetails.setName(Messages.get().container("GUI_ORGUNITS_DETAIL_RESOURCES_NAME_0"));
        resourcesDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_ORGUNITS_DETAIL_RESOURCES_NAME_0")));
        metadata.addItemDetails(resourcesDetails);
        CmsListSearchAction searchAction = new CmsListSearchAction(metadata.getColumnDefinition(LIST_COLUMN_NAME));
        searchAction.addColumn(metadata.getColumnDefinition(LIST_COLUMN_DESCRIPTION));
        metadata.setSearchAction(searchAction);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }
}

