/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListIndependentAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;
import org.opencms.workplace.tools.accounts.Messages;

public abstract class A_CmsRoleUsersList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_COLUMN_FULLNAME = "cf";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_LOGIN = "cl";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_ORGUNIT = "co";
    public static final String LIST_COLUMN_STATE = "cs";
    public static final String LIST_DETAIL_ORGUNIT = "dou";
    public static final String PATH_BUTTONS = "tools/accounts/buttons/";
    private Boolean m_hasUsersInOtherOus;
    private String m_paramOufqn;
    private String m_paramRole;

    protected A_CmsRoleUsersList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, boolean searchable) {
        super(jsp, listId, listName, LIST_COLUMN_LOGIN, CmsListOrderEnum.ORDER_ASCENDING, searchable ? LIST_COLUMN_NAME : null);
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public String getParamRole() {
        return this.m_paramRole;
    }

    public boolean hasUsersInOtherOus() {
        if (this.m_hasUsersInOtherOus == null) {
            this.m_hasUsersInOtherOus = Boolean.FALSE;
            try {
                Iterator itUsers = this.getUsers(true).iterator();
                while (itUsers.hasNext()) {
                    CmsUser user = (CmsUser)itUsers.next();
                    if (user.getOuFqn().equals(this.getParamOufqn())) continue;
                    this.m_hasUsersInOtherOus = Boolean.TRUE;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_hasUsersInOtherOus;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    public void setParamRole(String roleName) {
        this.m_paramRole = roleName;
    }

    protected void fillDetails(String detailId) {
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        boolean withOtherOus = this.hasUsersInOtherOus() && this.getList().getMetadata().getItemDetailDefinition(LIST_DETAIL_ORGUNIT).isVisible();
        List users = this.getUsers(withOtherOus);
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            CmsUser user = (CmsUser)itUsers.next();
            CmsListItem item = this.getList().newItem(user.getId().toString());
            item.set(LIST_COLUMN_LOGIN, (Object)user.getName());
            item.set(LIST_COLUMN_NAME, (Object)user.getSimpleName());
            item.set(LIST_COLUMN_ORGUNIT, (Object)("/" + user.getOuFqn()));
            item.set(LIST_COLUMN_FULLNAME, (Object)user.getFullName());
            ret.add(item);
        }
        return ret;
    }

    protected abstract List getUsers(boolean var1) throws CmsException;

    protected void initializeDetail(String detailId) {
        super.initializeDetail(detailId);
        if (detailId.equals(LIST_DETAIL_ORGUNIT)) {
            boolean visible = this.hasUsersInOtherOus() && this.getList().getMetadata().getItemDetailDefinition(LIST_DETAIL_ORGUNIT).isVisible();
            this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ORGUNIT).setVisible(visible);
            this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ORGUNIT).setPrintable(visible);
        }
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_ICON_0"));
        iconCol.setHelpText(Messages.get().container("GUI_USERS_LIST_COLS_ICON_HELP_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        CmsListDirectAction iconAction = new CmsListDirectAction(LIST_ACTION_ICON){

            public String buttonHtml(CmsWorkplace wp) {
                if (!this.isVisible()) {
                    return "";
                }
                return A_CmsHtmlIconButton.defaultButtonHtml((CmsHtmlIconButtonStyleEnum)this.resolveButtonStyle(), (String)(this.getId() + this.getItem().getId()), (String)(this.getId() + this.getItem().getId()), (String)this.resolveName(wp.getLocale()), (String)this.resolveHelpText(wp.getLocale()), (boolean)this.isEnabled(), (String)this.getIconPath(), null, (String)this.resolveOnClic(wp.getLocale()), (boolean)false, null);
            }

            public CmsMessageContainer getHelpText() {
                try {
                    CmsUser user = A_CmsRoleUsersList.this.getCms().readUser((String)this.getItem().get(A_CmsRoleUsersList.LIST_COLUMN_LOGIN));
                    if (user.getOuFqn().equals(((A_CmsRoleUsersList)this.getWp()).getParamOufqn())) {
                        List userRoles = OpenCms.getRoleManager().getRolesOfUser(((A_CmsRoleUsersList)this.getWp()).getCms(), user.getName(), ((A_CmsRoleUsersList)this.getWp()).getParamOufqn(), false, true, true);
                        Iterator itUserRoles = userRoles.iterator();
                        while (itUserRoles.hasNext()) {
                            CmsRole role = (CmsRole)itUserRoles.next();
                            if (!role.getGroupName().equals(((A_CmsRoleUsersList)this.getWp()).getParamRole())) continue;
                            return Messages.get().container("GUI_USERS_LIST_INROLE_HELP_0");
                        }
                        return Messages.get().container("GUI_USERS_LIST_INROLE_INDIRECT_HELP_0");
                    }
                    return Messages.get().container("GUI_USERS_LIST_INROLE_OTHEROU_HELP_0");
                }
                catch (CmsException e) {
                    return Messages.get().container("GUI_USERS_LIST_INROLE_HELP_0");
                }
            }

            public String getIconPath() {
                try {
                    CmsUser user = A_CmsRoleUsersList.this.getCms().readUser((String)this.getItem().get(A_CmsRoleUsersList.LIST_COLUMN_LOGIN));
                    if (user.getOuFqn().equals(((A_CmsRoleUsersList)this.getWp()).getParamOufqn())) {
                        List userRoles = OpenCms.getRoleManager().getRolesOfUser(((A_CmsRoleUsersList)this.getWp()).getCms(), user.getName(), ((A_CmsRoleUsersList)this.getWp()).getParamOufqn(), false, true, true);
                        Iterator itUserRoles = userRoles.iterator();
                        while (itUserRoles.hasNext()) {
                            CmsRole role = (CmsRole)itUserRoles.next();
                            if (!role.getGroupName().equals(((A_CmsRoleUsersList)this.getWp()).getParamRole())) continue;
                            return "tools/accounts/buttons/user.png";
                        }
                        return "tools/accounts/buttons/user_indirect.png";
                    }
                    return "tools/accounts/buttons/user_other_ou.png";
                }
                catch (CmsException e) {
                    return "tools/accounts/buttons/user.png";
                }
            }

            public CmsMessageContainer getName() {
                try {
                    CmsUser user = A_CmsRoleUsersList.this.getCms().readUser((String)this.getItem().get(A_CmsRoleUsersList.LIST_COLUMN_LOGIN));
                    if (user.getOuFqn().equals(((A_CmsRoleUsersList)this.getWp()).getParamOufqn())) {
                        List userRoles = OpenCms.getRoleManager().getRolesOfUser(((A_CmsRoleUsersList)this.getWp()).getCms(), user.getName(), ((A_CmsRoleUsersList)this.getWp()).getParamOufqn(), false, true, true);
                        Iterator itUserRoles = userRoles.iterator();
                        while (itUserRoles.hasNext()) {
                            CmsRole role = (CmsRole)itUserRoles.next();
                            if (!role.getGroupName().equals(((A_CmsRoleUsersList)this.getWp()).getParamRole())) continue;
                            return Messages.get().container("GUI_USERS_LIST_INROLE_NAME_0");
                        }
                        return Messages.get().container("GUI_USERS_LIST_INROLE_INDIRECT_NAME_0");
                    }
                    return Messages.get().container("GUI_USERS_LIST_INROLE_OTHEROU_NAME_0");
                }
                catch (CmsException e) {
                    return Messages.get().container("GUI_USERS_LIST_INROLE_NAME_0");
                }
            }
        };
        iconAction.setName(Messages.get().container("GUI_USERS_LIST_INROLE_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_USERS_LIST_INROLE_HELP_0"));
        iconAction.setIconPath("tools/accounts/buttons/user.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)iconAction);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition loginCol = new CmsListColumnDefinition(LIST_COLUMN_LOGIN);
        loginCol.setVisible(false);
        metadata.addColumn(loginCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_LOGIN_0"));
        nameCol.setWidth("35%");
        metadata.addColumn(nameCol);
        CmsListColumnDefinition orgunitCol = new CmsListColumnDefinition(LIST_COLUMN_ORGUNIT);
        orgunitCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_ORGUNIT_0"));
        orgunitCol.setVisible(false);
        metadata.addColumn(orgunitCol);
        CmsListColumnDefinition fullnameCol = new CmsListColumnDefinition(LIST_COLUMN_FULLNAME);
        fullnameCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_FULLNAME_0"));
        fullnameCol.setWidth("65%");
        fullnameCol.setTextWrapping(true);
        metadata.addColumn(fullnameCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails otherOuDetails = new CmsListItemDetails(LIST_DETAIL_ORGUNIT);
        otherOuDetails.setAtColumn(LIST_COLUMN_NAME);
        otherOuDetails.setVisible(false);
        otherOuDetails.setHideAction((I_CmsListAction)new CmsListIndependentAction(LIST_DETAIL_ORGUNIT){

            public String getIconPath() {
                return "list/details_hide.png";
            }

            public boolean isVisible() {
                return ((A_CmsRoleUsersList)this.getWp()).hasUsersInOtherOus();
            }
        });
        otherOuDetails.setShowAction((I_CmsListAction)new CmsListIndependentAction(LIST_DETAIL_ORGUNIT){

            public String getIconPath() {
                return "list/details_show.png";
            }

            public boolean isVisible() {
                return ((A_CmsRoleUsersList)this.getWp()).hasUsersInOtherOus();
            }
        });
        otherOuDetails.setShowActionName(Messages.get().container("GUI_USERS_DETAIL_SHOW_OTHEROU_NAME_0"));
        otherOuDetails.setShowActionHelpText(Messages.get().container("GUI_USERS_DETAIL_SHOW_OTHEROU_HELP_0"));
        otherOuDetails.setHideActionName(Messages.get().container("GUI_USERS_DETAIL_HIDE_OTHEROU_NAME_0"));
        otherOuDetails.setHideActionHelpText(Messages.get().container("GUI_USERS_DETAIL_HIDE_OTHEROU_HELP_0"));
        otherOuDetails.setName(Messages.get().container("GUI_USERS_DETAIL_OTHEROU_NAME_0"));
        otherOuDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_USERS_DETAIL_OTHEROU_NAME_0")));
        otherOuDetails.setVisible(true);
        metadata.addItemDetails(otherOuDetails);
    }

    protected void validateParamaters() throws Exception {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParamOufqn()));
        CmsRole.valueOf((CmsGroup)this.getCms().readGroup(this.getParamRole())).getRoleName();
    }
}

