/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsGroup;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.accounts.Messages;

public abstract class A_CmsRolesList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_COLUMN_DEPENDENCY = "cd";
    public static final String LIST_COLUMN_GROUP_NAME = "cgn";
    public static final String LIST_COLUMN_HIDDEN_NAME = "chn";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_DETAIL_DESCRIPTION = "dd";
    public static final String LIST_DETAIL_PATH = "dp";
    public static final String PATH_BUTTONS = "tools/accounts/buttons/";
    private String m_paramOufqn;

    protected A_CmsRolesList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        super(jsp, listId, listName, LIST_COLUMN_HIDDEN_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public abstract String getIconPath(CmsListItem var1);

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    protected void fillDetails(String detailId) {
        List roles = this.getList().getAllContent();
        Iterator itRoles = roles.iterator();
        while (itRoles.hasNext()) {
            CmsListItem item = (CmsListItem)itRoles.next();
            String roleName = item.get(LIST_COLUMN_GROUP_NAME).toString();
            StringBuffer html = new StringBuffer(512);
            try {
                if (detailId.equals(LIST_DETAIL_PATH)) {
                    html.append(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), CmsOrganizationalUnit.getParentFqn((String)roleName)).getDisplayName(this.getLocale()));
                } else {
                    if (!detailId.equals(LIST_DETAIL_DESCRIPTION)) continue;
                    CmsRole role = CmsRole.valueOf((CmsGroup)this.getCms().readGroup(roleName));
                    html.append(role.getDescription(this.getCms().getRequestContext().getLocale()));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List roles = this.getRoles();
        ArrayList pRoles = new ArrayList(roles);
        Iterator itRoles = roles.iterator();
        while (itRoles.hasNext()) {
            CmsRole role = (CmsRole)itRoles.next();
            CmsListItem item = this.getList().newItem(role.getGroupName());
            Locale locale = this.getCms().getRequestContext().getLocale();
            item.set(LIST_COLUMN_NAME, (Object)role.getName(locale));
            String dependency = "";
            CmsRole parent = role;
            while (parent.getParentRole() != null && parent.getParentRole().getParentRole() != null) {
                String roleName = parent.getParentRole().getName(locale);
                if (dependency.length() > 0) {
                    roleName = roleName + ", ";
                }
                dependency = roleName + dependency;
                parent = parent.getParentRole();
            }
            String hiddenName = dependency;
            if (role.forOrgUnit(null).equals((Object)CmsRole.WORKPLACE_USER)) {
                dependency = "";
                Iterator itWuParents = pRoles.iterator();
                while (itWuParents.hasNext()) {
                    CmsRole wuParent = (CmsRole)itWuParents.next();
                    if (wuParent.forOrgUnit(null).equals((Object)CmsRole.WORKPLACE_USER) || wuParent.forOrgUnit(null).equals((Object)CmsRole.ROOT_ADMIN)) continue;
                    String roleName = wuParent.getName(locale);
                    if (dependency.length() > 0) {
                        roleName = roleName + ", ";
                    }
                    dependency = roleName + dependency;
                }
            }
            item.set(LIST_COLUMN_DEPENDENCY, (Object)dependency);
            hiddenName = hiddenName.length() > 0 ? CmsRole.ROOT_ADMIN.getName(locale) + ", " + hiddenName : CmsRole.ROOT_ADMIN.getName(locale);
            if (role.getParentRole() != null) {
                hiddenName = hiddenName + ", " + role.getName(locale);
            }
            item.set(LIST_COLUMN_HIDDEN_NAME, (Object)hiddenName);
            item.set(LIST_COLUMN_GROUP_NAME, (Object)role.getGroupName());
            ret.add(item);
        }
        return ret;
    }

    protected abstract List getRoles() throws CmsException;

    protected boolean includeOuDetails() {
        return true;
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_ROLEEDIT_LIST_COLS_ICON_0"));
        iconCol.setHelpText(Messages.get().container("GUI_ROLEEDIT_LIST_COLS_ICON_HELP_0"));
        iconCol.setWidth("1%");
        iconCol.setSorteable(false);
        CmsListDefaultAction dirAction = new CmsListDefaultAction(LIST_ACTION_ICON){

            public String getIconPath() {
                return ((A_CmsRolesList)this.getWp()).getIconPath(this.getItem());
            }
        };
        dirAction.setName(Messages.get().container("GUI_ROLEEDIT_LIST_ICON_NAME_0"));
        dirAction.setHelpText(Messages.get().container("GUI_ROLEEDIT_LIST_ICON_HELP_0"));
        dirAction.setIconPath("tools/accounts/buttons/role.png");
        dirAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)dirAction);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_ROLEEDIT_LIST_COLS_NAME_0"));
        nameCol.setWidth("40%");
        metadata.addColumn(nameCol);
        CmsListColumnDefinition depCol = new CmsListColumnDefinition(LIST_COLUMN_DEPENDENCY);
        depCol.setName(Messages.get().container("GUI_ROLEEDIT_LIST_COLS_DEPENDENCY_0"));
        depCol.setWidth("60%");
        depCol.setTextWrapping(true);
        metadata.addColumn(depCol);
        CmsListColumnDefinition hideNameCol = new CmsListColumnDefinition(LIST_COLUMN_HIDDEN_NAME);
        hideNameCol.setSorteable(true);
        hideNameCol.setVisible(false);
        metadata.addColumn(hideNameCol);
        hideNameCol.setPrintable(false);
        CmsListColumnDefinition groupNameCol = new CmsListColumnDefinition(LIST_COLUMN_GROUP_NAME);
        groupNameCol.setVisible(false);
        metadata.addColumn(groupNameCol);
        groupNameCol.setPrintable(false);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails descriptionDetails = new CmsListItemDetails(LIST_DETAIL_DESCRIPTION);
        descriptionDetails.setAtColumn(LIST_COLUMN_NAME);
        descriptionDetails.setVisible(true);
        descriptionDetails.setShowActionName(Messages.get().container("GUI_ROLEEDIT_DETAIL_SHOW_DESCRIPTION_NAME_0"));
        descriptionDetails.setShowActionHelpText(Messages.get().container("GUI_ROLEEDIT_DETAIL_SHOW_DESCRIPTION_HELP_0"));
        descriptionDetails.setHideActionName(Messages.get().container("GUI_ROLEEDIT_DETAIL_HIDE_DESCRIPTION_NAME_0"));
        descriptionDetails.setHideActionHelpText(Messages.get().container("GUI_ROLEEDIT_DETAIL_HIDE_DESCRIPTION_HELP_0"));
        descriptionDetails.setName(Messages.get().container("GUI_ROLEEDIT_DETAIL_DESCRIPTION_NAME_0"));
        descriptionDetails.setFormatter(new I_CmsListFormatter(){

            public String format(Object data, Locale locale) {
                StringBuffer html = new StringBuffer(512);
                html.append("<table border='0' cellspacing='0' cellpadding='0'>\n");
                html.append("\t<tr>\n");
                html.append("\t\t<td style='white-space:normal;' >\n");
                html.append("\t\t\t");
                html.append(data == null ? "" : data);
                html.append("\n");
                html.append("\t\t</td>\n");
                html.append("\t</tr>\n");
                html.append("</table>\n");
                return html.toString();
            }
        });
        metadata.addItemDetails(descriptionDetails);
        if (this.includeOuDetails()) {
            CmsListItemDetails pathDetails = new CmsListItemDetails(LIST_DETAIL_PATH);
            pathDetails.setAtColumn(LIST_COLUMN_NAME);
            pathDetails.setVisible(false);
            pathDetails.setShowActionName(Messages.get().container("GUI_ROLES_DETAIL_SHOW_PATH_NAME_0"));
            pathDetails.setShowActionHelpText(Messages.get().container("GUI_ROLES_DETAIL_SHOW_PATH_HELP_0"));
            pathDetails.setHideActionName(Messages.get().container("GUI_ROLES_DETAIL_HIDE_PATH_NAME_0"));
            pathDetails.setHideActionHelpText(Messages.get().container("GUI_ROLES_DETAIL_HIDE_PATH_HELP_0"));
            pathDetails.setName(Messages.get().container("GUI_ROLES_DETAIL_PATH_NAME_0"));
            pathDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_ROLES_DETAIL_PATH_NAME_0")));
            metadata.addItemDetails(pathDetails);
        }
    }

    protected void validateParamaters() throws Exception {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParamOufqn()));
    }
}

