/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListResourceIconAction;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;
import org.opencms.workplace.tools.accounts.CmsDependencyIconActionType;

public class CmsDependencyIconAction
extends CmsListResourceIconAction {
    public static final String PATH_BUTTONS = "tools/accounts/buttons/";
    private final CmsDependencyIconActionType m_type;

    public CmsDependencyIconAction(String id, CmsDependencyIconActionType type, CmsObject cms) {
        super(id + type.getId(), "ct", cms);
        this.m_type = type;
    }

    public String buttonHtml(CmsWorkplace wp) {
        if (!this.isVisible()) {
            return "";
        }
        if (this.m_type == CmsDependencyIconActionType.RESOURCE) {
            return super.buttonHtml(wp);
        }
        return A_CmsHtmlIconButton.defaultButtonHtml((CmsHtmlIconButtonStyleEnum)this.resolveButtonStyle(), (String)(this.getId() + this.getItem().getId()), (String)this.getId(), (String)this.resolveName(wp.getLocale()), (String)this.resolveHelpText(wp.getLocale()), (boolean)this.isEnabled(), (String)this.getIconPath(), null, (String)this.resolveOnClic(wp.getLocale()), (this.getColumnForTexts() == null ? 1 : 0) != 0, null);
    }

    public String getIconPath() {
        if (this.m_type == CmsDependencyIconActionType.USER) {
            return "tools/accounts/buttons/user.png";
        }
        if (this.m_type == CmsDependencyIconActionType.GROUP) {
            return "tools/accounts/buttons/group.png";
        }
        return super.getIconPath();
    }

    public CmsDependencyIconActionType getType() {
        return this.m_type;
    }

    public boolean isVisible() {
        boolean visible;
        block12: {
            visible = false;
            if (this.getItem() != null) {
                CmsUUID id = new CmsUUID(this.getItem().getId());
                try {
                    if (this.m_type == CmsDependencyIconActionType.RESOURCE) {
                        try {
                            this.getCms().readUser(id);
                        }
                        catch (CmsException e1) {
                            try {
                                this.getCms().readGroup(id);
                                break block12;
                            }
                            catch (CmsException e2) {
                                visible = true;
                            }
                        }
                        break block12;
                    }
                    if (this.m_type == CmsDependencyIconActionType.USER) {
                        this.getCms().readUser(id);
                        visible = true;
                    } else if (this.m_type == CmsDependencyIconActionType.GROUP) {
                        this.getCms().readGroup(id);
                        visible = true;
                    }
                }
                catch (CmsException cmsException) {}
            } else {
                visible = super.isVisible();
            }
        }
        return visible;
    }
}

