/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.CmsWorkplaceUserInfoBlock;
import org.opencms.workplace.CmsWorkplaceUserInfoEntry;
import org.opencms.workplace.CmsWorkplaceUserInfoManager;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.accounts.CmsUserAddInfoBean;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsEditUserAddInfoDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "userinfo";
    public static final String[] PAGES = new String[]{"page1"};
    protected List m_addInfoList;
    protected CmsUser m_user;
    private SortedMap m_addInfoEditable;
    private SortedMap m_addInfoReadOnly;
    private String m_paramEditall;
    private String m_paramUserid;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public CmsEditUserAddInfoDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsEditUserAddInfoDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            if (!Boolean.valueOf(this.getParamEditall()).booleanValue()) {
                Iterator it = this.m_addInfoList.iterator();
                while (it.hasNext()) {
                    CmsUserAddInfoBean infoBean = (CmsUserAddInfoBean)it.next();
                    if (infoBean.getValue() == null) {
                        this.m_user.deleteAdditionalInfo(infoBean.getName());
                        continue;
                    }
                    this.m_user.setAdditionalInfo(infoBean.getName(), CmsDataTypeUtil.parse((String)infoBean.getValue(), (Class)infoBean.getType()));
                }
            } else {
                String key;
                Map.Entry entry;
                HashMap readOnly = new HashMap();
                Iterator itEntries = this.m_user.getAdditionalInfo().entrySet().iterator();
                while (itEntries.hasNext()) {
                    entry = itEntries.next();
                    if (CmsDataTypeUtil.isParseable(entry.getValue().getClass())) continue;
                    key = entry.getKey().toString();
                    if (!entry.getValue().getClass().equals(class$java$lang$String == null ? CmsEditUserAddInfoDialog.class$("java.lang.String") : class$java$lang$String)) {
                        key = key + "@" + entry.getValue().getClass().getName();
                    }
                    if (!this.m_addInfoReadOnly.containsKey(key)) continue;
                    readOnly.put(entry.getKey(), entry.getValue());
                }
                this.m_user.setAdditionalInfo(readOnly);
                itEntries = this.m_addInfoEditable.entrySet().iterator();
                while (itEntries.hasNext()) {
                    Class<?> clazz;
                    entry = itEntries.next();
                    key = (String)entry.getKey();
                    int pos = key.indexOf("@");
                    if (pos < 0) {
                        this.m_user.setAdditionalInfo(key, entry.getValue());
                        continue;
                    }
                    String className = key.substring(pos + 1);
                    key = key.substring(0, pos);
                    try {
                        clazz = Class.forName(className);
                    }
                    catch (Throwable e) {
                        try {
                            clazz = Class.forName((class$java$lang$Integer == null ? CmsEditUserAddInfoDialog.class$("java.lang.Integer") : class$java$lang$Integer).getPackage().getName() + "." + className);
                        }
                        catch (Throwable e1) {
                            clazz = class$java$lang$String == null ? CmsEditUserAddInfoDialog.class$("java.lang.String") : class$java$lang$String;
                        }
                    }
                    this.m_user.setAdditionalInfo(key, CmsDataTypeUtil.parse((String)((String)entry.getValue()), (Class)clazz));
                }
            }
            this.getCms().writeUser(this.m_user);
        }
        catch (Throwable t) {
            errors.add(t);
        }
        if (errors.isEmpty() && this.getCurrentToolPath().endsWith("/orgunit/users/edit/addinfo/all")) {
            HashMap<String, Object> argMap = new HashMap<String, Object>();
            argMap.put("userid", this.m_user.getId());
            argMap.put("oufqn", this.m_user.getOuFqn());
            this.setParamCloseLink(CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)(this.getCurrentToolPath().substring(0, this.getCurrentToolPath().indexOf("/orgunit/users/edit/addinfo/all")) + "/orgunit/users/edit/"), argMap));
        }
        this.setCommitErrors(errors);
    }

    public SortedMap getInfo() {
        return this.m_addInfoEditable;
    }

    public String getParamEditall() {
        CmsWorkplaceUserInfoManager manager = OpenCms.getWorkplaceManager().getUserInfoManager();
        if (manager == null || manager.getBlocks() == null || manager.getBlocks().isEmpty()) {
            return Boolean.TRUE.toString();
        }
        return this.m_paramEditall;
    }

    public String getParamUserid() {
        return this.m_paramUserid;
    }

    public SortedMap getReadonly() {
        return this.m_addInfoReadOnly;
    }

    public void setInfo(SortedMap addInfo) {
        this.m_addInfoEditable = new TreeMap(addInfo);
    }

    public void setParamEditall(String editAll) {
        this.m_paramEditall = editAll;
    }

    public void setParamUserid(String userId) {
        this.m_paramUserid = userId;
    }

    public void setReadonly(SortedMap addInfoReadOnly) {
        this.m_addInfoReadOnly = addInfoReadOnly;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            if (!Boolean.valueOf(this.getParamEditall()).booleanValue()) {
                int pos = 0;
                Iterator it = OpenCms.getWorkplaceManager().getUserInfoManager().getBlocks().iterator();
                while (it.hasNext()) {
                    CmsWorkplaceUserInfoBlock block = (CmsWorkplaceUserInfoBlock)it.next();
                    result.append(this.dialogBlockStart(this.key(block.getTitle())));
                    result.append(this.createWidgetTableStart());
                    result.append(this.createDialogRowsHtml(pos, pos - 1 + block.getEntries().size()));
                    result.append(this.createWidgetTableEnd());
                    result.append(this.dialogBlockEnd());
                    pos += block.getEntries().size();
                }
            } else {
                result.append(this.createWidgetBlockStart(this.key("GUI_USER_EDITOR_LABEL_ADDITIONALINFO_BLOCK_0")));
                result.append(this.createDialogRowsHtml(0, 0));
                result.append(this.createWidgetBlockEnd());
                result.append(this.createWidgetBlockStart(this.key("GUI_USER_EDITOR_LABEL_READONLY_BLOCK_0")));
                result.append(this.createDialogRowsHtml(1, 1));
                result.append(this.createWidgetBlockEnd());
            }
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initUserObject();
        this.setKeyPrefix(KEY_PREFIX);
        int count = 0;
        if (!Boolean.valueOf(this.getParamEditall()).booleanValue()) {
            Iterator itBlocks = OpenCms.getWorkplaceManager().getUserInfoManager().getBlocks().iterator();
            while (itBlocks.hasNext()) {
                CmsWorkplaceUserInfoBlock block = (CmsWorkplaceUserInfoBlock)itBlocks.next();
                Iterator itEntries = block.getEntries().iterator();
                while (itEntries.hasNext()) {
                    CmsWorkplaceUserInfoEntry entry = (CmsWorkplaceUserInfoEntry)itEntries.next();
                    int min = entry.isOptional() ? 0 : 1;
                    I_CmsWidget widget = entry.getWidgetObject();
                    this.addWidget(new CmsWidgetDialogParameter(this.m_addInfoList.get(count), "value", entry.getKey(), "", PAGES[0], widget, min, 1));
                    ++count;
                }
            }
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "info", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "readonly", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        }
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initUserObject() {
        try {
            if (CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction())) {
                this.m_user = this.getCms().readUser(new CmsUUID(this.getParamUserid()));
                if (!Boolean.valueOf(this.getParamEditall()).booleanValue()) {
                    this.m_addInfoList = this.createAddInfoList(this.m_user);
                } else {
                    this.setAddInfoMaps();
                }
                return;
            }
            this.m_user = this.getCms().readUser(new CmsUUID(this.getParamUserid()));
            if (!Boolean.valueOf(this.getParamEditall()).booleanValue()) {
                this.m_addInfoList = (List)this.getDialogObject();
            } else {
                Map dObj = (Map)this.getDialogObject();
                this.m_addInfoEditable = (SortedMap)dObj.get("editable");
                this.m_addInfoReadOnly = (SortedMap)dObj.get("readonly");
            }
            return;
        }
        catch (Exception e) {
            try {
                this.m_user = this.getCms().readUser(new CmsUUID(this.getParamUserid()));
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
            if (!Boolean.valueOf(this.getParamEditall()).booleanValue()) {
                this.m_addInfoList = this.createAddInfoList(this.m_user);
            } else {
                this.setAddInfoMaps();
            }
            return;
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        if (!Boolean.valueOf(this.getParamEditall()).booleanValue()) {
            this.setDialogObject(this.m_addInfoList);
        } else {
            HashMap<String, SortedMap> dObj = new HashMap<String, SortedMap>();
            dObj.put("editable", this.m_addInfoEditable);
            dObj.put("readonly", this.m_addInfoReadOnly);
            this.setDialogObject(dObj);
        }
    }

    protected void validateParamaters() throws Exception {
        String ou = this.getCms().readUser(new CmsUUID(this.getParamUserid())).getOuFqn();
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(ou));
    }

    private List createAddInfoList(CmsUser user) {
        ArrayList<CmsUserAddInfoBean> addInfoList = new ArrayList<CmsUserAddInfoBean>();
        Iterator itBlocks = OpenCms.getWorkplaceManager().getUserInfoManager().getBlocks().iterator();
        while (itBlocks.hasNext()) {
            CmsWorkplaceUserInfoBlock block = (CmsWorkplaceUserInfoBlock)itBlocks.next();
            Iterator itEntries = block.getEntries().iterator();
            while (itEntries.hasNext()) {
                CmsWorkplaceUserInfoEntry entry = (CmsWorkplaceUserInfoEntry)itEntries.next();
                Object value = user.getAdditionalInfo(entry.getKey());
                if (value == null) {
                    value = "";
                }
                addInfoList.add(new CmsUserAddInfoBean(entry.getKey(), value.toString(), entry.getClassType()));
            }
        }
        return addInfoList;
    }

    private void setAddInfoMaps() {
        this.m_addInfoEditable = new TreeMap();
        this.m_addInfoReadOnly = new TreeMap();
        Iterator itEntries = this.m_user.getAdditionalInfo().entrySet().iterator();
        while (itEntries.hasNext()) {
            Map.Entry entry = itEntries.next();
            String key = entry.getKey().toString();
            if (entry.getValue() == null || CmsStringUtil.isEmptyOrWhitespaceOnly((String)entry.getValue().toString())) continue;
            if (!entry.getValue().getClass().equals(class$java$lang$String == null ? CmsEditUserAddInfoDialog.class$("java.lang.String") : class$java$lang$String)) {
                key = key + "@" + entry.getValue().getClass().getName();
            }
            if (CmsDataTypeUtil.isParseable(entry.getValue().getClass())) {
                this.m_addInfoEditable.put(key, entry.getValue());
                continue;
            }
            String value = entry.getValue().toString();
            if (value.length() > 75 - key.length()) {
                value = 75 - key.length() > 5 ? value.substring(0, 75 - key.length()) + " ..." : "...";
            }
            this.m_addInfoReadOnly.put(key, value);
        }
    }
}

