/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.Messages;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemActionIconComparator;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListItemComparator;
import org.opencms.workplace.tools.CmsIdentifiableObjectContainer;
import org.opencms.workplace.tools.accounts.CmsDependencyIconAction;
import org.opencms.workplace.tools.accounts.CmsDependencyIconActionType;

public class CmsGroupDependenciesList
extends A_CmsListDialog {
    public static final int ACTION_DELETE = 131;
    public static final int ACTION_TRANSFER = 132;
    public static final String DELETE_ACTION = "delete";
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_TYPE = "ct";
    public static final String LIST_COLUMN_PERMISSIONS = "cp";
    public static final String LIST_ID = "lgd";
    public static final String PARAM_GROUPID = "groupid";
    public static final String PATH_BUTTONS = "tools/accounts/buttons/";
    public static final String TRANSFER_ACTION = "transfer";
    private String m_groupName;
    private String m_paramGroupid;

    public CmsGroupDependenciesList(CmsJspActionElement jsp) {
        this(LIST_ID, jsp);
    }

    public CmsGroupDependenciesList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsGroupDependenciesList(String listId, CmsJspActionElement jsp) {
        super(jsp, listId, org.opencms.workplace.tools.accounts.Messages.get().container("GUI_GROUP_DEPENDENCIES_LIST_NAME_0"), LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, LIST_COLUMN_NAME);
    }

    public void actionDialog() throws JspException, ServletException, IOException {
        switch (this.getAction()) {
            case 131: {
                Iterator it = CmsStringUtil.splitAsList((String)this.getGroupName(), (String)"|", (boolean)true).iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    try {
                        this.getCms().deleteGroup(name);
                    }
                    catch (CmsException e) {
                        throw new CmsRuntimeException(e.getMessageContainer(), (Throwable)e);
                    }
                }
                this.setAction(4);
                this.actionCloseDialog();
                break;
            }
            case 132: {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "initial");
                params.put(PARAM_GROUPID, this.getParamGroupid());
                this.getToolManager().jspForwardPage((CmsWorkplace)this, this.getJsp().getRequestContext().getFolderUri() + "group_transfer.jsp", params);
                break;
            }
            default: {
                super.actionDialog();
            }
        }
    }

    public String defaultActionHtmlContent() {
        if (this.getList().getTotalSize() > 0) {
            return super.defaultActionHtmlContent();
        }
        return "";
    }

    public void executeListMultiActions() {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() {
        this.throwListUnsupportedActionException();
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public String getParamGroupid() {
        return this.m_paramGroupid;
    }

    public void setParamGroupid(String groupId) {
        this.m_paramGroupid = groupId;
    }

    protected String customHtmlEnd() {
        StringBuffer result = new StringBuffer(512);
        result.append(super.customHtmlEnd());
        result.append("<form name='actions' method='post' action='");
        result.append(this.getDialogRealUri());
        result.append("' class='nomargin' onsubmit=\"return submitAction('ok', null, 'actions');\">\n");
        result.append(this.allParamsAsHidden());
        result.append(this.dialogButtonRow(0));
        result.append("<input name='");
        result.append(DELETE_ACTION);
        result.append("' type='button' value='");
        result.append(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_DEPENDENCIES_BUTTON_DELETE_0").key(this.getLocale()));
        result.append("' onclick=\"submitAction('");
        result.append(DELETE_ACTION);
        result.append("', form);\" class='dialogbutton'>\n");
        if (this.getList().getTotalSize() > 0) {
            result.append("<input name='");
            result.append(TRANSFER_ACTION);
            result.append("' type='button' value='");
            result.append(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_DEPENDENCIES_BUTTON_TRANSFER_0").key(this.getLocale()));
            result.append("' onclick=\"submitAction('");
            result.append(TRANSFER_ACTION);
            result.append("', form);\" class='dialogbutton'>\n");
        }
        this.dialogButtonsHtml(result, 1, "");
        result.append(this.dialogButtonRow(1));
        result.append("</form>\n");
        return result.toString();
    }

    protected String customHtmlStart() {
        StringBuffer result = new StringBuffer(512);
        result.append(this.dialogBlockStart(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_GROUP_DEPENDENCIES_NOTICE_0").key(this.getLocale())));
        if (this.getCurrentToolPath().indexOf("/edit/") < 0) {
            result.append(this.key("GUI_GROUP_DEPENDENCIES_SELECTED_GROUPS_0"));
            result.append(":<br>\n");
            List users = CmsStringUtil.splitAsList((String)this.getGroupName(), (String)"|", (boolean)true);
            result.append("<ul>\n");
            Iterator it = users.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                result.append("<li>");
                result.append(name);
                result.append("</li>\n");
            }
            result.append("</ul>\n");
        }
        if (this.getList().getTotalSize() > 0) {
            result.append(this.key("GUI_GROUP_DEPENDENCIES_NOTICE_TEXT_0"));
        } else {
            result.append(this.key("GUI_GROUP_DEPENDENCIES_DELETE_0"));
        }
        result.append(this.dialogBlockEnd());
        return result.toString();
    }

    protected void fillDetails(String detailId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getListItems() throws CmsException {
        CmsIdentifiableObjectContainer ret = new CmsIdentifiableObjectContainer(true, false);
        Iterator itGroups = CmsStringUtil.splitAsList((String)this.getParamGroupid(), (String)"|", (boolean)true).iterator();
        String storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
        try {
            this.getCms().getRequestContext().setSiteRoot("/");
            while (itGroups.hasNext()) {
                CmsGroup group = this.getCms().readGroup(new CmsUUID(itGroups.next().toString()));
                Set resources = this.getCms().getResourcesForPrincipal(group.getId(), null, true);
                Iterator itRes = resources.iterator();
                block4: while (itRes.hasNext()) {
                    CmsResource resource = (CmsResource)itRes.next();
                    CmsListItem item = (CmsListItem)ret.getObject(resource.getResourceId().toString());
                    if (item == null) {
                        item = this.getList().newItem(resource.getResourceId().toString());
                        item.set(LIST_COLUMN_NAME, (Object)resource.getRootPath());
                        item.set(LIST_COLUMN_TYPE, (Object)new Integer(resource.getTypeId()));
                        Iterator itAces = this.getCms().getAccessControlEntries(resource.getRootPath(), false).iterator();
                        while (itAces.hasNext()) {
                            CmsAccessControlEntry ace = (CmsAccessControlEntry)itAces.next();
                            if (!ace.getPrincipal().equals((Object)group.getId())) continue;
                            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)ace.getPermissions().getPermissionString())) break;
                            item.set(LIST_COLUMN_PERMISSIONS, (Object)(group.getName() + ": " + ace.getPermissions().getPermissionString()));
                            break;
                        }
                        ret.addIdentifiableObject(item.getId(), (Object)item);
                        continue;
                    }
                    String oldData = (String)item.get(LIST_COLUMN_PERMISSIONS);
                    Iterator itAces = this.getCms().getAccessControlEntries(resource.getRootPath(), false).iterator();
                    while (itAces.hasNext()) {
                        CmsAccessControlEntry ace = (CmsAccessControlEntry)itAces.next();
                        if (!ace.getPrincipal().equals((Object)group.getId())) continue;
                        if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)ace.getPermissions().getPermissionString())) continue block4;
                        String data = group.getName() + ": " + ace.getPermissions().getPermissionString();
                        if (oldData != null) {
                            data = oldData + ", " + data;
                        }
                        item.set(LIST_COLUMN_PERMISSIONS, (Object)data);
                        continue block4;
                    }
                }
                Iterator itUsers = this.getCms().getUsersOfGroup(group.getName()).iterator();
                while (itUsers.hasNext()) {
                    CmsUser user = (CmsUser)itUsers.next();
                    CmsListItem item = (CmsListItem)ret.getObject(user.getId().toString());
                    if (item != null) continue;
                    item = this.getList().newItem(user.getId().toString());
                    item.set(LIST_COLUMN_NAME, (Object)user.getName());
                    item.set(LIST_COLUMN_PERMISSIONS, (Object)"--");
                    ret.addIdentifiableObject(item.getId(), (Object)item);
                }
                Iterator itChildren = this.getCms().getChildren(group.getName(), false).iterator();
                while (itChildren.hasNext()) {
                    CmsGroup child = (CmsGroup)itChildren.next();
                    CmsListItem item = (CmsListItem)ret.getObject(child.getId().toString());
                    if (item != null) continue;
                    item = this.getList().newItem(child.getId().toString());
                    item.set(LIST_COLUMN_NAME, (Object)child.getName());
                    item.set(LIST_COLUMN_PERMISSIONS, (Object)"--");
                    ret.addIdentifiableObject(item.getId(), (Object)item);
                }
            }
        }
        finally {
            this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
        }
        return ret.elementList();
    }

    protected void initMessages() {
        this.addMessages(org.opencms.workplace.tools.accounts.Messages.get().getBundleName());
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        if (DELETE_ACTION.equals(this.getParamAction())) {
            this.setAction(131);
        } else if (TRANSFER_ACTION.equals(this.getParamAction())) {
            this.setAction(132);
        }
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_GROUP_DEPENDENCIES_LIST_COLS_ICON_0"));
        iconCol.setHelpText(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_GROUP_DEPENDENCIES_LIST_COLS_ICON_HELP_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setListItemComparator((I_CmsListItemComparator)new CmsListItemActionIconComparator());
        this.setIconActions(iconCol);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_GROUP_DEPENDENCIES_LIST_COLS_NAME_0"));
        nameCol.setWidth("80%");
        metadata.addColumn(nameCol);
        CmsListColumnDefinition permissionsCol = new CmsListColumnDefinition(LIST_COLUMN_PERMISSIONS);
        permissionsCol.setName(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_GROUP_DEPENDENCIES_LIST_COLS_PERMISSIONS_0"));
        permissionsCol.setWidth("20%");
        metadata.addColumn(permissionsCol);
        CmsListColumnDefinition typeCol = new CmsListColumnDefinition(LIST_COLUMN_TYPE);
        typeCol.setName(new CmsMessageContainer(null, "type"));
        typeCol.setVisible(false);
        metadata.addColumn(typeCol);
    }

    protected void setIconActions(CmsListColumnDefinition iconCol) {
        CmsDependencyIconAction resourceIconAction = new CmsDependencyIconAction(LIST_ACTION_ICON, CmsDependencyIconActionType.RESOURCE, this.getCms());
        resourceIconAction.setName(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_GROUP_DEPENDENCIES_LIST_ACTION_RES_NAME_0"));
        resourceIconAction.setHelpText(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_GROUP_DEPENDENCIES_LIST_ACTION_RES_HELP_0"));
        resourceIconAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)resourceIconAction);
        CmsDependencyIconAction groupIconAction = new CmsDependencyIconAction(LIST_ACTION_ICON, CmsDependencyIconActionType.GROUP, this.getCms());
        groupIconAction.setName(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_GROUP_DEPENDENCIES_LIST_ACTION_GRP_NAME_0"));
        groupIconAction.setHelpText(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_GROUP_DEPENDENCIES_LIST_ACTION_GRP_HELP_0"));
        groupIconAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)groupIconAction);
        CmsDependencyIconAction userIconAction = new CmsDependencyIconAction(LIST_ACTION_ICON, CmsDependencyIconActionType.USER, this.getCms());
        userIconAction.setName(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_GROUP_DEPENDENCIES_LIST_ACTION_USR_NAME_0"));
        userIconAction.setHelpText(org.opencms.workplace.tools.accounts.Messages.get().container("GUI_GROUP_DEPENDENCIES_LIST_ACTION_USR_HELP_0"));
        userIconAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)userIconAction);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }

    protected void validateParamaters() throws Exception {
        this.m_groupName = "";
        Iterator itGroups = CmsStringUtil.splitAsList((String)this.getParamGroupid(), (String)"|", (boolean)true).iterator();
        while (itGroups.hasNext()) {
            CmsUUID id = new CmsUUID(itGroups.next().toString());
            this.m_groupName = this.m_groupName + this.getCms().readGroup(id).getName();
            if (!itGroups.hasNext()) continue;
            this.m_groupName = this.m_groupName + "|";
        }
    }
}

