/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsGroupOverviewDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "group.ov";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_GROUPID = "groupid";
    protected CmsGroup m_group;
    private String m_paramGroupid;
    private String m_parentGroup;

    public CmsGroupOverviewDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsGroupOverviewDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        this.setCommitErrors(new ArrayList());
    }

    public String getAssignedOu() {
        try {
            return OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.m_group.getOuFqn()).getDisplayName(this.getLocale());
        }
        catch (CmsException e) {
            return null;
        }
    }

    public String getDescription() {
        return this.m_group.getDescription(this.getLocale());
    }

    public String getName() {
        return this.m_group.getSimpleName();
    }

    public String getParamGroupid() {
        return this.m_paramGroupid;
    }

    public String getParentGroup() {
        return this.m_parentGroup;
    }

    public void setAssignedOu(String assignedOu) {
        assignedOu.length();
    }

    public void setDescription(String description) {
        this.m_group.setDescription(description);
    }

    public void setName(String name) {
        name.length();
    }

    public void setParamGroupid(String userId) {
        this.m_paramGroupid = userId;
    }

    public void setParentGroup(String parentGroup) {
        if (CmsStringUtil.isEmpty((String)parentGroup) || parentGroup.equals("null") || parentGroup.equals("none")) {
            parentGroup = null;
        }
        if (parentGroup != null) {
            try {
                this.getCms().readGroup(parentGroup);
            }
            catch (CmsException e) {
                throw new CmsIllegalArgumentException(e.getMessageContainer());
            }
        }
        this.m_parentGroup = parentGroup;
    }

    protected String createDialogHtml(String dialog) {
        int n;
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        int n2 = n = !this.isOverview() ? 2 : 4;
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_GROUP_EDITOR_LABEL_IDENTIFICATION_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, n));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            if (this.isOverview()) {
                result.append(this.dialogBlockStart(this.key("GUI_GROUP_EDITOR_LABEL_FLAGS_BLOCK_0")));
                result.append(this.createWidgetTableStart());
                result.append(this.createDialogRowsHtml(5, 6));
                result.append(this.createWidgetTableEnd());
                result.append(this.dialogBlockEnd());
            }
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String defaultActionHtmlEnd() {
        return "";
    }

    protected void defineWidgets() {
        this.initGroupObject();
        this.setKeyPrefix(KEY_PREFIX);
        if (!this.isOverview()) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "description", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "assignedOu", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "description", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "assignedOu", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "parentGroup", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_group, "enabled", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_group, "projectManager", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_group, "projectCoWorker", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        }
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initGroupObject() {
        try {
            this.m_group = this.getCms().readGroup(new CmsUUID(this.getParamGroupid()));
            this.setParentGroup(this.getCms().readGroup(this.m_group.getParentId()).getName());
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        super.initWorkplaceMembers(jsp);
        this.setOnlineHelpUriCustom("/accounts/groups/overview/");
    }

    protected void validateParamaters() throws Exception {
        this.getCms().readGroup(new CmsUUID(this.getParamGroupid())).getName();
    }

    private boolean isOverview() {
        return this.getCurrentToolPath().endsWith("/groups/edit");
    }
}

