/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.tools.accounts.A_CmsOrgUnitUsersList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsNotOrgUnitUsersList
extends A_CmsOrgUnitUsersList {
    public static final String LIST_ACTION_ADD = "aa";
    public static final String LIST_DEFACTION_ADD = "da";
    public static final String LIST_ID = "lnouu";
    public static final String LIST_MACTION_ADD = "ma";
    protected static Set m_addActionIds = new HashSet();

    public CmsNotOrgUnitUsersList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsNotOrgUnitUsersList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsNotOrgUnitUsersList(CmsJspActionElement jsp, String listId) {
        super(jsp, listId, Messages.get().container("GUI_NOTORGUNITUSERS_LIST_NAME_0"), true);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_ADD)) {
            try {
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    CmsUser user = this.getCms().readUser((String)listItem.get("cl"));
                    List currentUsers = OpenCms.getOrgUnitManager().getUsers(this.getCms(), this.getParamOufqn(), false);
                    boolean inOrgUnit = false;
                    Iterator itCurrentUsers = currentUsers.iterator();
                    while (itCurrentUsers.hasNext()) {
                        CmsUser currentUser = (CmsUser)itCurrentUsers.next();
                        if (!currentUser.getSimpleName().equals(user.getSimpleName())) continue;
                        inOrgUnit = true;
                    }
                    if (inOrgUnit) continue;
                    ArrayList<CmsUser> ouUsers = (ArrayList<CmsUser>)this.getJsp().getRequest().getSession().getAttribute("orgunit_users");
                    if (ouUsers == null) {
                        ouUsers = new ArrayList<CmsUser>();
                    }
                    ouUsers.add(user);
                    this.setOuUsers(ouUsers);
                    ArrayList notOuUsers = (ArrayList)this.getJsp().getRequest().getSession().getAttribute("not_orgunit_users");
                    notOuUsers.remove(user);
                    this.setNotOuUsers(notOuUsers);
                }
            }
            catch (CmsException cmsException) {}
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        if (m_addActionIds.contains(this.getParamListAction())) {
            CmsListItem listItem = this.getSelectedItem();
            try {
                CmsUser user = this.getCms().readUser((String)listItem.get("cl"));
                ArrayList<CmsUser> ouUsers = (ArrayList<CmsUser>)this.getJsp().getRequest().getSession().getAttribute("orgunit_users");
                if (ouUsers == null) {
                    ouUsers = new ArrayList<CmsUser>();
                }
                ouUsers.add(user);
                this.setOuUsers(ouUsers);
                ArrayList notOuUsers = (ArrayList)this.getJsp().getRequest().getSession().getAttribute("not_orgunit_users");
                notOuUsers.remove(user);
                this.setNotOuUsers(notOuUsers);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_ADD_SELECTED_ORGUNITUSER_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    protected List getUsers() throws CmsException {
        ArrayList notOuUsers = (ArrayList)this.getJsp().getRequest().getSession().getAttribute("not_orgunit_users");
        if (notOuUsers == null) {
            List orgUnitsUser = OpenCms.getOrgUnitManager().getUsers(this.getCms(), this.getParamOufqn(), false);
            List notOrgUnitUsers = OpenCms.getRoleManager().getManageableUsers(this.getCms(), "", true);
            notOrgUnitUsers.removeAll(orgUnitsUser);
            this.setNotOuUsers(notOrgUnitUsers);
        } else {
            this.setNotOuUsers(notOuUsers);
        }
        return this.getNotOuUsers();
    }

    protected void setDefaultAction(CmsListColumnDefinition loginCol) {
        CmsListDefaultAction addAction = new CmsListDefaultAction(LIST_DEFACTION_ADD){

            public CmsMessageContainer getHelpText() {
                if (!this.isEnabled()) {
                    return Messages.get().container("GUI_ORGUNITUSERS_LIST_DISABLED_DELETE_HELP_0");
                }
                return super.getHelpText();
            }

            public boolean isEnabled() {
                if (this.getItem() != null) {
                    try {
                        String userName = this.getItem().get("cn").toString();
                        List currentUsers = OpenCms.getOrgUnitManager().getUsers(this.getWp().getCms(), ((A_CmsOrgUnitUsersList)this.getWp()).getParamOufqn(), false);
                        Iterator itCurrentUsers = currentUsers.iterator();
                        while (itCurrentUsers.hasNext()) {
                            CmsUser user = (CmsUser)itCurrentUsers.next();
                            if (user.getSimpleName().equals(userName)) {
                                return false;
                            }
                            if (((A_CmsOrgUnitUsersList)this.getWp()).getCms().getGroupsOfUser(this.getItem().get("cl").toString(), false).size() <= 0) continue;
                            return false;
                        }
                        return true;
                    }
                    catch (CmsException e) {
                        return super.isVisible();
                    }
                }
                return super.isVisible();
            }
        };
        addAction.setName(Messages.get().container("GUI_ORGUNITUSERS_LIST_DEFACTION_ADD_NAME_0"));
        addAction.setHelpText(Messages.get().container("GUI_ORGUNITUSERS_LIST_DEFACTION_ADD_HELP_0"));
        loginCol.addDefaultAction(addAction);
        m_addActionIds.add(addAction.getId());
    }

    protected void setIconAction(CmsListColumnDefinition iconCol) {
        CmsListDirectAction iconAction = new CmsListDirectAction("ai"){

            public String getIconPath() {
                return ((A_CmsOrgUnitUsersList)this.getWp()).getIconPath(this.getItem());
            }
        };
        iconAction.setName(Messages.get().container("GUI_ORGUNITUSERS_LIST_AVAILABLE_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_ORGUNITUSERS_LIST_AVAILABLE_HELP_0"));
        iconAction.setIconPath("tools/accounts/buttons/user.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)iconAction);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction addMultiAction = new CmsListMultiAction(LIST_MACTION_ADD);
        addMultiAction.setName(Messages.get().container("GUI_ORGUNITUSERS_LIST_MACTION_ADD_NAME_0"));
        addMultiAction.setHelpText(Messages.get().container("GUI_ORGUNITUSERS_LIST_MACTION_ADD_HELP_0"));
        addMultiAction.setIconPath("list/multi_add.png");
        metadata.addMultiAction(addMultiAction);
    }

    protected void setStateActionCol(CmsListMetadata metadata) {
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition("cs");
        stateCol.setName(Messages.get().container("GUI_ORGUNITUSERS_LIST_COLS_STATE_0"));
        stateCol.setHelpText(Messages.get().container("GUI_ORGUNITUSERS_LIST_COLS_STATE_HELP_0"));
        stateCol.setWidth("20");
        stateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateCol.setSorteable(false);
        CmsListDirectAction stateAction = new CmsListDirectAction(LIST_ACTION_ADD){

            public CmsMessageContainer getHelpText() {
                if (!this.isEnabled()) {
                    return Messages.get().container("GUI_ORGUNITUSERS_LIST_DISABLED_DELETE_HELP_0");
                }
                return super.getHelpText();
            }

            public boolean isEnabled() {
                if (this.getItem() != null) {
                    try {
                        String userName = this.getItem().get("cn").toString();
                        List currentUsers = OpenCms.getOrgUnitManager().getUsers(this.getWp().getCms(), ((A_CmsOrgUnitUsersList)this.getWp()).getParamOufqn(), false);
                        Iterator itCurrentUsers = currentUsers.iterator();
                        while (itCurrentUsers.hasNext()) {
                            CmsUser user = (CmsUser)itCurrentUsers.next();
                            if (user.getSimpleName().equals(userName)) {
                                return false;
                            }
                            if (((A_CmsOrgUnitUsersList)this.getWp()).getCms().getGroupsOfUser(this.getItem().get("cl").toString(), false).size() <= 0) continue;
                            return false;
                        }
                        return true;
                    }
                    catch (CmsException e) {
                        return super.isVisible();
                    }
                }
                return super.isVisible();
            }
        };
        stateAction.setName(Messages.get().container("GUI_ORGUNITUSERS_LIST_DEFACTION_ADD_NAME_0"));
        stateAction.setHelpText(Messages.get().container("GUI_ORGUNITUSERS_LIST_DEFACTION_ADD_HELP_0"));
        stateAction.setIconPath("list/add.png");
        stateCol.addDirectAction((I_CmsListDirectAction)stateAction);
        metadata.addColumn(stateCol);
        m_addActionIds.add(stateAction.getId());
    }
}

