/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsFileUtil;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.tools.accounts.A_CmsOrgUnitDialog;

public class CmsOrgUnitEditDialog
extends A_CmsOrgUnitDialog {
    public static final String PARAM_SUBOUFQN = "suboufqn";

    public CmsOrgUnitEditDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsOrgUnitEditDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            if (this.isNewOrgUnit()) {
                List resourceNames = CmsFileUtil.removeRedundancies((List)this.m_orgUnitBean.getResources());
                CmsOrganizationalUnit newOrgUnit = OpenCms.getOrgUnitManager().createOrganizationalUnit(this.getCms(), this.m_orgUnitBean.getFqn(), this.m_orgUnitBean.getDescription(), this.m_orgUnitBean.getFlags(), resourceNames.isEmpty() ? null : (String)resourceNames.get(0));
                if (!resourceNames.isEmpty()) {
                    resourceNames.remove(0);
                    Iterator itResourceNames = CmsFileUtil.removeRedundancies((List)resourceNames).iterator();
                    while (itResourceNames.hasNext()) {
                        OpenCms.getOrgUnitManager().addResourceToOrgUnit(this.getCms(), newOrgUnit.getName(), (String)itResourceNames.next());
                    }
                }
            } else {
                CmsOrganizationalUnit orgunit = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.m_orgUnitBean.getFqn());
                orgunit.setDescription(this.m_orgUnitBean.getDescription());
                orgunit.setFlags(this.m_orgUnitBean.getFlags());
                List resourceNamesNew = CmsFileUtil.removeRedundancies((List)this.m_orgUnitBean.getResources());
                List resourcesOld = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.getCms(), orgunit.getName());
                ArrayList<String> resourceNamesOld = new ArrayList<String>();
                Iterator itResourcesOld = resourcesOld.iterator();
                while (itResourcesOld.hasNext()) {
                    CmsResource resourceOld = (CmsResource)itResourcesOld.next();
                    resourceNamesOld.add(this.getCms().getSitePath(resourceOld));
                }
                Iterator itResourceNamesNew = resourceNamesNew.iterator();
                while (itResourceNamesNew.hasNext()) {
                    String resourceNameNew = (String)itResourceNamesNew.next();
                    if (resourceNamesOld.contains(resourceNameNew)) continue;
                    OpenCms.getOrgUnitManager().addResourceToOrgUnit(this.getCms(), orgunit.getName(), resourceNameNew);
                }
                Iterator itResourceNamesOld = resourceNamesOld.iterator();
                while (itResourceNamesOld.hasNext()) {
                    String resourceNameOld = (String)itResourceNamesOld.next();
                    if (resourceNamesNew.contains(resourceNameOld)) continue;
                    OpenCms.getOrgUnitManager().removeResourceFromOrgUnit(this.getCms(), orgunit.getName(), resourceNameOld);
                }
                OpenCms.getOrgUnitManager().writeOrganizationalUnit(this.getCms(), orgunit);
            }
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_ORGUNIT_EDITOR_LABEL_IDENTIFICATION_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 2));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_ORGUNIT_EDITOR_LABEL_FLAGS_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(3, 4));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockStart(this.key("GUI_ORGUNIT_EDITOR_LABEL_CONTENT_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(5, 5));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        super.defineWidgets();
        if (this.isNewOrgUnit()) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "name", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        }
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "description", PAGES[0], (I_CmsWidget)new CmsTextareaWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "parentOuDesc", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        if (this.isNewOrgUnit()) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "nologin", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "webusers", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        } else {
            if (this.m_orgUnitBean.isWebusers()) {
                this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "nologin", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            } else {
                this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "nologin", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
            }
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "webusers", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        }
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "resources", PAGES[0], (I_CmsWidget)new CmsVfsFileWidget(false, this.getCms().getRequestContext().getSiteRoot(), false)));
    }

    protected void validateParamaters() throws Exception {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParamOufqn()));
        if (!this.isNewOrgUnit()) {
            OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn()).getName();
        }
    }
}

