/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.tools.accounts.A_CmsOrgUnitDialog;
import org.opencms.workplace.tools.accounts.CmsOrgUnitBean;

public class CmsOrgUnitOverviewDialog
extends A_CmsOrgUnitDialog {
    public CmsOrgUnitOverviewDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    public void actionCommit() {
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_ORGUNIT_EDITOR_LABEL_IDENTIFICATION_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 2));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String defaultActionHtmlEnd() {
        return "";
    }

    protected void defineWidgets() {
        this.initOrgUnitObject();
        this.setKeyPrefix("orgunit");
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "description", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_orgUnitBean, "parentOu", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
    }

    protected void initOrgUnitObject() {
        try {
            CmsOrganizationalUnit orgunit = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getParamOufqn());
            this.m_orgUnitBean = new CmsOrgUnitBean();
            this.m_orgUnitBean.setDescription(orgunit.getDescription(this.getLocale()));
            this.m_orgUnitBean.setName(orgunit.getName());
            if (!orgunit.getName().equals("")) {
                this.m_orgUnitBean.setParentOu(orgunit.getParentFqn());
            }
            this.m_orgUnitBean.setFqn(orgunit.getName());
            this.m_orgUnitBean.setResources(OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.getCms(), orgunit.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

