/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.tools.accounts.A_CmsOrgUnitUsersList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsOrgUnitUsersList
extends A_CmsOrgUnitUsersList {
    public static final String LIST_ACTION_REMOVE = "ar";
    public static final String LIST_DEFACTION_REMOVE = "dr";
    public static final String LIST_ID = "louu";
    public static final String LIST_MACTION_REMOVE = "mr";
    protected static Set m_removeActionIds = new HashSet();

    public CmsOrgUnitUsersList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsOrgUnitUsersList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsOrgUnitUsersList(CmsJspActionElement jsp, String listId) {
        super(jsp, listId, Messages.get().container("GUI_ORGUNITUSERS_LIST_NAME_0"), true);
    }

    public void actionDialog() throws JspException, ServletException, IOException {
        if (this.getAction() == 4) {
            this.actionCloseDialog();
            return;
        }
        if (this.getAction() == 0) {
            ArrayList ouUsers = (ArrayList)this.getJsp().getRequest().getSession().getAttribute("orgunit_users");
            Iterator itOuUsers = ouUsers.iterator();
            while (itOuUsers.hasNext()) {
                CmsUser user = (CmsUser)itOuUsers.next();
                try {
                    OpenCms.getOrgUnitManager().setUsersOrganizationalUnit(this.getCms(), this.getParamOufqn(), user.getName());
                }
                catch (CmsException e) {
                    throw new JspException((Throwable)e);
                }
            }
            this.actionCloseDialog();
            return;
        }
        super.actionDialog();
        this.refreshList();
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_REMOVE)) {
            Iterator itItems = this.getSelectedItems().iterator();
            while (itItems.hasNext()) {
                CmsListItem listItem = (CmsListItem)itItems.next();
                String userName = (String)listItem.get("cl");
                try {
                    CmsUser user = this.getCms().readUser(userName);
                    ArrayList ouUsers = (ArrayList)this.getJsp().getRequest().getSession().getAttribute("orgunit_users");
                    if (ouUsers == null) {
                        ouUsers = new ArrayList();
                    }
                    ouUsers.remove(user);
                    this.setOuUsers(ouUsers);
                    ArrayList notOuUsers = (ArrayList)this.getJsp().getRequest().getSession().getAttribute("not_orgunit_users");
                    notOuUsers.add(user);
                    this.setNotOuUsers(notOuUsers);
                }
                catch (CmsException e) {}
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        if (m_removeActionIds.contains(this.getParamListAction())) {
            CmsListItem listItem = this.getSelectedItem();
            try {
                CmsUser user = this.getCms().readUser((String)listItem.get("cl"));
                ArrayList ouUsers = (ArrayList)this.getJsp().getRequest().getSession().getAttribute("orgunit_users");
                if (ouUsers == null) {
                    ouUsers = new ArrayList();
                }
                ouUsers.remove(user);
                this.setOuUsers(ouUsers);
                ArrayList notOuUsers = (ArrayList)this.getJsp().getRequest().getSession().getAttribute("not_orgunit_users");
                notOuUsers.add(user);
                this.setNotOuUsers(notOuUsers);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_REMOVE_SELECTED_ORGUNITUSER_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    protected List getUsers() {
        ArrayList ouUsers = (ArrayList)this.getJsp().getRequest().getSession().getAttribute("orgunit_users");
        if (ouUsers == null) {
            ouUsers = new ArrayList();
            this.setOuUsers(ouUsers);
        } else {
            this.setOuUsers(ouUsers);
        }
        return this.getOuUsers();
    }

    protected void setDefaultAction(CmsListColumnDefinition loginCol) {
        CmsListDefaultAction removeAction = new CmsListDefaultAction(LIST_DEFACTION_REMOVE);
        removeAction.setName(Messages.get().container("GUI_ORGUNITUSERS_LIST_DEFACTION_REMOVE_NAME_0"));
        removeAction.setHelpText(Messages.get().container("GUI_ORGUNITUSERS_LIST_DEFACTION_REMOVE_HELP_0"));
        loginCol.addDefaultAction(removeAction);
        m_removeActionIds.add(removeAction.getId());
    }

    protected void setIconAction(CmsListColumnDefinition iconCol) {
        CmsListDirectAction iconAction = new CmsListDirectAction("ai"){

            public String getIconPath() {
                return ((A_CmsOrgUnitUsersList)this.getWp()).getIconPath(this.getItem());
            }
        };
        iconAction.setName(Messages.get().container("GUI_ORGUNITUSERS_LIST_INORGUNIT_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_ORGUNITUSERS_LIST_INORGUNIT_HELP_0"));
        iconAction.setIconPath("tools/accounts/buttons/user.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)iconAction);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction removeMultiAction = new CmsListMultiAction(LIST_MACTION_REMOVE);
        removeMultiAction.setName(Messages.get().container("GUI_ORGUNITUSERS_LIST_MACTION_REMOVE_NAME_0"));
        removeMultiAction.setHelpText(Messages.get().container("GUI_ORGUNITUSERS_LIST_MACTION_REMOVE_HELP_0"));
        removeMultiAction.setIconPath("list/multi_minus.png");
        metadata.addMultiAction(removeMultiAction);
    }

    protected void setStateActionCol(CmsListMetadata metadata) {
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition("cs");
        stateCol.setName(Messages.get().container("GUI_ORGUNITUSERS_LIST_COLS_STATE_0"));
        stateCol.setHelpText(Messages.get().container("GUI_ORGUNITUSERS_LIST_COLS_STATE_HELP_0"));
        stateCol.setWidth("20");
        stateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateCol.setSorteable(false);
        CmsListDirectAction stateAction = new CmsListDirectAction(LIST_ACTION_REMOVE);
        stateAction.setName(Messages.get().container("GUI_ORGUNITUSERS_LIST_DEFACTION_REMOVE_NAME_0"));
        stateAction.setHelpText(Messages.get().container("GUI_ORGUNITUSERS_LIST_DEFACTION_REMOVE_HELP_0"));
        stateAction.setIconPath("list/minus.png");
        stateCol.addDirectAction((I_CmsListDirectAction)stateAction);
        metadata.addColumn(stateCol);
        m_removeActionIds.add(stateAction.getId());
    }
}

