/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.tools.accounts.A_CmsOrgUnitsList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsOrgUnitsSubList
extends A_CmsOrgUnitsList {
    public static final String LIST_ID = "lsous";
    private String m_paramOufqn;

    public CmsOrgUnitsSubList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_SUBORGUNITS_LIST_NAME_0"));
    }

    public CmsOrgUnitsSubList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionDelete() throws Exception {
        OpenCms.getOrgUnitManager().deleteOrganizationalUnit(this.getCms(), this.getParamOufqn());
        this.actionCloseDialog();
    }

    public void actionParent() throws Exception {
        String ouFqn = CmsOrganizationalUnit.getParentFqn((String)this.getParamOufqn());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oufqn", ouFqn);
        params.put("action", "initial");
        String toolPath = this.getCurrentToolPath().substring(0, this.getCurrentToolPath().lastIndexOf("/"));
        this.getToolManager().jspForwardTool((CmsWorkplace)this, toolPath, params);
        this.actionCloseDialog();
    }

    public String defaultActionHtml() {
        if (this.getList() != null && this.getList().getAllContent().isEmpty()) {
            this.refreshList();
        }
        StringBuffer result = new StringBuffer(2048);
        result.append(this.defaultActionHtmlStart());
        result.append(this.customHtmlStart());
        try {
            if (this.hasSubOUs()) {
                result.append(this.defaultActionHtmlContent());
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        result.append(this.customHtmlEnd());
        result.append(this.defaultActionHtmlEnd());
        return result.toString();
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public boolean hasSubOUs() throws CmsException {
        List orgUnits = OpenCms.getOrgUnitManager().getOrganizationalUnits(this.getCms(), this.m_paramOufqn, true);
        if (orgUnits == null) {
            return false;
        }
        return orgUnits.size() >= 1;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List orgUnits = OpenCms.getOrgUnitManager().getOrganizationalUnits(this.getCms(), this.m_paramOufqn, true);
        Iterator itOrgUnits = orgUnits.iterator();
        while (itOrgUnits.hasNext()) {
            CmsOrganizationalUnit childOrgUnit = (CmsOrganizationalUnit)itOrgUnits.next();
            CmsListItem item = this.getList().newItem(childOrgUnit.getName());
            item.set("cn", (Object)("/" + childOrgUnit.getName()));
            item.set("cb", (Object)childOrgUnit.getDescription(this.getLocale()));
            item.set("ca", (Object)OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.ADMINISTRATOR.forOrgUnit(childOrgUnit.getName())));
            item.set("cw", (Object)childOrgUnit.hasFlagWebuser());
            ret.add(item);
        }
        return ret;
    }

    protected void validateParamaters() throws Exception {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParamOufqn()));
        OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.m_paramOufqn).getName();
    }
}

