/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsGroupWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.accounts.A_CmsUserDataImexportDialog;

public class CmsUserDataExportDialog
extends A_CmsUserDataImexportDialog {
    public static final String KEY_PREFIX = "userdata.export";

    public CmsUserDataExportDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsUserDataExportDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() throws IOException, ServletException {
        ArrayList errors = new ArrayList();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oufqn", this.getParamOufqn());
        params.put("closelink", this.getParamCloseLink());
        params.put("style", "new");
        this.getToolManager().jspForwardPage((CmsWorkplace)this, this.getDownloadPath(), params);
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_USERDATA_EXPORT_LABEL_HINT_BLOCK_0")));
            result.append(this.key("GUI_USERDATA_EXPORT_LABEL_HINT_TEXT_0"));
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_USERDATA_EXPORT_LABEL_GROUPS_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 0));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_USERDATA_EXPORT_LABEL_ROLES_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(1, 1));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initExportObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "groups", PAGES[0], (I_CmsWidget)new CmsGroupWidget(null, null, this.getParamOufqn())));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "roles", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getSelectRoles())));
    }

    protected String getDownloadPath() {
        return "/system/workplace/admin/accounts/imexport_user_data/dodownload.jsp";
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initExportObject() {
        try {
            if (CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction())) {
                this.setGroups(new ArrayList());
                this.setRoles(new ArrayList());
            } else {
                this.setGroups((List)((Map)this.getDialogObject()).get("groups"));
                this.setRoles((List)((Map)this.getDialogObject()).get("roles"));
            }
        }
        catch (Exception e) {
            this.setGroups(new ArrayList());
            this.setRoles(new ArrayList());
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        HashMap<String, List> objectsMap = new HashMap<String, List>();
        objectsMap.put("groups", this.getGroups());
        objectsMap.put("roles", this.getRoles());
        this.setDialogObject(objectsMap);
    }
}

