/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDateMacroFormatter;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsUserTransferList
extends A_CmsListDialog {
    public static final String LIST_ACTION_TRANSFER = "at";
    public static final String LIST_COLUMN_EMAIL = "cm";
    public static final String LIST_COLUMN_LASTLOGIN = "cl";
    public static final String LIST_COLUMN_LOGIN = "ci";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_TRANSFER = "ct";
    public static final String LIST_DEFACTION_TRANSFER = "dt";
    public static final String LIST_DETAIL_ADDRESS = "da";
    public static final String LIST_DETAIL_GROUPS = "dg";
    public static final String LIST_ID = "lut";
    public static final String PATH_BUTTONS = "tools/accounts/buttons/";
    private String m_paramUserid;
    private String m_userName;

    public CmsUserTransferList(CmsJspActionElement jsp) {
        this(LIST_ID, jsp);
    }

    public CmsUserTransferList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsUserTransferList(String listId, CmsJspActionElement jsp) {
        super(jsp, listId, Messages.get().container("GUI_USERS_TRANSFER_LIST_NAME_0"), LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() throws IOException, ServletException {
        if (this.getParamListAction().equals(LIST_ACTION_TRANSFER) || this.getParamListAction().equals(LIST_DEFACTION_TRANSFER)) {
            try {
                Iterator it = CmsStringUtil.splitAsList((String)this.getParamUserid(), (String)"|", (boolean)true).iterator();
                while (it.hasNext()) {
                    CmsUUID id = new CmsUUID((String)it.next());
                    this.getCms().deleteUser(id, new CmsUUID(this.getSelectedItem().getId()));
                }
                CmsRequestUtil.forwardRequest((String)this.getParamCloseLink(), (HttpServletRequest)this.getJsp().getRequest(), (HttpServletResponse)this.getJsp().getResponse());
                this.setForwarded(true);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_TRANSFER_USER_1", this.getSelectedItem().get(LIST_COLUMN_NAME)), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public String getParamUserid() {
        return this.m_paramUserid;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public void setParamUserid(String userId) {
        this.m_paramUserid = userId;
    }

    protected String customHtmlStart() {
        StringBuffer result = new StringBuffer(2048);
        result.append(this.dialogBlockStart(Messages.get().container("GUI_USERS_TRANSFER_NOTICE_0").key(this.getLocale())));
        result.append("\n");
        if (this.getCurrentToolPath().indexOf("/edit/") < 0) {
            result.append(this.key("GUI_USER_DEPENDENCIES_SELECTED_USERS_0"));
            result.append(":<br>\n");
            List users = CmsStringUtil.splitAsList((String)this.getUserName(), (String)"|", (boolean)true);
            result.append("<ul>\n");
            Iterator it = users.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                result.append("<li>");
                result.append(name);
                result.append("</li>\n");
            }
            result.append("</ul>\n");
        }
        result.append(this.key("GUI_USERS_TRANSFER_NOTICE_TEXT_0"));
        result.append(this.dialogBlockEnd());
        return result.toString();
    }

    protected void fillDetails(String detailId) {
        List users = this.getList().getAllContent();
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            CmsListItem item = (CmsListItem)itUsers.next();
            String userName = item.get(LIST_COLUMN_LOGIN).toString();
            StringBuffer html = new StringBuffer(512);
            try {
                if (detailId.equals(LIST_DETAIL_ADDRESS)) {
                    CmsUser user = this.getCms().readUser(userName);
                    html.append(user.getAddress());
                    if (user.getCity() != null) {
                        html.append("<br>");
                        if (user.getZipcode() != null) {
                            html.append(user.getZipcode());
                            html.append(" ");
                        }
                        html.append(user.getCity());
                    }
                    if (user.getCountry() != null) {
                        html.append("<br>");
                        html.append(user.getCountry());
                    }
                } else {
                    if (!detailId.equals(LIST_DETAIL_GROUPS)) continue;
                    Iterator itGroups = this.getCms().getGroupsOfUser(userName, false).iterator();
                    while (itGroups.hasNext()) {
                        html.append(((CmsGroup)itGroups.next()).getName());
                        if (itGroups.hasNext()) {
                            html.append("<br>");
                        }
                        html.append("\n");
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List users = this.getUsers();
        HashSet selUsers = new HashSet(CmsStringUtil.splitAsList((String)this.getParamUserid(), (String)"|", (boolean)true));
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            CmsUser user = (CmsUser)itUsers.next();
            if (selUsers.contains(user.getId().toString())) continue;
            CmsListItem item = this.getList().newItem(user.getId().toString());
            this.setUserData(user, item);
            ret.add(item);
        }
        return ret;
    }

    protected List getUsers() throws CmsException {
        return CmsPrincipal.filterCore((List)OpenCms.getOrgUnitManager().getUsers(this.getCms(), "", true));
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition transferCol = new CmsListColumnDefinition(LIST_COLUMN_TRANSFER);
        transferCol.setName(Messages.get().container("GUI_USERS_TRANSFER_LIST_COLS_TRANSFER_0"));
        transferCol.setHelpText(Messages.get().container("GUI_USERS_TRANSFER_LIST_COLS_TRANSFER_HELP_0"));
        transferCol.setWidth("20");
        transferCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        transferCol.setSorteable(false);
        this.setTransferAction(transferCol);
        metadata.addColumn(transferCol);
        CmsListColumnDefinition loginCol = new CmsListColumnDefinition(LIST_COLUMN_LOGIN);
        loginCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_LOGIN_0"));
        loginCol.setWidth("20%");
        CmsListDefaultAction defTransferAction = new CmsListDefaultAction(LIST_DEFACTION_TRANSFER);
        defTransferAction.setName(Messages.get().container("GUI_USERS_TRANSFER_LIST_DEFACTION_TRANSFER_NAME_0"));
        defTransferAction.setHelpText(Messages.get().container("GUI_USERS_TRANSFER_LIST_DEFACTION_TRANSFER_HELP_0"));
        loginCol.addDefaultAction(defTransferAction);
        metadata.addColumn(loginCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_USERNAME_0"));
        nameCol.setWidth("30%");
        metadata.addColumn(nameCol);
        CmsListColumnDefinition emailCol = new CmsListColumnDefinition(LIST_COLUMN_EMAIL);
        emailCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_EMAIL_0"));
        emailCol.setWidth("30%");
        metadata.addColumn(emailCol);
        CmsListColumnDefinition lastLoginCol = new CmsListColumnDefinition(LIST_COLUMN_LASTLOGIN);
        lastLoginCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_LASTLOGIN_0"));
        lastLoginCol.setWidth("20%");
        lastLoginCol.setFormatter(CmsListDateMacroFormatter.getDefaultDateFormatter());
        metadata.addColumn(lastLoginCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails userAddressDetails = new CmsListItemDetails(LIST_DETAIL_ADDRESS);
        userAddressDetails.setAtColumn(LIST_COLUMN_LOGIN);
        userAddressDetails.setVisible(false);
        userAddressDetails.setShowActionName(Messages.get().container("GUI_USERS_DETAIL_SHOW_ADDRESS_NAME_0"));
        userAddressDetails.setShowActionHelpText(Messages.get().container("GUI_USERS_DETAIL_SHOW_ADDRESS_HELP_0"));
        userAddressDetails.setHideActionName(Messages.get().container("GUI_USERS_DETAIL_HIDE_ADDRESS_NAME_0"));
        userAddressDetails.setHideActionHelpText(Messages.get().container("GUI_USERS_DETAIL_HIDE_ADDRESS_HELP_0"));
        userAddressDetails.setName(Messages.get().container("GUI_USERS_DETAIL_ADDRESS_NAME_0"));
        userAddressDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_USERS_DETAIL_ADDRESS_NAME_0")));
        metadata.addItemDetails(userAddressDetails);
        CmsListItemDetails userGroupsDetails = new CmsListItemDetails(LIST_DETAIL_GROUPS);
        userGroupsDetails.setAtColumn(LIST_COLUMN_LOGIN);
        userGroupsDetails.setVisible(false);
        userGroupsDetails.setShowActionName(Messages.get().container("GUI_USERS_DETAIL_SHOW_GROUPS_NAME_0"));
        userGroupsDetails.setShowActionHelpText(Messages.get().container("GUI_USERS_DETAIL_SHOW_GROUPS_HELP_0"));
        userGroupsDetails.setHideActionName(Messages.get().container("GUI_USERS_DETAIL_HIDE_GROUPS_NAME_0"));
        userGroupsDetails.setHideActionHelpText(Messages.get().container("GUI_USERS_DETAIL_HIDE_GROUPS_HELP_0"));
        userGroupsDetails.setName(Messages.get().container("GUI_USERS_DETAIL_GROUPS_NAME_0"));
        userGroupsDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_USERS_DETAIL_GROUPS_NAME_0")));
        metadata.addItemDetails(userGroupsDetails);
        CmsListSearchAction searchAction = new CmsListSearchAction(metadata.getColumnDefinition(LIST_COLUMN_LOGIN));
        searchAction.addColumn(metadata.getColumnDefinition(LIST_COLUMN_NAME));
        metadata.setSearchAction(searchAction);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }

    protected void setTransferAction(CmsListColumnDefinition transferCol) {
        CmsListDirectAction transferAction = new CmsListDirectAction(LIST_ACTION_TRANSFER);
        transferAction.setName(Messages.get().container("GUI_USERS_TRANSFER_LIST_ACTION_TRANSFER_NAME_0"));
        transferAction.setHelpText(Messages.get().container("GUI_USERS_TRANSFER_LIST_ACTION_TRANSFER_HELP_0"));
        transferAction.setIconPath("tools/accounts/buttons/user.png");
        transferCol.addDirectAction((I_CmsListDirectAction)transferAction);
    }

    protected void setUserData(CmsUser user, CmsListItem item) {
        item.set(LIST_COLUMN_LOGIN, (Object)user.getName());
        item.set(LIST_COLUMN_NAME, (Object)user.getFullName());
        item.set(LIST_COLUMN_EMAIL, (Object)user.getEmail());
        item.set(LIST_COLUMN_LASTLOGIN, (Object)new Date(user.getLastlogin()));
    }

    protected void validateParamaters() throws Exception {
        this.m_userName = "";
        Iterator itUsers = CmsStringUtil.splitAsList((String)this.getParamUserid(), (String)"|", (boolean)true).iterator();
        while (itUsers.hasNext()) {
            CmsUUID id = new CmsUUID(itUsers.next().toString());
            this.m_userName = this.m_userName + this.getCms().readUser(id).getName();
            if (!itUsers.hasNext()) continue;
            this.m_userName = this.m_userName + "|";
        }
    }
}

