/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.accounts.A_CmsUsersList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsUsersAllOrgUnitsList
extends A_CmsUsersList {
    public static final String LIST_ACTION_OVERVIEW = "ao";
    public static final String LIST_COLUMN_ORGUNIT = "co";
    public static final String LIST_DETAIL_ORGUNIT_DESC = "dd";
    public static final String LIST_ID = "lsuaou";

    public CmsUsersAllOrgUnitsList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_USERS_LIST_NAME_0"));
    }

    public CmsUsersAllOrgUnitsList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListSingleActions() throws IOException, ServletException {
        String userId = this.getSelectedItem().getId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", userId);
        params.put("oufqn", this.getSelectedItem().get(LIST_COLUMN_ORGUNIT).toString().substring(1));
        params.put("action", "initial");
        if (this.getParamListAction().equals(LIST_ACTION_OVERVIEW)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/accounts/orgunit/users/edit", params);
        } else if (this.getParamListAction().equals("de")) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/accounts/orgunit/users/edit", params);
        } else {
            super.executeListSingleActions();
        }
        this.listSave();
    }

    protected void fillDetails(String detailId) {
        super.fillDetails(detailId);
        List users = this.getList().getAllContent();
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            CmsListItem item = (CmsListItem)itUsers.next();
            String userName = item.get("ci").toString();
            StringBuffer html = new StringBuffer(512);
            try {
                if (!detailId.equals(LIST_DETAIL_ORGUNIT_DESC)) continue;
                CmsUser user = this.readUser(userName);
                html.append(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), user.getOuFqn()).getDescription(this.getLocale()));
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected String getGroupIcon() {
        return null;
    }

    protected List getUsers() throws CmsException {
        return CmsPrincipal.filterCore((List)OpenCms.getRoleManager().getManageableUsers(this.getCms(), "", true));
    }

    protected CmsUser readUser(String name) throws CmsException {
        return this.getCms().readUser(name);
    }

    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        metadata.getColumnDefinition("cg").setVisible(false);
        metadata.getColumnDefinition("cr").setVisible(false);
        metadata.getColumnDefinition("ca").setVisible(false);
        metadata.getColumnDefinition("cd").setVisible(false);
        metadata.getColumnDefinition("cl").setVisible(false);
        CmsListColumnDefinition orgUnitCol = new CmsListColumnDefinition(LIST_COLUMN_ORGUNIT);
        orgUnitCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_ORGUNIT_0"));
        orgUnitCol.setWidth("30%");
        metadata.addColumn(orgUnitCol, metadata.getColumnDefinitions().indexOf(metadata.getColumnDefinition("cn")));
    }

    protected void setDeleteAction(CmsListColumnDefinition deleteCol) {
    }

    protected void setEditAction(CmsListColumnDefinition editCol) {
        CmsListDirectAction editAction = new CmsListDirectAction(LIST_ACTION_OVERVIEW);
        editAction.setName(Messages.get().container("GUI_USERS_LIST_DEFACTION_EDIT_NAME_0"));
        editAction.setHelpText(Messages.get().container("GUI_USERS_LIST_DEFACTION_EDIT_HELP_0"));
        editAction.setIconPath("tools/accounts/buttons/user.png");
        editCol.addDirectAction((I_CmsListDirectAction)editAction);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        super.setIndependentActions(metadata);
        CmsListItemDetails orgUnitDescDetails = new CmsListItemDetails(LIST_DETAIL_ORGUNIT_DESC);
        orgUnitDescDetails.setAtColumn("cdn");
        orgUnitDescDetails.setVisible(false);
        orgUnitDescDetails.setShowActionName(Messages.get().container("GUI_USERS_DETAIL_SHOW_ORGUNIT_DESC_NAME_0"));
        orgUnitDescDetails.setShowActionHelpText(Messages.get().container("GUI_USERS_DETAIL_SHOW_ORGUNIT_DESC_HELP_0"));
        orgUnitDescDetails.setHideActionName(Messages.get().container("GUI_USERS_DETAIL_HIDE_ORGUNIT_DESC_NAME_0"));
        orgUnitDescDetails.setHideActionHelpText(Messages.get().container("GUI_USERS_DETAIL_HIDE_ORGUNIT_DESC_HELP_0"));
        orgUnitDescDetails.setName(Messages.get().container("GUI_USERS_DETAIL_ORGUNIT_DESC_NAME_0"));
        orgUnitDescDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_USERS_DETAIL_ORGUNIT_DESC_NAME_0")));
        metadata.addItemDetails(orgUnitDescDetails);
        metadata.getSearchAction().addColumn(metadata.getColumnDefinition("cm"));
        metadata.getSearchAction().addColumn(metadata.getColumnDefinition(LIST_COLUMN_ORGUNIT));
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }

    protected void setUserData(CmsUser user, CmsListItem item) {
        super.setUserData(user, item);
        item.set(LIST_COLUMN_ORGUNIT, (Object)("/" + user.getOuFqn()));
    }

    protected void validateParamaters() throws Exception {
    }
}

