/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.db.CmsUserExportSettings;
import org.opencms.file.CmsUser;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.tools.accounts.A_CmsUserDataImexportDialog;
import org.opencms.workplace.tools.accounts.CmsUserDataExportDialog;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsUsersCsvDownloadDialog
extends A_CmsUserDataImexportDialog {
    static /* synthetic */ Class class$org$opencms$file$CmsUser;

    public CmsUsersCsvDownloadDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsUsersCsvDownloadDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
    }

    public String dialogButtonsCustom() {
        return this.dialogButtons(new int[]{2}, new String[1]);
    }

    public String generateCsv() {
        Map objects = this.getData();
        List groups = (List)objects.get("groups");
        List roles = (List)objects.get("roles");
        Map exportUsers = new HashMap();
        try {
            if (!(groups != null && groups.size() >= 1 || roles != null && roles.size() >= 1)) {
                exportUsers = this.getExportAllUsers(exportUsers);
            } else {
                exportUsers = this.getExportUsersFromGroups(groups, exportUsers);
                exportUsers = this.getExportUsersFromRoles(roles, exportUsers);
            }
        }
        catch (CmsException e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_GET_EXPORT_USERS_0"), (Throwable)e);
        }
        StringBuffer buffer = new StringBuffer();
        CmsUserExportSettings settings = OpenCms.getImportExportManager().getUserExportSettings();
        String separator = CmsStringUtil.substitute((String)settings.getSeparator(), (String)"\\t", (String)"\t");
        List values = settings.getColumns();
        buffer.append("name");
        Iterator itValues = values.iterator();
        while (itValues.hasNext()) {
            buffer.append(separator);
            buffer.append(itValues.next());
        }
        buffer.append("\n");
        Object[] users = exportUsers.values().toArray();
        for (int i = 0; i < users.length; ++i) {
            CmsUser exportUser = (CmsUser)users[i];
            if (!exportUser.getOuFqn().equals(this.getParamOufqn()) || !this.isExportable(exportUser)) continue;
            buffer.append(exportUser.getSimpleName());
            itValues = values.iterator();
            while (itValues.hasNext()) {
                String curOutput;
                buffer.append(separator);
                String curValue = (String)itValues.next();
                try {
                    Method method = (class$org$opencms$file$CmsUser == null ? CmsUsersCsvDownloadDialog.class$("org.opencms.file.CmsUser") : class$org$opencms$file$CmsUser).getMethod("get" + curValue.substring(0, 1).toUpperCase() + curValue.substring(1), null);
                    curOutput = (String)method.invoke((Object)exportUser, null);
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)curOutput) || curOutput.equals("null")) {
                        curOutput = (String)exportUser.getAdditionalInfo(curValue);
                    }
                    if (curValue.equals("password")) {
                        curOutput = OpenCms.getPasswordHandler().getDigestType() + "_" + curOutput;
                    }
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)curOutput) || curOutput.equals("null")) continue;
                    buffer.append(curOutput);
                }
                catch (NoSuchMethodException e) {
                    curOutput = (String)exportUser.getAdditionalInfo(curValue);
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)curOutput)) continue;
                    buffer.append(curOutput);
                }
                catch (IllegalAccessException e) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_ILLEGAL_ACCESS_0"), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_INVOCATION_TARGET_0"), (Throwable)e);
                }
            }
            buffer.append("\n");
        }
        HttpServletResponse res = CmsFlexController.getController((ServletRequest)this.getJsp().getRequest()).getTopResponse();
        res.setContentType("text/comma-separated-values");
        String filename = "export_users" + new Random().nextInt(1024) + ".csv";
        res.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        res.setContentLength(buffer.length());
        return buffer.toString();
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append("<script type=\"text/javascript\">\n");
            result.append("function download(){\n");
            result.append("\twindow.open(\"").append(this.getJsp().link(CmsRequestUtil.appendParameter((String)this.getDownloadPath(), (String)"oufqn", (String)this.getParamOufqn()))).append("\", \"usecvs\");\n");
            result.append("}\n");
            result.append("window.setTimeout(\"download()\",500);\n");
            result.append("</script>\n");
            result.append(this.dialogBlockStart(this.key("GUI_USERDATA_EXPORT_LABEL_HINT_BLOCK_0")));
            result.append(this.key("GUI_USERDATA_DOWNLOAD_LABEL_HINT_TEXT_0"));
            result.append(" <a href='javascript:download()'>");
            result.append(this.key("GUI_USERDATA_DOWNLOAD_LABEL_HINT_CLICK_0"));
            result.append("</a>.");
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
    }

    protected Map getData() {
        return (Map)((Map)this.getSettings().getDialogObject()).get(CmsUserDataExportDialog.class.getName());
    }

    protected String getDownloadPath() {
        return "/system/workplace/admin/accounts/imexport_user_data/csvdownload.jsp";
    }

    protected Map getExportAllUsers(Map exportUsers) throws CmsException {
        List users = OpenCms.getOrgUnitManager().getUsers(this.getCms(), this.getParamOufqn(), false);
        if (users != null && users.size() > 0) {
            Iterator itUsers = users.iterator();
            while (itUsers.hasNext()) {
                CmsUser user = (CmsUser)itUsers.next();
                if (exportUsers.containsKey(user.getId())) continue;
                exportUsers.put(user.getId(), user);
            }
        }
        return exportUsers;
    }

    protected Map getExportUsersFromGroups(List groups, Map exportUsers) throws CmsException {
        if (groups != null && groups.size() > 0) {
            Iterator itGroups = groups.iterator();
            while (itGroups.hasNext()) {
                List groupUsers = this.getCms().getUsersOfGroup((String)itGroups.next());
                Iterator itGroupUsers = groupUsers.iterator();
                while (itGroupUsers.hasNext()) {
                    CmsUser groupUser = (CmsUser)itGroupUsers.next();
                    if (exportUsers.containsKey(groupUser.getId())) continue;
                    exportUsers.put(groupUser.getId(), groupUser);
                }
            }
        }
        return exportUsers;
    }

    protected Map getExportUsersFromRoles(List roles, Map exportUsers) throws CmsException {
        if (roles != null && roles.size() > 0) {
            Iterator itRoles = roles.iterator();
            while (itRoles.hasNext()) {
                List roleUsers = OpenCms.getRoleManager().getUsersOfRole(this.getCms(), CmsRole.valueOfGroupName((String)((String)itRoles.next())).forOrgUnit(this.getParamOufqn()), true, false);
                Iterator itRoleUsers = roleUsers.iterator();
                while (itRoleUsers.hasNext()) {
                    CmsUser roleUser = (CmsUser)itRoleUsers.next();
                    if (exportUsers.get(roleUser.getId()) != null) continue;
                    exportUsers.put(roleUser.getId(), roleUser);
                }
            }
        }
        return exportUsers;
    }

    protected boolean isExportable(CmsUser exportUser) {
        return exportUser.getFlags() < 65536;
    }

    protected void validateParamaters() throws Exception {
        if (this.getParamOufqn() == null) {
            this.setParamOufqn("");
        }
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParamOufqn()));
    }
}

