/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.editors.editarea;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.CmsSimpleEditor;

public class CmsEditArea
extends CmsSimpleEditor {
    public static final String HIGHLIGHT_TYPE_CSS = "css";
    public static final String HIGHLIGHT_TYPE_HTML = "html";
    public static final String HIGHLIGHT_TYPE_JAVASCRIPT = "js";
    public static final String HIGHLIGHT_TYPE_JSP = "jsp";
    public static final String HIGHLIGHT_TYPE_XML = "xml";
    protected static final String[] HIGHLIGHT_TYPES = new String[]{"css", "html", "js", "jsp", "xml"};
    protected static final List HIGHLIGHT_TYPES_LIST = Arrays.asList(HIGHLIGHT_TYPES);
    protected static final String SUBPATH_EDITAREA = "editors/editarea/";
    protected static final String VFS_PATH_EDITOR = "/system/workplace/resources/editors/editarea/";
    protected static final String VFS_PATH_EDITOR_DIST = "/system/workplace/resources/editors/editarea/dist/";

    public CmsEditArea(CmsJspActionElement jsp) {
        super(jsp);
    }

    public String getEditorLanguage() {
        String testLocale = this.getLocale().toString();
        if (this.getCms().existsResource("/system/workplace/resources/editors/editarea/dist/langs/" + testLocale + ".js")) {
            return testLocale;
        }
        return Locale.ENGLISH.toString();
    }

    public String getEditorResourceUri() {
        return CmsEditArea.getSkinUri() + SUBPATH_EDITAREA;
    }

    public String getStartHighlight() {
        CmsResource resource = null;
        try {
            resource = this.getCms().readResource(this.getParamResource());
        }
        catch (CmsException e) {
            // empty catch block
        }
        if (resource != null) {
            int typeIndex;
            String suffix;
            int type = resource.getTypeId();
            if (type == CmsResourceTypeJsp.getStaticTypeId()) {
                return HIGHLIGHT_TYPE_JSP;
            }
            if (CmsResourceTypeXmlContent.isXmlContent((CmsResource)resource) || type == CmsResourceTypeXmlPage.getStaticTypeId()) {
                return HIGHLIGHT_TYPE_XML;
            }
            int dotIndex = this.getParamResource().lastIndexOf(46);
            if (dotIndex != -1 && CmsStringUtil.isNotEmpty((String)(suffix = this.getParamResource().substring(dotIndex + 1))) && (typeIndex = HIGHLIGHT_TYPES_LIST.indexOf(suffix.toLowerCase())) != -1) {
                return (String)HIGHLIGHT_TYPES_LIST.get(typeIndex);
            }
        }
        return HIGHLIGHT_TYPE_HTML;
    }
}

