/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.link;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.link.CmsInternalLinkValidationList;
import org.opencms.workplace.tools.link.Messages;

public class CmsInternalLinkValidationDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "internallinks";
    public static final String[] PAGES = new String[]{"page1"};
    private List m_resources;

    public CmsInternalLinkValidationDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsInternalLinkValidationDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.setDialogObject(this.m_resources);
            Map objects = (Map)this.getSettings().getListObject();
            if (objects != null) {
                objects.remove(CmsInternalLinkValidationList.class.getName());
            }
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/linkvalidation/internallinks/list", null);
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    public List getResources() {
        if (this.m_resources == null || this.m_resources.isEmpty()) {
            this.m_resources = new ArrayList();
            this.m_resources.add("/");
        }
        return this.m_resources;
    }

    public void setResources(List value) {
        if (value == null) {
            this.m_resources = new ArrayList();
            return;
        }
        this.m_resources = CmsFileUtil.removeRedundancies((List)value);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_INTERNALLINK_EDITOR_LABEL_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 0));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initSessionObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "resources", "/", PAGES[0], (I_CmsWidget)new CmsVfsFileWidget(false, null), 1, 200));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initSessionObject() {
        try {
            if (!CmsStringUtil.isEmpty((String)this.getParamAction()) && !"initial".equals(this.getParamAction())) {
                this.m_resources = (List)this.getDialogObject();
                this.m_resources.size();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.m_resources == null) {
            this.m_resources = new ArrayList();
            try {
                Iterator it = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(this.getCms(), this.getCms().getRequestContext().getOuFqn()).iterator();
                while (it.hasNext()) {
                    CmsResource res = (CmsResource)it.next();
                    this.m_resources.add(this.getCms().getSitePath(res));
                }
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_resources);
    }
}

