/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.loader.CmsImageLoader;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.CmsShell;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.I_CmsShellCommands;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleManager;
import org.opencms.report.CmsShellReport;
import org.opencms.report.I_CmsReport;
import org.opencms.setup.CmsSetupComponent;
import org.opencms.setup.CmsSetupWorkplaceImportThread;
import org.opencms.setup.Messages;
import org.opencms.setup.comptest.CmsSetupTestResult;
import org.opencms.setup.comptest.CmsSetupTestSimapi;
import org.opencms.setup.xml.CmsSetupXmlHelper;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsPropertyUtils;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.tools.CmsIdentifiableObjectContainer;
import org.opencms.xml.CmsXmlException;

public class CmsSetupBean
implements I_CmsShellCommands {
    public static final String AS400_PROVIDER = "as400";
    public static final String COMPONENTS_PROPERTIES = "components.properties";
    public static final String DB2_PROVIDER = "db2";
    public static final String FOLDER_BACKUP = "backup" + File.separatorChar;
    public static final String FOLDER_DATABASE = "database" + File.separatorChar;
    public static final String FOLDER_LIB = "lib" + File.separatorChar;
    public static final String FOLDER_SETUP = "setup" + File.separatorChar;
    public static final String GENERIC_PROVIDER = "generic";
    public static final String HSQLDB_PROVIDER = "hsqldb";
    public static final String HTML_MESSAGE_FILE = "org/opencms/setup/htmlmsg.properties";
    public static final String MAXDB_PROVIDER = "maxdb";
    public static final String MSSQL_PROVIDER = "mssql";
    public static final String MYSQL_PROVIDER = "mysql";
    public static final String ORACLE_PROVIDER = "oracle";
    public static final String POSTGRESQL_PROVIDER = "postgresql";
    protected static final int DEFAULT_POSITION = 9999;
    protected static final String PROPKEY_CHECKED = ".checked";
    protected static final String PROPKEY_COMPONENT = "component.";
    protected static final String PROPKEY_COMPONENTS = "components";
    protected static final String PROPKEY_DEPENDENCIES = ".dependencies";
    protected static final String PROPKEY_DESCRIPTION = ".description";
    protected static final String PROPKEY_MODULES = ".modules";
    protected static final String PROPKEY_NAME = ".name";
    protected static final String PROPKEY_POSITION = ".position";
    static final String[] REQUIRED_DB_SETUP_FILES = new String[]{"step_4_database_setup.jsp", "database.properties", "create_db.sql", "create_tables.sql", "drop_db.sql", "drop_tables.sql"};
    private static final Log LOG = CmsLog.getLog((Object)CmsSetupBean.class);
    private static Properties m_htmlProps;
    protected Map m_availableModules;
    protected CmsObject m_cms;
    protected List m_installModules;
    protected String m_logFile = CmsSystemInfo.FOLDER_WEBINF + CmsLog.FOLDER_LOGS + "setup.log";
    protected String m_logsFolder = CmsSystemInfo.FOLDER_WEBINF + CmsLog.FOLDER_LOGS;
    protected Map m_moduleDependencies;
    protected Map m_moduleFilenames;
    protected String m_modulesFolder = CmsSystemInfo.FOLDER_WEBINF + CmsSystemInfo.FOLDER_PACKAGES + CmsSystemInfo.FOLDER_MODULES;
    protected int m_newLoggingOffset;
    protected int m_oldLoggingOffset;
    protected String m_webAppRfsPath;
    private CmsIdentifiableObjectContainer m_components;
    private String m_configRfsPath;
    private String m_databaseKey;
    private List m_databaseKeys;
    private Map m_databaseProperties;
    private String m_dbCreatePwd;
    private String m_defaultWebApplication;
    private List m_errors;
    private ExtendedProperties m_extProperties;
    private String m_provider;
    private Map m_replacer;
    private ServletConfig m_servletConfig;
    private String m_servletMapping;
    private List m_sortedDatabaseKeys;
    private CmsSetupWorkplaceImportThread m_workplaceImportThread;
    private CmsSetupXmlHelper m_xmlHelper;

    public CmsSetupBean() {
        this.initHtmlParts();
    }

    public void backupConfiguration(String filename, String originalFilename) {
        File backupFolder = new File(this.m_configRfsPath + FOLDER_BACKUP);
        if (!backupFolder.exists()) {
            backupFolder.mkdirs();
        }
        originalFilename = FOLDER_BACKUP + originalFilename;
        File file = new File(this.m_configRfsPath + originalFilename);
        if (file.exists()) {
            this.copyFile(originalFilename, filename);
        } else {
            this.copyFile(filename, originalFilename);
        }
    }

    public Map buildDepsForAllComponents() {
        CmsSetupComponent component;
        HashMap ret = new HashMap();
        Iterator itComponents = this.m_components.elementList().iterator();
        while (itComponents.hasNext()) {
            component = (CmsSetupComponent)itComponents.next();
            Iterator itDeps = component.getDependencies().iterator();
            while (itDeps.hasNext()) {
                String dependency = (String)itDeps.next();
                ArrayList<String> componentDependencies = (ArrayList<String>)ret.get(dependency);
                if (componentDependencies == null) {
                    componentDependencies = new ArrayList<String>();
                    ret.put(dependency, componentDependencies);
                }
                componentDependencies.add(component.getId());
            }
        }
        itComponents = this.m_components.elementList().iterator();
        while (itComponents.hasNext()) {
            component = (CmsSetupComponent)itComponents.next();
            if (ret.get(component.getId()) != null) continue;
            ret.put(component.getId(), new ArrayList());
        }
        return ret;
    }

    public void checkEthernetAddress() {
        if (CmsStringUtil.isEmpty((String)this.getEthernetAddress())) {
            this.setEthernetAddress(CmsUUID.getDummyEthernetAddress());
        }
    }

    public void copyFile(String source, String target) {
        try {
            CmsFileUtil.copy((String)(this.m_configRfsPath + source), (String)(this.m_configRfsPath + target));
        }
        catch (IOException e) {
            this.m_errors.add("Could not copy " + source + " to " + target + " \n");
            this.m_errors.add(e.toString() + "\n");
        }
    }

    public String displayError(String pathPrefix) {
        if (pathPrefix == null) {
            pathPrefix = "";
        }
        StringBuffer html = new StringBuffer(512);
        html.append("<table border='0' cellpadding='5' cellspacing='0' style='width: 100%; height: 100%;'>");
        html.append("\t<tr>");
        html.append("\t\t<td style='vertical-align: middle; height: 100%;'>");
        html.append(this.getHtmlPart("C_BLOCK_START", "Error"));
        html.append("\t\t\t<table border='0' cellpadding='0' cellspacing='0' style='width: 100%;'>");
        html.append("\t\t\t\t<tr>");
        html.append("\t\t\t\t\t<td><img src='").append(pathPrefix).append("resources/error.png' border='0'></td>");
        html.append("\t\t\t\t\t<td>&nbsp;&nbsp;</td>");
        html.append("\t\t\t\t\t<td style='width: 100%;'>");
        html.append("\t\t\t\t\t\tThe Alkacon OpenCms setup wizard has not been started correctly!<br>");
        html.append("\t\t\t\t\t\tPlease click <a href='").append(pathPrefix);
        html.append("index.jsp'>here</a> to restart the wizard.");
        html.append("\t\t\t\t\t</td>");
        html.append("\t\t\t\t</tr>");
        html.append("\t\t\t</table>");
        html.append(this.getHtmlPart("C_BLOCK_END"));
        html.append("\t\t</td>");
        html.append("\t</tr>");
        html.append("</table>");
        return html.toString();
    }

    public String displayErrors(String pathPrefix) {
        if (pathPrefix == null) {
            pathPrefix = "";
        }
        StringBuffer html = new StringBuffer(512);
        html.append("<table border='0' cellpadding='5' cellspacing='0' style='width: 100%; height: 100%;'>");
        html.append("\t<tr>");
        html.append("\t\t<td style='vertical-align: middle; height: 100%;'>");
        html.append(this.getHtmlPart("C_BLOCK_START", "Error"));
        html.append("\t\t\t<table border='0' cellpadding='0' cellspacing='0' style='width: 100%;'>");
        html.append("\t\t\t\t<tr>");
        html.append("\t\t\t\t\t<td><img src='").append(pathPrefix).append("resources/error.png' border='0'></td>");
        html.append("\t\t\t\t\t<td>&nbsp;&nbsp;</td>");
        html.append("\t\t\t\t\t<td style='width: 100%;'>");
        Iterator iter = this.getErrors().iterator();
        while (iter.hasNext()) {
            String msg = (String)iter.next();
            html.append("\t\t\t\t\t\t");
            html.append(msg);
            html.append("<br/>");
        }
        html.append("\t\t\t\t\t</td>");
        html.append("\t\t\t\t</tr>");
        html.append("\t\t\t</table>");
        html.append(this.getHtmlPart("C_BLOCK_END"));
        html.append("\t\t</td>");
        html.append("\t</tr>");
        html.append("</table>");
        return html.toString();
    }

    public Map getAvailableModules() {
        if (this.m_availableModules == null || this.m_availableModules.isEmpty()) {
            this.m_availableModules = new HashMap();
            this.m_moduleDependencies = new HashMap();
            this.m_moduleFilenames = new HashMap();
            this.m_components = new CmsIdentifiableObjectContainer(true, true);
            try {
                this.addComponentsFromPath(this.m_webAppRfsPath + FOLDER_SETUP);
                Map modules = CmsModuleManager.getAllModulesFromPath((String)this.getModuleFolder());
                Iterator itMods = modules.entrySet().iterator();
                while (itMods.hasNext()) {
                    Map.Entry entry = itMods.next();
                    CmsModule module = (CmsModule)entry.getKey();
                    this.m_availableModules.put(module.getName(), module);
                    this.m_moduleFilenames.put(module.getName(), entry.getValue());
                    this.addComponentsFromPath(this.getModuleFolder() + entry.getValue());
                }
            }
            catch (CmsConfigurationException e) {
                throw new CmsRuntimeException(e.getMessageContainer());
            }
            this.initializeComponents(new HashSet(this.m_availableModules.keySet()));
        }
        return this.m_availableModules;
    }

    public String getConfigRfsPath() {
        return this.m_configRfsPath;
    }

    public String getDatabase() {
        if (this.m_databaseKey == null) {
            this.m_databaseKey = this.getExtProperty("db.name");
        }
        if (CmsStringUtil.isEmpty((String)this.m_databaseKey)) {
            this.m_databaseKey = (String)this.getSortedDatabases().get(0);
        }
        return this.m_databaseKey;
    }

    public String getDatabaseConfigPage(String key) {
        String configUri = FOLDER_DATABASE + key + "/" + "step_4_database_setup.jsp";
        return CmsStringUtil.substitute((String)configUri, (String)File.separator, (String)"/");
    }

    public List getDatabaseLibs(String databaseKey) {
        return CmsStringUtil.splitAsList((String)((String)((Map)this.getDatabaseProperties().get(databaseKey)).get(databaseKey + ".libs")), (char)',', (boolean)true);
    }

    public String getDatabaseName(String databaseKey) {
        return (String)((Map)this.getDatabaseProperties().get(databaseKey)).get(databaseKey + PROPKEY_NAME);
    }

    public Map getDatabaseProperties() {
        if (this.m_databaseProperties != null) {
            return this.m_databaseProperties;
        }
        this.readDatabaseConfig();
        return this.m_databaseProperties;
    }

    public List getDatabases() {
        File databaseSetupFolder = null;
        File[] childResources = null;
        File childResource = null;
        File setupFile = null;
        boolean hasMissingSetupFiles = false;
        if (this.m_databaseKeys != null) {
            return this.m_databaseKeys;
        }
        try {
            this.m_databaseKeys = new ArrayList();
            databaseSetupFolder = new File(this.m_webAppRfsPath + FOLDER_SETUP + FOLDER_DATABASE);
            if (databaseSetupFolder.exists() && (childResources = databaseSetupFolder.listFiles()) != null) {
                for (int i = 0; i < childResources.length; ++i) {
                    childResource = childResources[i];
                    hasMissingSetupFiles = false;
                    if (!childResource.exists() || !childResource.isDirectory() || !childResource.canRead()) continue;
                    for (int j = 0; j < REQUIRED_DB_SETUP_FILES.length; ++j) {
                        setupFile = new File(childResource.getPath() + File.separatorChar + REQUIRED_DB_SETUP_FILES[j]);
                        if (setupFile.exists() && setupFile.isFile() && setupFile.canRead()) continue;
                        hasMissingSetupFiles = true;
                        System.err.println("[" + this.getClass().getName() + "] missing or unreadable database setup file: " + setupFile.getPath());
                        break;
                    }
                    if (hasMissingSetupFiles) continue;
                    this.m_databaseKeys.add(childResource.getName().trim());
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace(System.err);
        }
        return this.m_databaseKeys;
    }

    public String getDb() {
        return this.getDbProperty(this.m_databaseKey + ".dbname");
    }

    public String getDbConStrParams() {
        return this.getDbProperty(this.m_databaseKey + ".constr.params");
    }

    public String getDbCreateConStr() {
        return this.getDbProperty(this.m_databaseKey + ".constr");
    }

    public String getDbCreatePwd() {
        return this.m_dbCreatePwd != null ? this.m_dbCreatePwd : "";
    }

    public String getDbCreateUser() {
        return this.getDbProperty(this.m_databaseKey + ".user");
    }

    public String getDbDriver() {
        return this.getDbProperty(this.m_databaseKey + ".driver");
    }

    public String getDbProperty(String key) {
        String databaseKey = key.substring(0, key.indexOf(46));
        Map databaseProperties = (Map)this.getDatabaseProperties().get(databaseKey);
        Object value = databaseProperties.get(key);
        return value != null ? (String)value : "";
    }

    public String getDbTestQuery() {
        return this.getDbProperty(this.m_databaseKey + ".testQuery");
    }

    public String getDbWorkConStr() {
        if (this.m_provider.equals(POSTGRESQL_PROVIDER)) {
            return this.getDbProperty(this.m_databaseKey + ".constr.newDb");
        }
        return this.getExtProperty("db.pool." + this.getPool() + ".jdbcUrl");
    }

    public String getDbWorkPwd() {
        return this.getExtProperty("db.pool." + this.getPool() + ".password");
    }

    public String getDbWorkUser() {
        String user = this.getExtProperty("db.pool." + this.getPool() + ".user");
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)user)) {
            return this.getDbCreateUser();
        }
        return user;
    }

    public String getDefaultContentEncoding() {
        return this.getExtProperty("defaultContentEncoding");
    }

    public String getDefaultWebApplication() {
        return this.m_defaultWebApplication;
    }

    public String getDisplayForModule(CmsModule module) {
        String name = module.getNiceName();
        String group = module.getGroup();
        String version = module.getVersion().getVersion();
        String display = name;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)group)) {
            display = group + ": " + display;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)version)) {
            display = display + " (" + version + ")";
        }
        return display;
    }

    public List getErrors() {
        return this.m_errors;
    }

    public String getEthernetAddress() {
        return this.getExtProperty("server.ethernet.address");
    }

    public String getHtmlHelpIcon(String id, String pathPrefix) {
        String value = m_htmlProps.getProperty("C_HELP_IMG");
        if (value == null) {
            return "";
        }
        value = CmsStringUtil.substitute((String)value, (String)"$replace$", (String)id);
        return CmsStringUtil.substitute((String)value, (String)"$path$", (String)pathPrefix);
    }

    public String getHtmlPart(String part) {
        return this.getHtmlPart(part, "");
    }

    public String getHtmlPart(String part, String replaceString) {
        String value = m_htmlProps.getProperty(part);
        if (value == null) {
            return "";
        }
        return CmsStringUtil.substitute((String)value, (String)"$replace$", (String)replaceString);
    }

    public String getLibFolder() {
        return this.getWebAppRfsPath() + CmsSystemInfo.FOLDER_WEBINF + FOLDER_LIB;
    }

    public String getLogName() {
        return this.m_webAppRfsPath + this.m_logFile;
    }

    public Map getModuleDependencies() {
        if (this.m_moduleDependencies == null || this.m_moduleDependencies.isEmpty()) {
            try {
                this.m_moduleDependencies = CmsModuleManager.buildDepsForAllModules((String)this.getModuleFolder(), (boolean)true);
            }
            catch (CmsConfigurationException e) {
                throw new CmsRuntimeException(e.getMessageContainer());
            }
        }
        return this.m_moduleDependencies;
    }

    public String getModuleFolder() {
        return this.m_webAppRfsPath + this.m_modulesFolder;
    }

    public List getModulesToInstall() {
        if (this.m_installModules == null || this.m_installModules.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.m_installModules);
    }

    public String getPool() {
        return CmsStringUtil.splitAsArray((String)this.getExtProperty("db.pools"), (String)",")[0];
    }

    public ExtendedProperties getProperties() {
        return this.m_extProperties;
    }

    public Map getReplacer() {
        return this.m_replacer;
    }

    public String getServerName() {
        return this.getExtProperty("server.name");
    }

    public ServletConfig getServletConfig() {
        return this.m_servletConfig;
    }

    public String getServletMapping() {
        return this.m_servletMapping;
    }

    public List getSortedDatabases() {
        if (this.m_sortedDatabaseKeys == null) {
            List databases = this.m_databaseKeys;
            ArrayList<String> sortedDatabases = new ArrayList<String>(databases.size());
            TreeMap<Integer, String> mappedDatabases = new TreeMap<Integer, String>();
            for (int i = 0; i < databases.size(); ++i) {
                String key = (String)databases.get(i);
                Integer ranking = new Integer(0);
                try {
                    ranking = Integer.valueOf(this.getDbProperty(key + ".ranking"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                mappedDatabases.put(ranking, key);
            }
            while (mappedDatabases.size() > 0) {
                Integer key = (Integer)mappedDatabases.lastKey();
                String database = (String)mappedDatabases.get(key);
                sortedDatabases.add(database);
                mappedDatabases.remove(key);
            }
            this.m_sortedDatabaseKeys = sortedDatabases;
        }
        return this.m_sortedDatabaseKeys;
    }

    public String getWebAppRfsPath() {
        return this.m_webAppRfsPath;
    }

    public boolean getWizardEnabled() {
        return Boolean.valueOf(this.getExtProperty("wizard.enabled"));
    }

    public CmsSetupWorkplaceImportThread getWorkplaceImportThread() {
        return this.m_workplaceImportThread;
    }

    public String getWorkplaceSite() {
        return this.getExtProperty("site.workplace");
    }

    public CmsSetupXmlHelper getXmlHelper() {
        if (this.m_xmlHelper == null) {
            this.m_xmlHelper = new CmsSetupXmlHelper(this.getConfigRfsPath());
        }
        return this.m_xmlHelper;
    }

    public String htmlComponents() {
        StringBuffer html = new StringBuffer(1024);
        Iterator itComponents = this.m_components.elementList().iterator();
        while (itComponents.hasNext()) {
            CmsSetupComponent component = (CmsSetupComponent)itComponents.next();
            html.append(this.htmlComponent(component));
        }
        return html.toString();
    }

    public String htmlModuleHelpDescriptions() {
        StringBuffer html = new StringBuffer(1024);
        Iterator itModules = this.sortModules(this.getAvailableModules().values()).iterator();
        int i = 0;
        while (itModules.hasNext()) {
            String moduleName = (String)itModules.next();
            CmsModule module = (CmsModule)this.getAvailableModules().get(moduleName);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)module.getDescription())) {
                html.append(this.getHtmlPart("C_HELP_START", "" + i));
                html.append(module.getDescription());
                html.append("\n");
                html.append(this.getHtmlPart("C_HELP_END"));
                html.append("\n");
            }
            ++i;
        }
        return html.toString();
    }

    public String htmlModules() {
        StringBuffer html = new StringBuffer(1024);
        Iterator itModules = this.sortModules(this.getAvailableModules().values()).iterator();
        int i = 0;
        while (itModules.hasNext()) {
            String moduleName = (String)itModules.next();
            CmsModule module = (CmsModule)this.getAvailableModules().get(moduleName);
            html.append(this.htmlModule(module, i));
            ++i;
        }
        return html.toString();
    }

    public void importModulesFromSetupBean() throws Exception {
        if (this.m_cms != null && this.m_installModules != null) {
            for (int i = 0; i < this.m_installModules.size(); ++i) {
                String filename = (String)this.m_moduleFilenames.get(this.m_installModules.get(i));
                try {
                    this.importModuleFromDefault(filename);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public void init(PageContext pageContext) {
        String webAppRfsPath = pageContext.getServletConfig().getServletContext().getRealPath("/");
        String servletMapping = pageContext.getServletContext().getInitParameter("OpenCmsServlet");
        String defaultWebApplication = pageContext.getServletContext().getInitParameter("DefaultWebApplication");
        this.m_servletConfig = pageContext.getServletConfig();
        this.init(webAppRfsPath, servletMapping, defaultWebApplication);
    }

    public void init(String webAppRfsPath, String servletMapping, String defaultWebApplication) {
        try {
            this.m_availableModules = null;
            this.m_databaseKey = null;
            this.m_databaseKeys = null;
            this.m_databaseProperties = null;
            this.m_extProperties = null;
            this.m_installModules = null;
            this.m_moduleDependencies = null;
            this.m_sortedDatabaseKeys = null;
            this.m_moduleFilenames = null;
            if (servletMapping == null) {
                servletMapping = "/opencms/*";
            }
            if (defaultWebApplication == null) {
                defaultWebApplication = "ROOT";
            }
            this.m_servletMapping = servletMapping;
            this.m_defaultWebApplication = defaultWebApplication;
            this.setWebAppRfsPath(webAppRfsPath);
            this.m_errors = new ArrayList();
            if (CmsStringUtil.isNotEmpty((String)webAppRfsPath)) {
                this.m_extProperties = this.loadProperties(this.m_configRfsPath + "opencms.properties");
                this.readDatabaseConfig();
            }
            if (this.m_workplaceImportThread != null) {
                if (this.m_workplaceImportThread.isAlive()) {
                    this.m_workplaceImportThread.kill();
                }
                this.m_workplaceImportThread = null;
                this.m_newLoggingOffset = 0;
                this.m_oldLoggingOffset = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_errors.add(e.toString());
        }
    }

    public void initHtmlParts() {
        if (m_htmlProps != null) {
            return;
        }
        try {
            m_htmlProps = new Properties();
            m_htmlProps.load(this.getClass().getClassLoader().getResourceAsStream(HTML_MESSAGE_FILE));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_errors.add(e.toString());
        }
    }

    public void initShellCmsObject(CmsObject cms, CmsShell shell) {
        this.m_cms = cms;
    }

    public String isChecked(String value1, String value2) {
        if (value1 == null || value2 == null) {
            return "";
        }
        if (value1.trim().equalsIgnoreCase(value2.trim())) {
            return "checked";
        }
        return "";
    }

    public boolean isInitialized() {
        return this.m_extProperties != null;
    }

    public String jsComponentDependencies() {
        List components = this.m_components.elementList();
        Map componentDependencies = this.buildDepsForAllComponents();
        StringBuffer jsCode = new StringBuffer(1024);
        jsCode.append("\t// an array holding the dependent components for the n-th component\n");
        jsCode.append("\tvar componentDependencies = new Array(");
        jsCode.append(components.size());
        jsCode.append(");\n");
        for (int i = 0; i < components.size(); ++i) {
            CmsSetupComponent component = (CmsSetupComponent)components.get(i);
            List dependencies = (List)componentDependencies.get(component.getId());
            jsCode.append("\tcomponentDependencies[" + i + "] = new Array(");
            if (dependencies != null) {
                for (int j = 0; j < dependencies.size(); ++j) {
                    jsCode.append("\"" + dependencies.get(j) + "\"");
                    if (j >= dependencies.size() - 1) continue;
                    jsCode.append(", ");
                }
            }
            jsCode.append(");\n");
        }
        jsCode.append("\n\n");
        return jsCode.toString();
    }

    public String jsComponentModules() {
        List components = this.m_components.elementList();
        StringBuffer jsCode = new StringBuffer(1024);
        jsCode.append("\t// an array holding the components modules\n");
        jsCode.append("\tvar componentModules = new Array(");
        jsCode.append(components.size());
        jsCode.append(");\n");
        for (int i = 0; i < components.size(); ++i) {
            CmsSetupComponent component = (CmsSetupComponent)components.get(i);
            jsCode.append("\tcomponentModules[" + i + "] = \"");
            List modules = this.getComponentModules(component);
            for (int j = 0; j < modules.size(); ++j) {
                jsCode.append(modules.get(j));
                if (j >= modules.size() - 1) continue;
                jsCode.append("|");
            }
            jsCode.append("\";\n");
        }
        jsCode.append("\n\n");
        return jsCode.toString();
    }

    public String jsComponentNames() {
        StringBuffer jsCode = new StringBuffer(1024);
        jsCode.append("\t// an array from 1...n holding the component names\n");
        jsCode.append("\tvar componentNames = new Array(");
        jsCode.append(this.m_components.elementList().size());
        jsCode.append(");\n");
        for (int i = 0; i < this.m_components.elementList().size(); ++i) {
            CmsSetupComponent component = (CmsSetupComponent)this.m_components.elementList().get(i);
            jsCode.append("\tcomponentNames[" + i + "] = \"" + component.getId() + "\";\n");
        }
        jsCode.append("\n\n");
        return jsCode.toString();
    }

    public String jsModuleDependencies() {
        List moduleNames = this.sortModules(this.getAvailableModules().values());
        StringBuffer jsCode = new StringBuffer(1024);
        jsCode.append("\t// an array holding the dependent modules for the n-th module\n");
        jsCode.append("\tvar moduleDependencies = new Array(");
        jsCode.append(moduleNames.size());
        jsCode.append(");\n");
        for (int i = 0; i < moduleNames.size(); ++i) {
            String moduleName = (String)moduleNames.get(i);
            List dependencies = (List)this.getModuleDependencies().get(moduleName);
            jsCode.append("\tmoduleDependencies[" + i + "] = new Array(");
            if (dependencies != null) {
                for (int j = 0; j < dependencies.size(); ++j) {
                    jsCode.append("\"" + dependencies.get(j) + "\"");
                    if (j >= dependencies.size() - 1) continue;
                    jsCode.append(", ");
                }
            }
            jsCode.append(");\n");
        }
        jsCode.append("\n\n");
        return jsCode.toString();
    }

    public String jsModuleNames() {
        List moduleNames = this.sortModules(this.getAvailableModules().values());
        StringBuffer jsCode = new StringBuffer(1024);
        jsCode.append("\t// an array from 1...n holding the module package names\n");
        jsCode.append("\tvar modulePackageNames = new Array(");
        jsCode.append(moduleNames.size());
        jsCode.append(");\n");
        for (int i = 0; i < moduleNames.size(); ++i) {
            String moduleName = (String)moduleNames.get(i);
            jsCode.append("\tmodulePackageNames[" + i + "] = \"" + moduleName + "\";\n");
        }
        jsCode.append("\n\n");
        return jsCode.toString();
    }

    public ExtendedProperties loadProperties(String file) throws IOException {
        return CmsPropertyUtils.loadProperties((String)file);
    }

    public void lockWizard() {
        this.setExtProperty("wizard.enabled", CmsStringUtil.FALSE);
    }

    public void prepareStep10() {
        if (this.isInitialized()) {
            this.lockWizard();
            this.saveProperties(this.getProperties(), "opencms.properties", false);
        }
    }

    public boolean prepareStep8() throws CmsXmlException {
        if (this.isInitialized()) {
            StringBuffer xp;
            this.checkEthernetAddress();
            this.backupConfiguration("opencms-importexport.xml", "opencms-importexport.xml.ori");
            this.backupConfiguration("opencms-modules.xml", "opencms-modules.xml.ori");
            this.backupConfiguration("opencms-search.xml", "opencms-search.xml.ori");
            this.backupConfiguration("opencms-system.xml", "opencms-system.xml.ori");
            this.backupConfiguration("opencms-vfs.xml", "opencms-vfs.xml.ori");
            this.backupConfiguration("opencms-workplace.xml", "opencms-workplace.xml.ori");
            this.backupConfiguration("opencms.xml", "opencms.xml.ori");
            this.saveProperties(this.getProperties(), "opencms.properties", true);
            CmsSetupTestResult testResult = new CmsSetupTestSimapi().execute(this);
            if (testResult.getResult().equals("failed!")) {
                xp = new StringBuffer(256);
                xp.append("/").append("opencms");
                xp.append("/").append("vfs");
                xp.append("/").append("resources");
                xp.append("/").append("resourceloaders");
                xp.append("/").append("loader");
                xp.append("[@").append("class");
                xp.append("='").append(CmsImageLoader.class.getName());
                xp.append("']/").append("param");
                xp.append("[@").append("name");
                xp.append("='").append("image.scaling.enabled").append("']");
                this.getXmlHelper().setValue("opencms-vfs.xml", xp.toString(), Boolean.FALSE.toString());
            }
            xp = new StringBuffer(256);
            xp.append("/").append("opencms");
            xp.append("/").append("system");
            xp.append("/").append("sites");
            xp.append("/").append("workplace-server");
            this.getXmlHelper().setValue("opencms-system.xml", xp.toString(), this.getWorkplaceSite());
            xp = new StringBuffer(256);
            xp.append("/").append("opencms");
            xp.append("/").append("system");
            xp.append("/").append("sites");
            xp.append("/").append("site");
            xp.append("[@").append("uri");
            xp.append("='").append("/sites");
            xp.append("/default/']/@").append("server");
            this.getXmlHelper().setValue("opencms-system.xml", xp.toString(), this.getWorkplaceSite());
            this.getXmlHelper().writeAll();
        }
        return true;
    }

    public void prepareStep8b() {
        if (!this.isInitialized()) {
            return;
        }
        if (this.m_workplaceImportThread != null && this.m_workplaceImportThread.isFinished()) {
            return;
        }
        if (this.m_workplaceImportThread == null) {
            this.m_workplaceImportThread = new CmsSetupWorkplaceImportThread(this);
        }
        if (!this.m_workplaceImportThread.isAlive()) {
            this.m_workplaceImportThread.start();
        }
    }

    public void prepareStep8bOutput(JspWriter out) throws IOException {
        if (this.m_workplaceImportThread == null || this.m_workplaceImportThread.getLoggingThread() == null) {
            return;
        }
        this.m_oldLoggingOffset = this.m_newLoggingOffset;
        this.m_newLoggingOffset = this.m_workplaceImportThread.getLoggingThread().getMessages().size();
        if (this.isInitialized()) {
            for (int i = this.m_oldLoggingOffset; i < this.m_newLoggingOffset; ++i) {
                String str = this.m_workplaceImportThread.getLoggingThread().getMessages().get(i).toString();
                str = CmsEncoder.escapeWBlanks((String)str, (String)"UTF-8");
                out.println("output[" + (i - this.m_oldLoggingOffset) + "] = \"" + str + "\";");
            }
        } else {
            out.println("output[0] = 'ERROR';");
        }
        boolean threadFinished = this.m_workplaceImportThread.isFinished();
        boolean allWritten = this.m_oldLoggingOffset >= this.m_workplaceImportThread.getLoggingThread().getMessages().size();
        out.println("function initThread() {");
        if (this.isInitialized()) {
            out.print("send();");
            if (threadFinished && allWritten) {
                out.println("setTimeout('top.display.finish()', 1000);");
            } else {
                int timeout = 5000;
                if (this.getWorkplaceImportThread().getLoggingThread().getMessages().size() < 20) {
                    timeout = 2000;
                }
                out.println("setTimeout('location.reload()', " + timeout + ");");
            }
        }
        out.println("}");
    }

    public void saveProperties(ExtendedProperties properties, String file, boolean backup) {
        if (new File(this.m_configRfsPath + file).isFile()) {
            String backupFile = file + ".ori";
            String tempFile = file + ".tmp";
            this.m_errors.clear();
            if (backup) {
                this.copyFile(file, FOLDER_BACKUP + backupFile);
            }
            this.copyFile(file, tempFile);
            this.save(properties, tempFile, file);
            File temp = new File(this.m_configRfsPath + tempFile);
            temp.delete();
        } else {
            this.m_errors.add("No valid file: " + file + "\n");
        }
    }

    public void setDatabase(String databaseKey) {
        this.m_databaseKey = databaseKey;
        String vfsDriver = this.getDbProperty(this.m_databaseKey + ".vfs.driver");
        String userDriver = this.getDbProperty(this.m_databaseKey + ".user.driver");
        String projectDriver = this.getDbProperty(this.m_databaseKey + ".project.driver");
        String historyDriver = this.getDbProperty(this.m_databaseKey + ".history.driver");
        String sqlManager = this.getDbProperty(this.m_databaseKey + ".sqlmanager");
        this.setExtProperty("db.name", this.m_databaseKey);
        this.setExtProperty("db.vfs.driver", vfsDriver);
        this.setExtProperty("db.vfs.sqlmanager", sqlManager);
        this.setExtProperty("db.user.driver", userDriver);
        this.setExtProperty("db.user.sqlmanager", sqlManager);
        this.setExtProperty("db.project.driver", projectDriver);
        this.setExtProperty("db.project.sqlmanager", sqlManager);
        this.setExtProperty("db.history.driver", historyDriver);
        this.setExtProperty("db.history.sqlmanager", sqlManager);
    }

    public void setDb(String db) {
        this.setDbProperty(this.m_databaseKey + ".dbname", db);
    }

    public void setDbConStrParams(String value) {
        this.setDbProperty(this.m_databaseKey + ".constr.params", value);
    }

    public void setDbCreateConStr(String dbCreateConStr) {
        this.setDbProperty(this.m_databaseKey + ".constr", dbCreateConStr);
    }

    public void setDbCreatePwd(String dbCreatePwd) {
        this.m_dbCreatePwd = dbCreatePwd;
    }

    public void setDbCreateUser(String dbCreateUser) {
        this.setDbProperty(this.m_databaseKey + ".user", dbCreateUser);
    }

    public void setDbDriver(String driver) {
        this.setDbProperty(this.m_databaseKey + ".driver", driver);
    }

    public boolean setDbParamaters(HttpServletRequest request, String provider) {
        boolean isFormSubmitted;
        String conStr = request.getParameter("dbCreateConStr");
        this.m_provider = provider;
        boolean bl = isFormSubmitted = request.getParameter("submit") != null && conStr != null;
        if (conStr == null) {
            conStr = "";
        }
        String database = "";
        if (provider.equals(MYSQL_PROVIDER) || provider.equals(MSSQL_PROVIDER) || provider.equals(DB2_PROVIDER) || provider.equals(AS400_PROVIDER)) {
            database = request.getParameter("db");
        } else if (provider.equals(POSTGRESQL_PROVIDER)) {
            database = request.getParameter("dbName");
        }
        if (provider.equals(MYSQL_PROVIDER) || provider.equals(MSSQL_PROVIDER) || provider.equals(POSTGRESQL_PROVIDER) || provider.equals(AS400_PROVIDER) || provider.equals(DB2_PROVIDER)) {
            boolean bl2 = isFormSubmitted = isFormSubmitted && database != null;
        }
        if (this.isInitialized()) {
            String createTables;
            String createDb = request.getParameter("createDb");
            if (createDb == null || provider.equals(DB2_PROVIDER) || provider.equals(AS400_PROVIDER)) {
                createDb = "";
            }
            if ((createTables = request.getParameter("createTables")) == null) {
                createTables = "";
            }
            if (isFormSubmitted) {
                if (provider.equals(POSTGRESQL_PROVIDER)) {
                    this.setDb(database);
                    String templateDb = request.getParameter("templateDb");
                    this.setDbProperty(this.getDatabase() + ".templateDb", templateDb);
                    this.setDbProperty(this.getDatabase() + ".newDb", database);
                    if (!conStr.endsWith("/")) {
                        conStr = conStr + "/";
                    }
                    this.setDbProperty(this.getDatabase() + ".constr", conStr + this.getDbProperty(this.getDatabase() + ".templateDb"));
                    this.setDbProperty(this.getDatabase() + ".constr.newDb", conStr + this.getDbProperty(this.getDatabase() + ".newDb"));
                    conStr = conStr + database;
                } else if (provider.equals(MYSQL_PROVIDER) || provider.equals(DB2_PROVIDER) || provider.equals(MSSQL_PROVIDER) || provider.equals(POSTGRESQL_PROVIDER)) {
                    if (!conStr.endsWith("/")) {
                        conStr = conStr + "/";
                    }
                    conStr = conStr + database;
                } else if (provider.equals(AS400_PROVIDER)) {
                    if (conStr.endsWith("/")) {
                        conStr = conStr.substring(0, conStr.length() - 1);
                    }
                    if (!conStr.endsWith(";")) {
                        conStr = conStr + ";";
                    }
                    conStr = conStr + "libraries='" + database + "'";
                }
                this.setDbWorkConStr(conStr);
                if (provider.equals(POSTGRESQL_PROVIDER)) {
                    this.setDb(database);
                }
                String dbCreateUser = request.getParameter("dbCreateUser");
                String dbCreatePwd = request.getParameter("dbCreatePwd");
                String dbWorkUser = request.getParameter("dbWorkUser");
                String dbWorkPwd = request.getParameter("dbWorkPwd");
                if (dbCreateUser != null && !provider.equals(DB2_PROVIDER) && !provider.equals(AS400_PROVIDER)) {
                    this.setDbCreateUser(dbCreateUser);
                }
                this.setDbCreatePwd(dbCreatePwd);
                if (dbWorkUser.equals("")) {
                    dbWorkUser = request.getContextPath();
                }
                if (dbWorkUser.equals("")) {
                    dbWorkUser = "opencms";
                }
                if (dbWorkUser.startsWith("/")) {
                    dbWorkUser = dbWorkUser.substring(1, dbWorkUser.length());
                }
                this.setDbWorkUser(dbWorkUser);
                this.setDbWorkPwd(dbWorkPwd);
                if (provider.equals(ORACLE_PROVIDER)) {
                    String dbDefaultTablespace = request.getParameter("dbDefaultTablespace");
                    String dbTemporaryTablespace = request.getParameter("dbTemporaryTablespace");
                    String dbIndexTablespace = request.getParameter("dbIndexTablespace");
                    this.setDbProperty(this.getDatabase() + ".defaultTablespace", dbDefaultTablespace);
                    this.setDbProperty(this.getDatabase() + ".temporaryTablespace", dbTemporaryTablespace);
                    this.setDbProperty(this.getDatabase() + ".indexTablespace", dbIndexTablespace);
                }
                HashMap<String, String> replacer = new HashMap<String, String>();
                if (!provider.equals(MYSQL_PROVIDER) || provider.equals(MSSQL_PROVIDER)) {
                    replacer.put("${user}", dbWorkUser);
                    replacer.put("${password}", dbWorkPwd);
                }
                if (provider.equals(MYSQL_PROVIDER) || provider.equals(MSSQL_PROVIDER) || provider.equals(POSTGRESQL_PROVIDER)) {
                    replacer.put("${database}", database);
                }
                if (provider.equals(ORACLE_PROVIDER)) {
                    replacer.put("${defaultTablespace}", this.getDbProperty(this.getDatabase() + ".defaultTablespace"));
                    replacer.put("${indexTablespace}", this.getDbProperty(this.getDatabase() + ".indexTablespace"));
                    replacer.put("${temporaryTablespace}", this.getDbProperty(this.getDatabase() + ".temporaryTablespace"));
                }
                this.setReplacer(replacer);
                if (provider.equals(GENERIC_PROVIDER) || provider.equals(ORACLE_PROVIDER) || provider.equals(DB2_PROVIDER) || provider.equals(AS400_PROVIDER) || provider.equals(MAXDB_PROVIDER)) {
                    request.getSession().setAttribute("createTables", (Object)createTables);
                }
                request.getSession().setAttribute("createDb", (Object)createDb);
            } else {
                String dbName = "opencms";
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)request.getContextPath())) {
                    dbName = request.getContextPath().substring(1);
                }
                if (provider.equals(ORACLE_PROVIDER) || provider.equals(POSTGRESQL_PROVIDER) || provider.equals(MAXDB_PROVIDER)) {
                    this.setDbWorkUser(dbName);
                } else {
                    this.setDb(dbName);
                }
            }
        }
        return isFormSubmitted;
    }

    public void setDbProperty(String key, String value) {
        String databaseKey = key.substring(0, key.indexOf(46));
        Map databaseProperties = (Map)this.getDatabaseProperties().get(databaseKey);
        databaseProperties.put(key, value);
    }

    public void setDbWorkConStr(String dbWorkConStr) {
        String driver = this.getDbProperty(this.m_databaseKey + ".driver");
        String pool = '.' + this.getPool() + '.';
        this.setExtProperty("db.pool" + pool + "jdbcDriver", driver);
        this.setExtProperty("db.pool" + pool + "jdbcUrl", dbWorkConStr);
        this.setExtProperty("db.pool" + pool + "testQuery", this.getDbTestQuery());
        this.setExtProperty("db.pool" + pool + "jdbcUrl.params", this.getDbConStrParams());
    }

    public void setDbWorkPwd(String dbWorkPwd) {
        this.setExtProperty("db.pool." + this.getPool() + '.' + "password", dbWorkPwd);
    }

    public void setDbWorkUser(String dbWorkUser) {
        this.setExtProperty("db.pool." + this.getPool() + '.' + "user", dbWorkUser);
    }

    public void setEthernetAddress(String ethernetAddress) {
        this.setExtProperty("server.ethernet.address", ethernetAddress);
    }

    public void setInstallModules(String value) {
        this.m_installModules = CmsStringUtil.splitAsList((String)value, (String)"|", (boolean)true);
        try {
            this.m_installModules = CmsModuleManager.topologicalSort((List)this.m_installModules, (String)this.getModuleFolder());
        }
        catch (CmsConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setReplacer(Map map) {
        this.m_replacer = map;
    }

    public void setServerName(String name) {
        this.setExtProperty("server.name", name);
    }

    public void setWorkplaceSite(String newSite) {
        String oldSite = this.getWorkplaceSite();
        String siteList = this.getExtProperty("site.root.list");
        siteList = CmsStringUtil.substitute((String)siteList, (String)oldSite, (String)newSite);
        this.setExtProperty("site.root.list", siteList);
        this.setExtProperty("site.workplace", newSite);
    }

    public void shellExit() {
        System.out.println();
        System.out.println();
        System.out.println("The setup is finished!\nThe OpenCms system used for the setup will now shut down.");
    }

    public void shellStart() {
        System.out.println();
        System.out.println("Starting Workplace import and database setup for OpenCms!");
        String[] copy = org.opencms.main.Messages.COPYRIGHT_BY_ALKACON;
        for (int i = copy.length - 1; i >= 0; --i) {
            System.out.println(copy[i]);
        }
        System.out.println("This is OpenCms " + OpenCms.getSystemInfo().getVersionNumber());
        System.out.println();
        System.out.println();
    }

    public List sortModules(Collection modules) {
        ArrayList aux = new ArrayList(modules);
        Collections.sort(aux, new Comparator(){

            public int compare(Object o1, Object o2) {
                CmsModule module1 = (CmsModule)o1;
                CmsModule module2 = (CmsModule)o2;
                return CmsSetupBean.this.getDisplayForModule(module1).compareTo(CmsSetupBean.this.getDisplayForModule(module2));
            }
        });
        ArrayList<String> ret = new ArrayList<String>(aux.size());
        Iterator it = aux.iterator();
        while (it.hasNext()) {
            CmsModule module = (CmsModule)it.next();
            ret.add(module.getName());
        }
        return ret;
    }

    public boolean validateJdbc() {
        boolean result = false;
        String libFolder = this.getLibFolder();
        Iterator it = this.getDatabaseLibs(this.getDatabase()).iterator();
        while (it.hasNext()) {
            String libName = (String)it.next();
            File libFile = new File(libFolder, libName);
            if (!libFile.exists()) continue;
            result = true;
        }
        return result;
    }

    protected void addComponentsFromPath(String fileName) throws CmsConfigurationException {
        ExtendedProperties configuration;
        try {
            configuration = this.getComponentsProperties(fileName);
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return;
        }
        Iterator<String> it = Arrays.asList(configuration.getStringArray(PROPKEY_COMPONENTS)).iterator();
        while (it.hasNext()) {
            String componentId = it.next();
            CmsSetupComponent componentBean = new CmsSetupComponent();
            componentBean.setId(componentId);
            componentBean.setName(configuration.getString(PROPKEY_COMPONENT + componentId + PROPKEY_NAME));
            componentBean.setDescription(configuration.getString(PROPKEY_COMPONENT + componentId + PROPKEY_DESCRIPTION));
            componentBean.setModulesRegex(configuration.getString(PROPKEY_COMPONENT + componentId + PROPKEY_MODULES));
            componentBean.setDependencies(Arrays.asList(configuration.getStringArray(PROPKEY_COMPONENT + componentId + PROPKEY_DEPENDENCIES)));
            componentBean.setPosition(configuration.getInteger(PROPKEY_COMPONENT + componentId + PROPKEY_POSITION, 9999));
            componentBean.setChecked(configuration.getBoolean(PROPKEY_COMPONENT + componentId + PROPKEY_CHECKED, false));
            this.m_components.addIdentifiableObject(componentBean.getId(), (Object)componentBean, (float)componentBean.getPosition());
        }
    }

    protected ExtendedProperties getComponentsProperties(String location) throws FileNotFoundException, CmsConfigurationException {
        InputStream stream = null;
        ZipFile zipFile = null;
        try {
            File folder = new File(location);
            if (folder.isFile()) {
                zipFile = new ZipFile(location);
                ZipEntry entry = zipFile.getEntry(COMPONENTS_PROPERTIES);
                if (entry == null && location.startsWith("/")) {
                    entry = zipFile.getEntry(location.substring(1));
                }
                if (entry == null) {
                    throw new FileNotFoundException(org.opencms.importexport.Messages.get().getBundle().key("LOG_IMPORTEXPORT_FILE_NOT_FOUND_IN_ZIP_1", (Object)(location + "/" + COMPONENTS_PROPERTIES)));
                }
                stream = zipFile.getInputStream(entry);
            } else {
                File file = new File(folder, COMPONENTS_PROPERTIES);
                stream = new FileInputStream(file);
            }
            return CmsPropertyUtils.loadProperties((InputStream)stream);
        }
        catch (Throwable ioe) {
            block15: {
                block14: {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            if (!LOG.isDebugEnabled()) break block14;
                            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block15;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            if (ioe instanceof FileNotFoundException) {
                throw (FileNotFoundException)ioe;
            }
            CmsMessageContainer msg = org.opencms.importexport.Messages.get().container("ERR_IMPORTEXPORT_ERROR_READING_FILE_1", (Object)(location + "/" + COMPONENTS_PROPERTIES));
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg.key(), ioe);
            }
            throw new CmsConfigurationException(msg, ioe);
        }
    }

    protected String getExtProperty(String key) {
        Object value = this.m_extProperties.get((Object)key);
        return value != null ? value.toString() : "";
    }

    protected String htmlComponent(CmsSetupComponent component) {
        StringBuffer html = new StringBuffer(256);
        html.append("\t<tr>\n");
        html.append("\t\t<td>\n");
        html.append("\t\t\t<input type='checkbox' name='availableComponents' value='");
        html.append(component.getId());
        html.append("'");
        if (component.isChecked()) {
            html.append(" checked='checked'");
        }
        html.append(" onClick=\"checkComponentDependencies('");
        html.append(component.getId());
        html.append("');\">\n");
        html.append("\t\t</td>\n");
        html.append("\t\t<td style='width: 100%; '>\n\t\t\t");
        html.append(component.getName());
        html.append("\n\t\t</td>\n");
        html.append("\t</tr>\n");
        html.append("\t<tr>\n");
        html.append("\t\t<td>&nbsp;</td>\n");
        html.append("\t\t<td style='vertical-align: top; width: 100%; padding-bottom: 8px; font-style: italic;'>\n\t\t\t");
        html.append(component.getDescription());
        html.append("\n\t\t</td>\n");
        html.append("\t</tr>\n");
        return html.toString();
    }

    protected String htmlModule(CmsModule module, int pos) {
        StringBuffer html = new StringBuffer(256);
        html.append("\t<tr>\n");
        html.append("\t\t<td style='vertical-align: top;'>\n");
        html.append("\t\t\t<input type='checkbox' name='availableModules' value='");
        html.append(module.getName());
        html.append("' checked='checked' onClick=\"checkModuleDependencies('");
        html.append(module.getName());
        html.append("');\">\n");
        html.append("\t\t</td>\n");
        html.append("\t\t<td style='vertical-align: top; width: 100%; padding-top: 4px;'>\n\t\t\t");
        html.append(this.getDisplayForModule(module));
        html.append("\n\t\t</td>\n");
        html.append("\t\t<td style='vertical-align: top; text-align: right;'>\n");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)module.getDescription())) {
            html.append("\t\t\t");
            html.append(this.getHtmlHelpIcon("" + pos, ""));
        }
        html.append("\t\t</td>\n");
        html.append("\t</tr>\n");
        return html.toString();
    }

    protected void importModuleFromDefault(String importFile) throws Exception {
        String fileName = this.getModuleFolder() + importFile;
        OpenCms.getImportExportManager().importData(this.m_cms, (I_CmsReport)new CmsShellReport(this.m_cms.getRequestContext().getLocale()), new CmsImportParameters(fileName, "/", true));
    }

    protected void initializeComponents(Collection modules) {
        Iterator itGroups = new ArrayList(this.m_components.elementList()).iterator();
        while (itGroups.hasNext()) {
            CmsSetupComponent component = (CmsSetupComponent)itGroups.next();
            String errMsg = "";
            String warnMsg = "";
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)component.getName())) {
                errMsg = errMsg + Messages.get().container("ERR_COMPONENT_NAME_EMPTY_1", (Object)component.getId()).key();
                errMsg = errMsg + "\n";
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)component.getName())) {
                warnMsg = warnMsg + Messages.get().container("LOG_WARN_COMPONENT_DESC_EMPTY_1", (Object)component.getId()).key();
                warnMsg = warnMsg + "\n";
            }
            if (component.getPosition() == 9999) {
                warnMsg = warnMsg + Messages.get().container("LOG_WARN_COMPONENT_POS_EMPTY_1", (Object)component.getId()).key();
                warnMsg = warnMsg + "\n";
            }
            Iterator itDeps = component.getDependencies().iterator();
            while (itDeps.hasNext()) {
                String dependency = (String)itDeps.next();
                if (this.m_components.getObject(dependency) != null) continue;
                errMsg = errMsg + Messages.get().container("LOG_WARN_COMPONENT_DEPENDENCY_BROKEN_2", (Object)component.getId(), (Object)dependency).key();
                errMsg = errMsg + "\n";
            }
            boolean match = false;
            Iterator itModules = modules.iterator();
            while (itModules.hasNext()) {
                String module = (String)itModules.next();
                if (!component.match(module)) continue;
                match = true;
                itModules.remove();
            }
            if (!match) {
                errMsg = errMsg + Messages.get().container("ERR_COMPONENT_MODULES_EMPTY_1", (Object)component.getId()).key();
                errMsg = errMsg + "\n";
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)errMsg)) {
                this.m_components.removeObject(component.getId());
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)errMsg);
                }
            }
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)warnMsg) || !LOG.isWarnEnabled()) continue;
            LOG.warn((Object)warnMsg);
        }
        if (!modules.isEmpty() && LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().container("LOG_WARN_MODULES_LEFT_1", (Object)modules.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void readDatabaseConfig() {
        block19: {
            String databaseKey = null;
            FileInputStream input = null;
            String configPath = null;
            Properties databaseProperties = null;
            File databaseSetupFolder = null;
            File[] childResources = null;
            File childResource = null;
            File setupFile = null;
            boolean hasMissingSetupFiles = false;
            this.m_databaseKeys = new ArrayList();
            this.m_databaseProperties = new HashMap();
            databaseSetupFolder = new File(this.m_webAppRfsPath + FOLDER_SETUP + FOLDER_DATABASE);
            if (databaseSetupFolder.exists()) {
                int i;
                childResources = databaseSetupFolder.listFiles();
                if (childResources != null) {
                    block10: for (i = 0; i < childResources.length; ++i) {
                        childResource = childResources[i];
                        hasMissingSetupFiles = false;
                        if (!childResource.exists() || !childResource.isDirectory() || !childResource.canRead()) continue;
                        for (int j = 0; j < REQUIRED_DB_SETUP_FILES.length; ++j) {
                            setupFile = new File(childResource.getPath() + File.separatorChar + REQUIRED_DB_SETUP_FILES[j]);
                            if (!(setupFile.exists() && setupFile.isFile() && setupFile.canRead())) {
                                hasMissingSetupFiles = true;
                                System.err.println("[" + this.getClass().getName() + "] missing or unreadable database setup file: " + setupFile.getPath());
                                continue block10;
                            }
                            if (hasMissingSetupFiles) continue;
                            this.m_databaseKeys.add(childResource.getName().trim());
                        }
                    }
                }
                for (i = 0; i < this.m_databaseKeys.size(); ++i) {
                    databaseKey = (String)this.m_databaseKeys.get(i);
                    configPath = this.m_webAppRfsPath + "setup" + File.separatorChar + "database" + File.separatorChar + databaseKey + File.separatorChar + "database.properties";
                    try {
                        input = new FileInputStream(new File(configPath));
                        databaseProperties = new Properties();
                        databaseProperties.load(input);
                        this.m_databaseProperties.put(databaseKey, databaseProperties);
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println(e.toString());
                        e.printStackTrace(System.err);
                    }
                }
            }
            Object var13_15 = null;
            try {
                if (input != null) {
                    input.close();
                }
                break block19;
            }
            catch (Exception e2) {}
            break block19;
            {
                catch (Exception e) {
                    System.err.println(e.toString());
                    e.printStackTrace(System.err);
                    Object var13_16 = null;
                    try {
                        if (input != null) {
                            input.close();
                        }
                        break block19;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void setExtProperty(String key, String value) {
        this.m_extProperties.put((Object)key, (Object)value);
    }

    private String createValueString(String[] values) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            values[i] = CmsStringUtil.substitute((String)values[i], (String)",", (String)"\\,");
            values[i] = CmsStringUtil.substitute((String)values[i], (String)"=", (String)"\\=");
            buf.append("\t" + values[i] + (i < values.length - 1 ? ",\\\n" : ""));
        }
        return buf.toString();
    }

    private List getComponentModules(CmsSetupComponent component) {
        ArrayList<String> modules = new ArrayList<String>();
        Iterator itModules = this.m_availableModules.keySet().iterator();
        while (itModules.hasNext()) {
            String moduleName = (String)itModules.next();
            if (!component.match(moduleName)) continue;
            modules.add(moduleName);
        }
        return modules;
    }

    private void save(ExtendedProperties properties, String source, String target) {
        try {
            String line;
            HashSet<String> alreadyWritten = new HashSet<String>();
            LineNumberReader lnr = new LineNumberReader(new FileReader(new File(this.m_configRfsPath + source)));
            FileWriter fw = new FileWriter(new File(this.m_configRfsPath + target));
            while ((line = lnr.readLine()) != null) {
                String key;
                if ("".equals(line = line.trim())) {
                    fw.write("\n");
                    continue;
                }
                if (line.startsWith("#")) {
                    fw.write(line);
                    fw.write("\n");
                    continue;
                }
                int index = line.indexOf(61);
                int index1 = line.indexOf("\\=");
                if (line.indexOf(61) <= -1 || index1 == index - 1 || alreadyWritten.contains(key = line.substring(0, line.indexOf(61)).trim())) continue;
                fw.write(key + "=");
                try {
                    Object obj = properties.get((Object)key);
                    String value = "";
                    if (obj != null) {
                        String[] values;
                        if (obj instanceof Vector) {
                            values = new String[]{};
                            values = ((Vector)obj).toArray(values);
                            fw.write("\\\n" + this.createValueString(values));
                        } else if (obj instanceof List) {
                            values = new String[]{};
                            values = ((List)obj).toArray(values);
                            fw.write("\\\n" + this.createValueString(values));
                        } else {
                            value = ((String)obj).trim();
                            value = CmsStringUtil.substitute((String)value, (String)",", (String)"\\,");
                            value = CmsStringUtil.substitute((String)value, (String)"=", (String)"\\=");
                            fw.write(value);
                        }
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                fw.write("\n");
                alreadyWritten.add(key);
            }
            lnr.close();
            fw.close();
        }
        catch (Exception e) {
            this.m_errors.add("Could not save properties to " + target + " \n");
            this.m_errors.add(e.toString() + "\n");
        }
    }

    private void setWebAppRfsPath(String webInfRfsPath) {
        this.m_webAppRfsPath = webInfRfsPath;
        if ("".equals(webInfRfsPath)) {
            this.m_configRfsPath = "";
            return;
        }
        if (!this.m_webAppRfsPath.endsWith(File.separator)) {
            this.m_webAppRfsPath = this.m_webAppRfsPath + File.separator;
        }
        this.m_configRfsPath = this.m_webAppRfsPath + CmsSystemInfo.FOLDER_WEBINF + CmsSystemInfo.FOLDER_CONFIG;
    }
}

