/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CmsSetupComponent {
    private boolean m_checked;
    private List m_dependencies;
    private String m_description;
    private String m_id;
    private Pattern m_modulesRegex;
    private String m_name;
    private int m_position;

    public List getDependencies() {
        return this.m_dependencies;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getId() {
        return this.m_id;
    }

    public Pattern getModulesRegex() {
        return this.m_modulesRegex;
    }

    public String getName() {
        return this.m_name;
    }

    public int getPosition() {
        return this.m_position;
    }

    public boolean isChecked() {
        return this.m_checked;
    }

    public boolean match(String module) {
        return this.m_modulesRegex.matcher(module).matches();
    }

    public void setChecked(boolean checked) {
        this.m_checked = checked;
    }

    public void setDependencies(List dependencies) {
        this.m_dependencies = new ArrayList(dependencies);
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void setModulesRegex(String regex) {
        this.m_modulesRegex = Pattern.compile(regex);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setPosition(int position) {
        this.m_position = position;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("[CmsSetupGroupBean: ");
        ret.append("id=").append(this.m_id).append(", ");
        ret.append("name=").append(this.m_name).append(", ");
        ret.append("description=").append(this.m_description).append(", ");
        ret.append("dependencies=").append(this.m_dependencies).append(", ");
        ret.append("moduleRegex=").append(this.m_modulesRegex.pattern()).append("]");
        return ret.toString();
    }
}

