/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.opencms.util.CmsDataTypeUtil;

public class CmsSetupDBWrapper {
    private Statement m_statement;
    private Connection m_connection;
    private ResultSet m_resultset;
    private PreparedStatement m_preparedStatement;

    public CmsSetupDBWrapper(Connection con) {
        this.m_connection = con;
    }

    public void close() {
        if (this.m_resultset != null) {
            try {
                this.m_resultset.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.m_statement != null) {
            try {
                this.m_statement.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.m_preparedStatement != null) {
            try {
                this.m_preparedStatement.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void createStatement() throws SQLException {
        this.m_statement = this.m_connection.createStatement();
    }

    public void createPreparedStatement(String query, List params) throws SQLException {
        this.m_preparedStatement = this.m_connection.prepareStatement(query);
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                Object item = params.get(i);
                if (item instanceof String) {
                    this.m_preparedStatement.setString(i + 1, (String)item);
                }
                if (item instanceof Integer) {
                    Integer number = (Integer)item;
                    this.m_preparedStatement.setInt(i + 1, number);
                }
                if (item instanceof Long) {
                    Long longNumber = (Long)item;
                    this.m_preparedStatement.setLong(i + 1, longNumber);
                }
                if (item instanceof Integer || item instanceof String || item instanceof Long) continue;
                try {
                    this.m_preparedStatement.setBytes(i + 1, CmsDataTypeUtil.dataSerialize(item));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void excecuteQuery(String query) throws SQLException {
        this.m_resultset = this.m_statement.executeQuery(query);
    }

    public void excecutePreparedQuery() throws SQLException {
        this.m_resultset = this.m_preparedStatement.executeQuery();
    }

    public ResultSet getResultSet() {
        return this.m_resultset;
    }
}

