/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.opencms.main.CmsException;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.Messages;
import org.opencms.util.CmsDataTypeUtil;
import org.opencms.util.CmsStringUtil;

public class CmsSetupDb {
    public static final String SETUP_DATA_FOLDER = "WEB-INF/setupdata/";
    public static final String SETUP_FOLDER = "setup/";
    private String m_basePath;
    private Connection m_con;
    private boolean m_errorLogging;
    private Vector m_errors = new Vector();

    public CmsSetupDb(String basePath) {
        this.m_basePath = basePath;
        this.m_errorLogging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String checkVariables(String db) {
        html = new StringBuffer(512);
        if (this.m_con == null) {
            return null;
        }
        exception = null;
        if (db.equals("mysql")) {
            block20: {
                statement = "SELECT @@max_allowed_packet;";
                stmt = null;
                rs = null;
                map = 0L;
                try {
                    block19: {
                        stmt = this.m_con.createStatement();
                        rs = stmt.executeQuery(statement);
                        if (!rs.next()) break block19;
                        map = rs.getLong(1);
                    }
                    var11_8 = null;
                    ** if (stmt == null) goto lbl-1000
                }
                catch (Throwable var10_15) {
                    var11_10 = null;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    throw var10_15;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block20;
                    catch (SQLException e) {
                        exception = e;
                        var11_9 = null;
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException e) {}
                        }
                    }
                }
            }
            if (exception == null) {
                if (map > 0L) {
                    html.append("MySQL system variable <code>'max_allowed_packet'</code> is set to ");
                    html.append(map);
                    html.append(" Bytes.<p>\n");
                }
                html.append("Please, note that it will not be possible for OpenCms to handle files bigger than this value.<p>\n");
                if (map < 0xF00000L) {
                    this.m_errors.addElement("<b>Your <code>'max_allowed_packet'</code> variable is set to less than 16Mb (" + map + ").</b>\n" + "The recommended value for running OpenCms is 16Mb." + "Please change your MySQL configuration (in your <code>mi.ini</code> or <code>my.cnf</code> file).\n");
                }
            }
        }
        if (exception != null || db.equals("mysql_3")) {
            html.append("<i>OpenCms was not able to detect the value of your <code>'max_allowed_packet'</code> variable.</i><p>\n");
            html.append("Please, note that it will not be possible for OpenCms to handle files bigger than this value.<p>\n");
            html.append("<b>The recommended value for running OpenCms is 16Mb, please set it in your MySQL configuration (in your <code>mi.ini</code> or <code>my.cnf</code> file).</b>\n");
            if (exception != null) {
                html.append(CmsException.getStackTraceAsString((Throwable)exception));
            }
        }
        if (html.length() == 0) {
            return null;
        }
        return html.toString();
    }

    public void clearErrors() {
        this.m_errors.clear();
    }

    public void closeConnection() {
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_con = null;
    }

    public void createDatabase(String database, Map replacer) {
        this.m_errorLogging = true;
        this.executeSql(database, "create_db.sql", replacer, true);
    }

    public void createDatabase(String database, Map replacer, boolean abortOnError) {
        this.m_errorLogging = true;
        this.executeSql(database, "create_db.sql", replacer, abortOnError);
    }

    public void createTables(String database, Map replacer) {
        this.m_errorLogging = true;
        this.executeSql(database, "create_tables.sql", replacer, true);
    }

    public void createTables(String database, Map replacer, boolean abortOnError) {
        this.m_errorLogging = true;
        this.executeSql(database, "create_tables.sql", replacer, abortOnError);
    }

    public void dropDatabase(String database, Map replacer) {
        this.m_errorLogging = true;
        this.executeSql(database, "drop_db.sql", replacer, false);
    }

    public void dropDatabase(String database, Map replacer, boolean abortOnError) {
        this.m_errorLogging = true;
        this.executeSql(database, "drop_db.sql", replacer, abortOnError);
    }

    public void dropTables(String database) {
        this.m_errorLogging = true;
        this.executeSql(database, "drop_tables.sql", null, false);
    }

    public void dropTables(String database, Map replacer) {
        this.m_errorLogging = true;
        this.executeSql(database, "drop_tables.sql", replacer, false);
    }

    public void dropTables(String database, Map replacer, boolean abortOnError) {
        this.m_errorLogging = true;
        this.executeSql(database, "drop_tables.sql", replacer, abortOnError);
    }

    public CmsSetupDBWrapper executeSqlStatement(String query, Map replacer) throws SQLException {
        CmsSetupDBWrapper dbwrapper = new CmsSetupDBWrapper(this.m_con);
        dbwrapper.createStatement();
        String queryToExecute = query;
        if (replacer != null) {
            queryToExecute = this.replaceTokens(query, replacer);
        }
        dbwrapper.excecuteQuery(queryToExecute);
        return dbwrapper;
    }

    public CmsSetupDBWrapper executeSqlStatement(String query, Map replacer, List params) throws SQLException {
        CmsSetupDBWrapper dbwrapper = new CmsSetupDBWrapper(this.m_con);
        String queryToExecute = query;
        if (replacer != null) {
            queryToExecute = this.replaceTokens(query, replacer);
        }
        dbwrapper.createPreparedStatement(queryToExecute, params);
        dbwrapper.excecutePreparedQuery();
        return dbwrapper;
    }

    public Connection getConnection() {
        return this.m_con;
    }

    public Vector getErrors() {
        return this.m_errors;
    }

    public boolean hasTableOrColumn(String table, String column) {
        String columnName;
        String tableName = table == null ? null : table.toUpperCase();
        boolean result = this.hasTableOrColumnCaseSensitive(tableName, columnName = column == null ? null : column.toUpperCase());
        if (!result) {
            tableName = table == null ? null : table.toLowerCase();
            columnName = column == null ? null : column.toLowerCase();
            result = result || this.hasTableOrColumnCaseSensitive(tableName, columnName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean hasTableOrColumnCaseSensitive(String table, String column) {
        boolean result;
        block14: {
            ResultSet set;
            block13: {
                String tablename;
                result = false;
                set = null;
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)column)) {
                    String colname;
                    set = this.m_con.getMetaData().getColumns(null, null, table, column);
                    if (set.next() && (colname = set.getString("COLUMN_NAME")).equalsIgnoreCase(column)) {
                        result = true;
                    }
                    break block13;
                }
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)table) || !(set = this.m_con.getMetaData().getTables(null, null, table, null)).next() || !(tablename = set.getString("TABLE_NAME")).equalsIgnoreCase(table)) break block13;
                result = true;
            }
            Object var7_8 = null;
            try {
                if (set != null) {
                    set.close();
                }
                break block14;
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
            break block14;
            {
                catch (SQLException e) {
                    e.printStackTrace();
                    result = false;
                    Object var7_9 = null;
                    try {
                        if (set != null) {
                            set.close();
                        }
                        break block14;
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (set != null) {
                        set.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        return result;
    }

    public boolean noErrors() {
        return this.m_errors.isEmpty();
    }

    public void setConnection(Connection conn) {
        this.m_con = conn;
    }

    public void setConnection(String DbDriver, String DbConStr, String DbConStrParams, String DbUser, String DbPwd) {
        String jdbcUrl = DbConStr;
        try {
            if (DbConStrParams != null) {
                jdbcUrl = jdbcUrl + DbConStrParams;
            }
            Class.forName(DbDriver).newInstance();
            this.m_con = DriverManager.getConnection(jdbcUrl, DbUser, DbPwd);
            System.out.print("OpenCms setup connection established: " + this.m_con);
            System.out.println(" [autocommit: " + this.m_con.getAutoCommit() + "]");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found exception: " + e);
            this.m_errors.addElement(Messages.get().getBundle().key("ERR_LOAD_JDBC_DRIVER_1", (Object)DbDriver));
            this.m_errors.addElement(CmsException.getStackTraceAsString((Throwable)e));
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
            this.m_errors.addElement(Messages.get().getBundle().key("ERR_DB_CONNECT_1", (Object)DbConStr));
            this.m_errors.addElement(CmsException.getStackTraceAsString((Throwable)e));
        }
    }

    public void updateDatabase(String updateScript, Map replacers) {
        StringReader reader = new StringReader(updateScript);
        this.executeSql(reader, replacers, true);
    }

    public void updateDatabase(String updateScript, Map replacers, boolean abortOnError) {
        StringReader reader = new StringReader(updateScript);
        this.executeSql(reader, replacers, abortOnError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateSqlStatement(String query, Map replacer, List params) throws SQLException {
        int result;
        String queryToExecute = query;
        if (replacer != null) {
            queryToExecute = this.replaceTokens(query, replacer);
        }
        PreparedStatement stmt = null;
        stmt = this.m_con.prepareStatement(queryToExecute);
        try {
            if (params != null) {
                for (int i = 0; i < params.size(); ++i) {
                    Object item = params.get(i);
                    if (item instanceof String) {
                        stmt.setString(i + 1, (String)item);
                    }
                    if (item instanceof Integer) {
                        Integer number = (Integer)item;
                        stmt.setInt(i + 1, number);
                    }
                    if (item instanceof Long) {
                        Long longNumber = (Long)item;
                        stmt.setLong(i + 1, longNumber);
                    }
                    if (item instanceof Integer || item instanceof String || item instanceof Long) continue;
                    try {
                        stmt.setBytes(i + 1, CmsDataTypeUtil.dataSerialize(item));
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!queryToExecute.startsWith("UPDATE CMS_ONLINE_STRUCTURE SET STRUCTURE_VERSION") && !queryToExecute.startsWith("UPDATE CMS_OFFLINE_STRUCTURE SET STRUCTURE_VERSION")) {
                System.out.println("executing query: " + queryToExecute);
                if (params != null && !params.isEmpty()) {
                    System.out.println("params: " + params);
                }
            }
            result = stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
        return result;
    }

    protected void finalize() throws Throwable {
        try {
            this.closeConnection();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void executeSql(Reader inputReader, Map replacers, boolean abortOnError) {
        block24: {
            String statement = "";
            LineNumberReader reader = null;
            String line = null;
            reader = new LineNumberReader(inputReader);
            while ((line = reader.readLine()) != null) {
                String currentToken;
                StringTokenizer st = new StringTokenizer(line);
                while (st.hasMoreTokens() && !(currentToken = st.nextToken()).startsWith("#") && !currentToken.startsWith("prompt")) {
                    statement = statement + " " + currentToken;
                    if (!currentToken.endsWith(";")) continue;
                    statement = statement.substring(0, statement.length() - 1);
                    try {
                        if (replacers != null) {
                            statement = this.replaceTokens(statement, replacers);
                            this.executeStatement(statement);
                        } else {
                            this.executeStatement(statement);
                        }
                    }
                    catch (SQLException e) {
                        if (!abortOnError) {
                            if (this.m_errorLogging) {
                                this.m_errors.addElement("Error executing SQL statement: " + statement);
                                this.m_errors.addElement(CmsException.getStackTraceAsString((Throwable)e));
                            }
                        }
                        throw e;
                    }
                    statement = "";
                }
                statement = statement + " \n";
            }
            Object var11_12 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block24;
            }
            catch (Exception e2) {}
            break block24;
            {
                catch (SQLException e) {
                    if (this.m_errorLogging) {
                        this.m_errors.addElement("Error executing SQL statement: " + statement);
                        this.m_errors.addElement(CmsException.getStackTraceAsString((Throwable)e));
                    }
                    Object var11_13 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block24;
                    }
                    catch (Exception e2) {}
                    break block24;
                }
                catch (Exception e) {
                    if (this.m_errorLogging) {
                        this.m_errors.addElement("Error parsing database setup SQL script in line: " + line);
                        this.m_errors.addElement(CmsException.getStackTraceAsString((Throwable)e));
                    }
                    Object var11_14 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block24;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void executeSql(String databaseKey, String sqlScript, Map replacers, boolean abortOnError) {
        block2: {
            String filename = null;
            try {
                filename = this.m_basePath + "setup" + File.separator + "database" + File.separator + databaseKey + File.separator + sqlScript;
                this.executeSql(new FileReader(filename), replacers, abortOnError);
            }
            catch (FileNotFoundException e) {
                if (!this.m_errorLogging) break block2;
                this.m_errors.addElement("Database setup SQL script not found: " + filename);
                this.m_errors.addElement(CmsException.getStackTraceAsString((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStatement(String statement) throws SQLException {
        Statement stmt = null;
        try {
            stmt = this.m_con.createStatement();
            stmt.execute(statement);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private String replaceTokens(String sql, Map replacers) {
        Iterator keys = replacers.entrySet().iterator();
        while (keys.hasNext()) {
            Map.Entry entry = keys.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            sql = CmsStringUtil.substitute((String)sql, (String)key, (String)value);
        }
        return sql;
    }
}

