/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;

public class CmsSetupLoggingThread
extends Thread {
    private LineNumberReader m_lineReader;
    private FileWriter m_logWriter;
    private List m_messages;
    private PipedInputStream m_pipedIn;
    private PipedOutputStream m_pipedOut;
    private boolean m_stopThread;

    public CmsSetupLoggingThread(PipedOutputStream pipedOut, String log) {
        super("OpenCms: Setup logging");
        this.m_pipedOut = pipedOut;
        this.m_messages = new ArrayList();
        this.m_stopThread = false;
        if (log != null) {
            try {
                File logFile = new File(log);
                if (logFile.exists()) {
                    logFile.delete();
                }
                this.m_logWriter = new FileWriter(logFile);
            }
            catch (Throwable t) {
                this.m_logWriter = null;
            }
        } else {
            this.m_logWriter = null;
        }
        try {
            this.m_pipedIn = new PipedInputStream();
            this.m_pipedIn.connect(this.m_pipedOut);
            this.m_lineReader = new LineNumberReader(new BufferedReader(new InputStreamReader(this.m_pipedIn)));
        }
        catch (Exception e) {
            this.m_messages.add(e.toString());
        }
    }

    public List getMessages() {
        return this.m_messages;
    }

    public boolean isFinished() {
        return this.m_stopThread;
    }

    public void run() {
        int lineNr = 0;
        int lastLineNr = -1;
        String line = null;
        while (!this.m_stopThread) {
            lineNr = this.m_lineReader.getLineNumber();
            try {
                line = this.m_lineReader.readLine();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (line == null || lineNr <= lastLineNr) continue;
            String content = lineNr + 1 + ":\t" + line;
            this.m_messages.add(content);
            lastLineNr = lineNr;
            if (this.m_logWriter == null) continue;
            try {
                this.m_logWriter.write(content + "\n");
            }
            catch (IOException e) {
                this.m_logWriter = null;
            }
        }
        try {
            this.m_pipedIn.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.m_logWriter != null) {
            try {
                this.m_logWriter.close();
            }
            catch (IOException e) {
                this.m_logWriter = null;
            }
        }
    }

    public void stopThread() {
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_stopThread = true;
    }
}

