/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.comptest;

import org.opencms.setup.CmsSetupBean;
import org.opencms.setup.comptest.CmsSetupTestResult;
import org.opencms.setup.comptest.I_CmsSetupTest;

public class CmsSetupTestServletContainer
implements I_CmsSetupTest {
    public static final String TEST_NAME = "Servlet Container";

    public String getName() {
        return TEST_NAME;
    }

    public CmsSetupTestResult execute(CmsSetupBean setupBean) {
        CmsSetupTestResult testResult = new CmsSetupTestResult(this);
        String[][] supportedContainers = new String[][]{{"Apache Tomcat/4.1", null}, {"Apache Tomcat/5", null}, {"Apache Tomcat/6", null}, {"WebLogic Server 9", null}, {"Resin/3", "Please be sure that during the Setup Wizard, the web application auto-redeployment feature is deactivated. One way to achieve this, is to set the '<code>dependency-check-interval</code>' option in your <code>resin.conf</code> configuration file to <code>-1</code> or something big like <code>2000s</code>."}, {"IBM WebSphere Application Server/6", "The only limitation found so far, is that when using the <code>sendRedirect</code> method you have always to use an absolute path."}};
        String[][] unsupportedContainers = new String[][]{{"Tomcat Web Server/3", "Tomcat 3.x is no longer supported. Please use at least Tomcat 4.1 instead."}, {"Apache Tomcat/4.0", "Tomcat 4.0.x is no longer supported. Please use at least Tomcat 4.1 instead."}, {"Resin/2", "The OpenCms JSP integration does not work with Resin 2.x. Please use Resin 3 instead."}, {"IBM WebSphere Application Server/5", "OpenCms has problems with the way Websphere handles the <code>sendRedirect</code> method. Please use at least WebSphere 6 instead."}};
        String servletContainer = setupBean.getServletConfig().getServletContext().getServerInfo();
        testResult.setResult(servletContainer);
        int supportedServletContainer = this.hasSupportedServletContainer(servletContainer, supportedContainers);
        int unsupportedServletContainer = this.unsupportedServletContainer(servletContainer, unsupportedContainers);
        if (unsupportedServletContainer > -1) {
            testResult.setRed();
            testResult.setInfo(unsupportedContainers[unsupportedServletContainer][1]);
            testResult.setHelp("This servlet container does not work with OpenCms. Even though OpenCms is fully standards compliant, the standard leaves some 'grey' (i.e. undefined) areas. Please consider using another, supported servlet container.");
        } else if (supportedServletContainer < 0) {
            testResult.setYellow();
            testResult.setHelp("This servlet container has not been tested with OpenCms. Please consider using another, supported servlet container.");
        } else if (supportedContainers[supportedServletContainer][1] != null) {
            testResult.setInfo(supportedContainers[supportedServletContainer][1]);
        } else {
            testResult.setGreen();
        }
        return testResult;
    }

    private int hasSupportedServletContainer(String thisContainer, String[][] supportedContainers) {
        for (int i = 0; i < supportedContainers.length; ++i) {
            if (thisContainer.indexOf(supportedContainers[i][0]) < 0) continue;
            return i;
        }
        return -1;
    }

    private int unsupportedServletContainer(String thisContainer, String[][] unsupportedContainers) {
        for (int i = 0; i < unsupportedContainers.length; ++i) {
            if (thisContainer.indexOf(unsupportedContainers[i][0]) < 0) continue;
            return i;
        }
        return -1;
    }
}

