/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.comptest;

import com.alkacon.simapi.RenderSettings;
import com.alkacon.simapi.Simapi;
import com.alkacon.simapi.filter.RotateFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import org.opencms.setup.CmsSetupBean;
import org.opencms.setup.comptest.CmsSetupTestResult;
import org.opencms.setup.comptest.I_CmsSetupTest;

public class CmsSetupTestSimapi
implements I_CmsSetupTest {
    public static final String TEST_NAME = "Image Processing";

    public String getName() {
        return TEST_NAME;
    }

    public CmsSetupTestResult execute(CmsSetupBean setupBean) {
        CmsSetupTestResult testResult = new CmsSetupTestResult(this);
        boolean ok = true;
        Throwable ex = null;
        try {
            RenderSettings settings = new RenderSettings(0);
            settings.setCompressionQuality(0.85f);
            Simapi simapi = new Simapi(settings);
            ImageIO.scanForPlugins();
            Iterator<ImageReader> pngReaders = ImageIO.getImageReadersByFormatName("PNG");
            if (!pngReaders.hasNext()) {
                throw new Exception("No Java ImageIO readers for the PNG format are available.");
            }
            Iterator<ImageWriter> pngWriters = ImageIO.getImageWritersByFormatName("PNG");
            if (!pngWriters.hasNext()) {
                throw new Exception("No Java ImageIO writers for the PNG format are available.");
            }
            String basePath = setupBean.getWebAppRfsPath();
            if (!basePath.endsWith(File.separator)) {
                basePath = basePath + File.separator;
            }
            basePath = basePath + "setup" + File.separator + "resources" + File.separator;
            BufferedImage img1 = Simapi.read((String)(basePath + "test1.png"));
            BufferedImage img3 = simapi.applyFilter(img1, (ImageFilter)new RotateFilter((float)Math.PI));
            simapi.write(img3, basePath + "test3.png", "PNG");
            BufferedImage img2 = Simapi.read((String)(basePath + "test2.png"));
            ok = Arrays.equals(simapi.getBytes(img2, "PNG"), simapi.getBytes(img3, "PNG"));
        }
        catch (Throwable e) {
            ok = false;
            ex = e;
        }
        if (ok) {
            testResult.setResult("passed");
            testResult.setGreen();
        } else {
            testResult.setYellow();
            if (ex != null) {
                testResult.setResult("failed!");
                testResult.setHelp(ex.toString());
                testResult.setInfo("<p><code>-Djava.awt.headless=true</code> JVM parameter or X-Server may be missing.<br><b>You can continue the setup, but image processing will be disabled.</b></p>");
            } else {
                testResult.setResult("warning!");
                testResult.setHelp("Image processing works but result does not exactly match.");
                StringBuffer info = new StringBuffer();
                info.append("<p>Please check the following images for visible differences:</p>");
                info.append("<table width='100%'>");
                info.append("<tr><th>Expected</th><th>Result</th></tr>");
                info.append("<tr><td align='center' width='50%'><img src='resources/test2.png'></td>");
                info.append("<td align='center' width='50%'><img src='resources/test3.png'></td></table>");
                info.append("<p><b>You can continue the setup, but image processing may not always work as expected.</b></p>");
                testResult.setInfo(info.toString());
            }
        }
        return testResult;
    }
}

