/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.comptest;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.opencms.setup.CmsSetupBean;
import org.opencms.setup.comptest.CmsSetupTestFolderPermissions;
import org.opencms.setup.comptest.CmsSetupTestJavaTempDir;
import org.opencms.setup.comptest.CmsSetupTestJdkVersion;
import org.opencms.setup.comptest.CmsSetupTestOperatingSystem;
import org.opencms.setup.comptest.CmsSetupTestResult;
import org.opencms.setup.comptest.CmsSetupTestServletContainer;
import org.opencms.setup.comptest.CmsSetupTestSimapi;
import org.opencms.setup.comptest.CmsSetupTestWarFileUnpacked;
import org.opencms.setup.comptest.CmsSetupTestXercesVersion;
import org.opencms.setup.comptest.I_CmsSetupTest;

public class CmsSetupTests {
    private boolean m_green;
    private boolean m_red;
    private List m_testResults;
    private boolean m_yellow;

    public List getAllTests() {
        ArrayList<I_CmsSetupTest> tests = new ArrayList<I_CmsSetupTest>();
        tests.add(new CmsSetupTestFolderPermissions());
        tests.add(new CmsSetupTestJdkVersion());
        tests.add(new CmsSetupTestJavaTempDir());
        tests.add(new CmsSetupTestOperatingSystem());
        tests.add(new CmsSetupTestServletContainer());
        tests.add(new CmsSetupTestSimapi());
        tests.add(new CmsSetupTestWarFileUnpacked());
        tests.add(new CmsSetupTestXercesVersion());
        return tests;
    }

    public List getTestResults() {
        return this.m_testResults;
    }

    public boolean isGreen() {
        return this.m_green;
    }

    public boolean isRed() {
        return this.m_red;
    }

    public boolean isYellow() {
        return this.m_yellow;
    }

    public void runTests(CmsSetupBean setupBean) {
        CmsSetupTestResult testResult;
        boolean hasRed = false;
        boolean hasYellow = false;
        this.m_testResults = new ArrayList();
        this.setGreen();
        Iterator it = this.getAllTests().iterator();
        while (it.hasNext()) {
            I_CmsSetupTest test = (I_CmsSetupTest)it.next();
            testResult = null;
            try {
                testResult = test.execute(setupBean);
                this.m_testResults.add(testResult);
            }
            catch (Throwable e) {
                testResult = new CmsSetupTestResult(test);
                testResult.setRed();
                testResult.setResult("failed!");
                testResult.setHelp("Unable to test " + test.getName());
                testResult.setInfo(e.toString());
            }
        }
        for (int i = 0; i < this.m_testResults.size(); ++i) {
            testResult = (CmsSetupTestResult)this.m_testResults.get(i);
            if (testResult.isRed()) {
                hasRed = true;
                continue;
            }
            if (!testResult.isYellow()) continue;
            hasYellow = true;
        }
        if (hasRed) {
            this.setRed();
        } else if (!hasRed && hasYellow) {
            this.setYellow();
        } else {
            this.setGreen();
        }
        this.writeVersionInfo(setupBean.getServletConfig().getServletContext().getServerInfo(), System.getProperty("java.version"), setupBean.getWebAppRfsPath());
    }

    protected void setGreen() {
        this.m_green = true;
        this.m_red = false;
        this.m_yellow = false;
    }

    protected void setRed() {
        this.m_green = false;
        this.m_red = true;
        this.m_yellow = false;
    }

    protected void setYellow() {
        this.m_green = false;
        this.m_red = false;
        this.m_yellow = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeVersionInfo(String thisEngine, String usedJDK, String basePath) {
        block11: {
            OutputStreamWriter fOut = null;
            PrintWriter dOut = null;
            String filename = basePath + "setup/" + "versions.txt";
            File file = new File(filename);
            fOut = file.exists() ? new FileWriter(filename, true) : new FileWriter(file);
            dOut = new PrintWriter(fOut);
            dOut.println();
            dOut.println("############### currently used configuration ################");
            dOut.println("Date:                " + DateFormat.getDateTimeInstance().format(new Date(System.currentTimeMillis())));
            dOut.println("Used JDK:            " + usedJDK);
            dOut.println("Used Servlet Engine: " + thisEngine);
            dOut.close();
            Object var9_9 = null;
            try {
                if (fOut != null) {
                    fOut.close();
                }
                break block11;
            }
            catch (IOException e2) {}
            break block11;
            {
                catch (IOException e) {
                    Object var9_10 = null;
                    try {
                        if (fOut != null) {
                            fOut.close();
                        }
                        break block11;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (fOut != null) {
                        fOut.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

