/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.opencms.setup.CmsSetupDBWrapper;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.update6to7.I_CmsUpdateDBPart;
import org.opencms.util.CmsStringUtil;

public abstract class A_CmsUpdateDBPart
implements I_CmsUpdateDBPart {
    protected static final String QUERY_PROPERTIES_PREFIX = "org/opencms/setup/update6to7/";
    protected Map m_poolData;
    protected Map m_queries = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        CmsSetupDb setupDb = new CmsSetupDb(null);
        try {
            setupDb.setConnection((String)this.m_poolData.get("driver"), (String)this.m_poolData.get("url"), (String)this.m_poolData.get("params"), (String)this.m_poolData.get("user"), (String)this.m_poolData.get("pwd"));
            this.internalExecute(setupDb);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            setupDb.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I_CmsUpdateDBPart getDbInstance(String dbName, Map dbPoolData) {
        this.m_poolData = new HashMap(dbPoolData);
        if (dbName.indexOf("mysql") > -1) {
            String engine = "MYISAM";
            CmsSetupDb setupDb = new CmsSetupDb(null);
            CmsSetupDBWrapper db = null;
            try {
                block40: {
                    try {
                        setupDb.setConnection((String)this.m_poolData.get("driver"), (String)this.m_poolData.get("url"), (String)this.m_poolData.get("params"), (String)this.m_poolData.get("user"), (String)this.m_poolData.get("pwd"));
                        db = setupDb.executeSqlStatement("SHOW TABLE STATUS LIKE 'CMS_GROUPS';", null);
                        if (!db.getResultSet().next()) break block40;
                        engine = db.getResultSet().getString("Engine").toUpperCase();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        Object var8_13 = null;
                        if (db != null) {
                            db.close();
                        }
                        setupDb.closeConnection();
                    }
                }
                Object var8_12 = null;
                if (db != null) {
                    db.close();
                }
                setupDb.closeConnection();
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                if (db != null) {
                    db.close();
                }
                setupDb.closeConnection();
                throw throwable;
            }
            this.m_poolData.put("engine", engine);
            System.out.println("Table engine:               " + engine);
            return this.getInstanceForDb("mysql");
        }
        if (dbName.indexOf("oracle") > -1) {
            String dataTablespace = "users";
            String indexTablespace = "users";
            CmsSetupDb setupDb = new CmsSetupDb(null);
            try {
                setupDb.setConnection((String)this.m_poolData.get("driver"), (String)this.m_poolData.get("url"), (String)this.m_poolData.get("params"), (String)this.m_poolData.get("user"), (String)this.m_poolData.get("pwd"));
                CmsSetupDBWrapper db = null;
                try {
                    db = setupDb.executeSqlStatement("SELECT DISTINCT tablespace_name FROM user_tables", null);
                    if (db.getResultSet().next()) {
                        dataTablespace = db.getResultSet().getString(1).toLowerCase();
                    }
                }
                finally {
                    if (db != null) {
                        db.close();
                    }
                }
                try {
                    db = setupDb.executeSqlStatement("SELECT DISTINCT tablespace_name FROM user_indexes", null);
                    if (db.getResultSet().next()) {
                        indexTablespace = db.getResultSet().getString(1).toLowerCase();
                    }
                }
                finally {
                    if (db != null) {
                        db.close();
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                setupDb.closeConnection();
            }
            this.m_poolData.put("indexTablespace", indexTablespace);
            System.out.println("Index Tablespace:           " + indexTablespace);
            this.m_poolData.put("dataTablespace", dataTablespace);
            System.out.println("Data Tablespace:            " + dataTablespace);
            return this.getInstanceForDb("oracle");
        }
        if (dbName.indexOf("postgresql") > -1) {
            String dataTablespace = "pg_default";
            String indexTablespace = "pg_default";
            CmsSetupDb setupDb = new CmsSetupDb(null);
            try {
                setupDb.setConnection((String)this.m_poolData.get("driver"), (String)this.m_poolData.get("url"), (String)this.m_poolData.get("params"), (String)this.m_poolData.get("user"), (String)this.m_poolData.get("pwd"));
                CmsSetupDBWrapper db = null;
                try {
                    db = setupDb.executeSqlStatement("SELECT DISTINCT pg_tablespace.spcname FROM pg_class, pg_tablespace WHERE pg_class.relname='cms_user' AND pg_class.reltablespace = pg_tablespace.oid", null);
                    if (db.getResultSet().next()) {
                        dataTablespace = db.getResultSet().getString(1).toLowerCase();
                    }
                }
                finally {
                    if (db != null) {
                        db.close();
                    }
                }
                try {
                    db = setupDb.executeSqlStatement("SELECT DISTINCT pg_tablespace.spcname FROM pg_class, pg_tablespace WHERE pg_class.relname='cms_users_pkey' AND pg_class.reltablespace = pg_tablespace.oid", null);
                    if (db.getResultSet().next()) {
                        indexTablespace = db.getResultSet().getString(1).toLowerCase();
                    }
                }
                finally {
                    if (db != null) {
                        db.close();
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                setupDb.closeConnection();
            }
            this.m_poolData.put("indexTablespace", indexTablespace);
            System.out.println("Index Tablespace:           " + indexTablespace);
            this.m_poolData.put("dataTablespace", dataTablespace);
            System.out.println("Data Tablespace:            " + dataTablespace);
            return this.getInstanceForDb("postgresql");
        }
        System.out.println("db " + dbName + " not supported");
        return null;
    }

    public Map getPoolData() {
        return Collections.unmodifiableMap(this.m_poolData);
    }

    public String readQuery(String queryKey) {
        return (String)this.m_queries.get(queryKey);
    }

    public void setPoolData(Map poolData) {
        this.m_poolData = new HashMap(poolData);
    }

    protected abstract void internalExecute(CmsSetupDb var1) throws SQLException;

    protected boolean isKeepHistory() {
        Boolean keepHistory = (Boolean)this.m_poolData.get("keepHistory");
        return keepHistory != null && keepHistory != false;
    }

    protected void loadQueryProperties(String propertyFilename) throws IOException {
        Properties properties = new Properties();
        properties.load(this.getClass().getClassLoader().getResourceAsStream(propertyFilename));
        this.m_queries.putAll(properties);
    }

    private I_CmsUpdateDBPart getInstanceForDb(String dbName) {
        String clazz = this.getClass().getName();
        clazz = CmsStringUtil.substitute((String)clazz, (String)".generic.", (String)("." + dbName + "."));
        I_CmsUpdateDBPart updatePart = null;
        try {
            updatePart = (I_CmsUpdateDBPart)Class.forName(clazz).newInstance();
            updatePart.setPoolData(this.getPoolData());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return updatePart;
    }
}

