/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.opencms.setup.CmsSetupDb;
import org.opencms.setup.CmsUpdateBean;
import org.opencms.setup.update6to7.I_CmsUpdateDBPart;
import org.opencms.setup.update6to7.generic.CmsUpdateDBAlterTables;
import org.opencms.setup.update6to7.generic.CmsUpdateDBCmsUsers;
import org.opencms.setup.update6to7.generic.CmsUpdateDBContentTables;
import org.opencms.setup.update6to7.generic.CmsUpdateDBCreateIndexes7;
import org.opencms.setup.update6to7.generic.CmsUpdateDBDropBackupTables;
import org.opencms.setup.update6to7.generic.CmsUpdateDBDropOldIndexes;
import org.opencms.setup.update6to7.generic.CmsUpdateDBDropUnusedTables;
import org.opencms.setup.update6to7.generic.CmsUpdateDBHistoryPrincipals;
import org.opencms.setup.update6to7.generic.CmsUpdateDBHistoryTables;
import org.opencms.setup.update6to7.generic.CmsUpdateDBNewTables;
import org.opencms.setup.update6to7.generic.CmsUpdateDBProjectId;
import org.opencms.setup.update6to7.generic.CmsUpdateDBUpdateOU;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsUpdateDBManager {
    private String m_dbName;
    private Map m_dbPools = new HashMap();
    private List m_plugins;

    public String getDbDriver(String pool) {
        return (String)((Map)this.m_dbPools.get(pool)).get("driver");
    }

    public String getDbName() {
        return this.m_dbName;
    }

    public String getDbParams(String pool) {
        return (String)((Map)this.m_dbPools.get(pool)).get("params");
    }

    public String getDbUrl(String pool) {
        return (String)((Map)this.m_dbPools.get(pool)).get("url");
    }

    public String getDbUser(String pool) {
        return (String)((Map)this.m_dbPools.get(pool)).get("user");
    }

    public List getPools() {
        return new ArrayList(this.m_dbPools.keySet());
    }

    public String htmlPool(String pool) throws Exception {
        StringBuffer html = new StringBuffer(256);
        html.append("<a href=\"javascript:switchview('").append(pool).append("');\">");
        html.append(pool).append("</a><br>\n");
        html.append("\t<div id='").append(pool).append("' style='display: none;'>\n");
        html.append("\t\t<table border='0'>\n");
        html.append("\t\t\t<tr><td>JDBC Driver:</td><td>" + this.getDbDriver(pool) + "</td></tr>\n");
        html.append("\t\t\t<tr><td>JDBC Connection Url:</td><td>" + this.getDbUrl(pool) + "</td></tr>\n");
        html.append("\t\t\t<tr><td>JDBC Connection Url Params:</td><td>" + this.getDbParams(pool) + "</td></tr>\n");
        html.append("\t\t\t<tr><td>Database User:</td><td>" + this.getDbUser(pool) + "</td></tr>\n");
        html.append("\t\t</table>\n");
        html.append("\t</div>\n");
        return html.toString();
    }

    public void initialize(CmsUpdateBean updateBean) throws Exception {
        if (updateBean.isInitialized()) {
            ExtendedProperties props = updateBean.getProperties();
            CmsUUID.init((String)props.getString("server.ethernet.address"));
            this.m_dbName = props.getString("db.name");
            List pools = CmsStringUtil.splitAsList((String)props.getString("db.pools"), (char)',');
            Iterator it = pools.iterator();
            while (it.hasNext()) {
                String pool = (String)it.next();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("driver", props.getString("db.pool." + pool + ".jdbcDriver"));
                data.put("url", props.getString("db.pool." + pool + ".jdbcUrl"));
                data.put("params", props.getString("db.pool." + pool + ".jdbcUrl.params"));
                data.put("user", props.getString("db.pool." + pool + ".user"));
                data.put("pwd", props.getString("db.pool." + pool + ".password"));
                data.put("keepHistory", updateBean.isKeepHistory());
                this.m_dbPools.put(pool, data);
            }
        } else {
            throw new Exception("setup bean not initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needUpdate() {
        String pool = "default";
        int currentVersion = 7;
        int detectedVersion = 7;
        CmsSetupDb setupDb = new CmsSetupDb(null);
        try {
            setupDb.setConnection(this.getDbDriver(pool), this.getDbUrl(pool), this.getDbParams(pool), this.getDbUser(pool), (String)((Map)this.m_dbPools.get(pool)).get("pwd"));
            if (!setupDb.hasTableOrColumn("CMS_USERS", "USER_OU")) {
                detectedVersion = 6;
            }
        }
        finally {
            setupDb.closeConnection();
        }
        return currentVersion > detectedVersion;
    }

    public void run() {
        try {
            this.m_plugins = new ArrayList();
            this.m_plugins.add(new CmsUpdateDBDropOldIndexes());
            this.m_plugins.add(new CmsUpdateDBUpdateOU());
            this.m_plugins.add(new CmsUpdateDBCmsUsers());
            this.m_plugins.add(new CmsUpdateDBProjectId());
            this.m_plugins.add(new CmsUpdateDBNewTables());
            this.m_plugins.add(new CmsUpdateDBHistoryTables());
            this.m_plugins.add(new CmsUpdateDBHistoryPrincipals());
            this.m_plugins.add(new CmsUpdateDBDropUnusedTables());
            this.m_plugins.add(new CmsUpdateDBContentTables());
            this.m_plugins.add(new CmsUpdateDBAlterTables());
            this.m_plugins.add(new CmsUpdateDBDropBackupTables());
            this.m_plugins.add(new CmsUpdateDBCreateIndexes7());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        Iterator it = this.getPools().iterator();
        while (it.hasNext()) {
            String dbPool = (String)it.next();
            System.out.println("Starting DB Update for pool " + dbPool + "... ");
            try {
                this.updateDatabase(dbPool);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.out.println("... DB Update finished for " + dbPool + ".");
        }
    }

    public void updateDatabase(String pool) {
        HashMap dbPoolData = new HashMap((Map)this.m_dbPools.get(pool));
        System.out.println("JDBC Driver:                " + this.getDbDriver(pool));
        System.out.println("JDBC Connection Url:        " + this.getDbUrl(pool));
        System.out.println("JDBC Connection Url Params: " + this.getDbParams(pool));
        System.out.println("Database User:              " + this.getDbUser(pool));
        Iterator it = this.m_plugins.iterator();
        while (it.hasNext()) {
            I_CmsUpdateDBPart updatePart = (I_CmsUpdateDBPart)it.next();
            I_CmsUpdateDBPart dbUpdatePart = updatePart.getDbInstance(this.getDbName(), dbPoolData);
            if (dbUpdatePart == null) continue;
            dbUpdatePart.execute();
        }
    }
}

