/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.setup.update6to7;

import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSystemInfo;
import org.opencms.setup.CmsSetupLoggingThread;
import org.opencms.setup.CmsUpdateBean;
import org.opencms.setup.update6to7.CmsUpdateDBManager;

public class CmsUpdateDBThread
extends Thread {
    public PrintStream m_tempErr;
    private CmsSetupLoggingThread m_loggingThread;
    private PipedOutputStream m_pipedOut;
    private CmsUpdateBean m_updateBean;
    private PrintStream m_tempOut;

    public CmsUpdateDBThread(CmsUpdateBean updateBean) {
        super("OpenCms: Database Update");
        this.m_updateBean = updateBean;
        this.m_pipedOut = new PipedOutputStream();
        this.m_loggingThread = new CmsSetupLoggingThread(this.m_pipedOut, this.m_updateBean.getWebAppRfsPath() + CmsSystemInfo.FOLDER_WEBINF + CmsLog.FOLDER_LOGS + "db-update.log");
    }

    public CmsSetupLoggingThread getLoggingThread() {
        return this.m_loggingThread;
    }

    public boolean isFinished() {
        return this.m_loggingThread.isFinished();
    }

    public void kill() {
        if (this.m_loggingThread != null) {
            this.m_loggingThread.stopThread();
        }
        this.m_updateBean = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block8: {
            this.m_tempOut = System.out;
            this.m_tempErr = System.err;
            try {
                System.setOut(new PrintStream(this.m_pipedOut));
                System.setErr(new PrintStream(this.m_pipedOut));
                this.m_loggingThread.start();
                System.out.println("Starting DB Update... ");
                CmsUpdateDBManager dbMan = new CmsUpdateDBManager();
                try {
                    dbMan.initialize(this.m_updateBean);
                    dbMan.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("... DB Update finished.");
                Object var4_3 = null;
                this.kill();
                if (this.m_pipedOut == null) break block8;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.kill();
                if (this.m_pipedOut != null) {
                    try {
                        this.m_pipedOut.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                System.setOut(this.m_tempOut);
                System.setErr(this.m_tempErr);
                throw throwable;
            }
            try {
                this.m_pipedOut.close();
                break block8;
            }
            catch (IOException e) {
                // empty catch block
            }
            {
            }
        }
        System.setOut(this.m_tempOut);
        System.setErr(this.m_tempErr);
    }
}

